% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heterogeneity.R
\name{heterogeneity_CLAN}
\alias{heterogeneity_CLAN}
\title{Evaluate treatment effect heterogeneity along CLAN variables}
\usage{
heterogeneity_CLAN(x, learner = "best", significance_level = 0.05)
}
\arguments{
\item{x}{An object of class \code{"\link{GenericML}"}, as returned by the function \code{\link{GenericML}()}.}

\item{learner}{A character string of the learner whose CLAN generic target estimates are of interest. Default is \code{"best"} for the best learner for CLAN.}

\item{significance_level}{Level for the significance tests. Default is 0.05.}
}
\value{
An object of class \code{"heterogeneity_CLAN"}, consisting of the following components:
\describe{
\item{\code{p_values}}{A matrix of p values of all CLAN difference parameters for all CLAN variables.}
\item{\code{significant}}{The names of variables with at least one significant CLAN difference parameter (\code{"variables"}), their number \code{"num_variables"}, and the total number of significant CLAN difference parameters \code{"num_params"}. All significance tests were performed at level \code{significance_level}.}
\item{\code{min_pval}}{Information on the smallest p value: Its value (\code{"value"}), the variable in which it was estimated (\code{"variable"}), the CLAN difference parameter it belongs to (\code{"parameter"}), and whether or not it is significant at level \code{significance_level} (\code{"significant"}).}
\item{\code{"learner"}}{Name of the learner whose median estimates we used for the listed results.}
\item{\code{"significance_level"}}{The level of the significance tests.}
}
}
\description{
This function tests for statistical significance of all CLAN difference parameters that were specified in the function \code{\link{setup_diff}()}. It reports all CLAN variables along which there are significant difference parameters, which corresponds to evidence for treatment effect heterogeneity along this variable, at the specified significance level.
}
\seealso{
\code{\link{GenericML}()}
}
