% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regex.R
\name{rmByName}
\alias{rmByName}
\title{Remove Elements with Specified Name Regex}
\usage{
rmByName(x, pattern, silent = FALSE)
}
\arguments{
\item{x}{An indexable object (e.g., a named vector, list, or data frame).}

\item{pattern}{A character containing a regular expression(s) to match the
names of elements to be removed.}

\item{silent}{A logical indicating whether to silence a warning if no names
are detected.}
}
\value{
The input object with elements removed based on the name regex.
}
\description{
This function removes elements from an indexable object (e.g., a named vector
or list)
where the names match a specified regular expression.
}
\examples{
myList <- list(a = 1, b_test = 2, c = 3, d_test = 4)
rmByName(myList, "_test")

}
\keyword{regex}
