% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spelling.R
\name{isSnakeCase}
\alias{isSnakeCase}
\title{Check if String is snake_case}
\usage{
isSnakeCase(x, strict = TRUE)
}
\arguments{
\item{x}{A character string to check.}

\item{strict}{Logical indicating whether the string should strictly contain
only lowercase letters (TRUE) or can include uppercase ones (FALSE).
Default is TRUE.}
}
\value{
TRUE if the string is snake_case according to the specified
strictness, FALSE otherwise.
}
\description{
This function checks if a given string adheres to snake_case naming
conventions. By default (strict = TRUE), it only allows lowercase letters
separated by underscores. If strict is FALSE, uppercase letters are also
permitted.
}
\examples{
isSnakeCase("snake_case")        # returns TRUE
isSnakeCase("Snake_Case")        # returns FALSE
isSnakeCase("snake_case", FALSE) # returns TRUE
isSnakeCase("Snake_Case", FALSE) # returns TRUE

}
\keyword{spelling}
