% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iteration.R
\name{enumerateit}
\alias{enumerateit}
\title{Enumerate Elements with Indices}
\usage{
enumerateit(..., zeroIndexed = FALSE)
}
\arguments{
\item{...}{Vectors or lists to be enumerated.}

\item{zeroIndexed}{A logical indicating whether indexing should start from
zero. Default is FALSE.}
}
\value{
A list of lists, where each inner list contains an index and the
corresponding elements from the input vectors or lists.
}
\description{
This function pairs elements of vectors or lists with their indices. The
output
is meant to be used in a for loop, and each element extracted with the
\code{\link[=ind]{ind()}}, \code{\link[=val]{val()}}, or \code{\link[=val1]{val1()}} functions. A slightly lighter weight
alternative to \code{itertools::enumerate()}
}
\examples{
# Enumerate a vector
enumerateit(c("a", "b", "c"))
# Enumerate a vector starting from zero
enumerateit(c("a", "b", "c"), zero_indexed = TRUE)
# Enumerate two vectors
enumerateit(c(1, 2), c("x", "y"))
}
\seealso{
\code{\link[=ind]{ind()}}, \code{\link[=val]{val()}}, \code{\link[=val1]{val1()}}
}
\keyword{iteration}
