\name{calculate_sentiment_stats}
\alias{calculate_sentiment_stats}

\title{
Calculate Sentiment Statistics
}
\description{
This function calculates comprehensive statistics for sentiment analysis.
}
\usage{
calculate_sentiment_stats(data)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
A data.frame with sentiment analysis results.
}
}

\value{
List of statistical summaries.
}

\author{
Hossein Hassani and Leila Marvian Mashhad and Nadejda Komendantova.
}

\examples{
result_df <- data.frame(
  User_Comment = c(
    "The earthquake was terrible and scary",
    "Rescue teams are doing a wonderful job, I feel hopeful",
    "No damage here, everything feels normal"
  ),
  sentiment_score = c(-2.5, 3.0, -0.5),
  sentiment_category = c("Negative", "Positive", "Neutral"),
  stringsAsFactors = FALSE
)

stats <- calculate_sentiment_stats(result_df)

str(stats)

print("=== Overall Sentiment ===")
print(stats$overall_sentiment)

print("=== Extreme Comments ===")
print(stats$extreme_comments)

print("=== Summary Counts ===")
print(stats$summary)

}
