% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{transphobia}
\alias{transphobia}
\title{Data from a randomized experiment on transgender rights.}
\format{
A data frame with 501 observations and 19 variables.
}
\source{
\doi{10.1126/science.aad9713}
}
\usage{
data(transphobia)
}
\description{
A dataset from Broockman and Kalla (2016).
}
\details{
\itemize{
  \item treated. Indicator of transgender rights script (1) vs
 recycling script (0).
\item nondiscrim_law_t3. Support for transgender
 nondiscrimination law six weeks after treatment. 
\item therm_trans_t2. Subjective feelings about
 transgender people three weeks after treatment (0 = cool,
 1 = neutral, 2 = warm).
\item therm_obama_t1. Feeling thermometer score (0-100) for
 feeling warmth or coolness toward Barack Obama 3 days after
 treatment. 
\item gender_norm_moral_t1. Index of moral attitudes
 about gender 3 days after treatment.
\item nondiscrim_law_t0. Baseline support for transgender
 nondiscrimination law.
\item therm_trans_t0. Baseline subjective feelings about
 transgender people (0 = cool, 1 = neutral, 2 = warm).
\item therm_obama_t0. Baseline feeling thermometer score (0-100) for
 feeling warmth or coolness toward Barack Obama. 
\item gender_norm_moral_t0. Baseline index of moral attitudes
 about gender. 
\item ideology_t0. Baseline measure of ideology (conservative is higher).
\item religious_t0. Baseline measure of religiousity.
\item exposure_trans_t0. Baseline indicator for personal exposure to
 transgender people (1) or not (0).
\item pid_t0. Baseline party identification (-3 = Strong Democrat,
  3 = Strong Republican). 
\item vf_democrat. Indicator for if the unit identifies as a Democrat
 in the voter file (1) or not (0).
\item vf_female. Indicator for if the unit identifies as a woman
 in the voter file (1) or not (0).
\item vf_hispanic. Indicator for if the unit identifies as Hispanic
 in the voter file (1) or not (0).
\item vf_black. Indicator for if the unit identifies as Black
 in the voter file (1) or not (0).
\item vf_age. Age of the citizen in the voter file.
\item nondiscrim_law_diff. Difference between nondiscrim_law_t3 and
 nondiscrim_law_t0
}
}
\references{
Broockman, D. & Kalla, J. (2016). Durably reducing transphobia:
  A field experiment on door-to-door canvassing. Science, 352(6282),
  220-224. \doi{10.1126/science.aad9713}
}
