% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py_setup.R
\name{python_ready}
\alias{python_ready}
\title{Check for Python module availability and install if missing.}
\usage{
python_ready(
  modules = c("keras", "tensorflow", "numpy"),
  envname = "r-reticulate"
)
}
\arguments{
\item{modules}{Character vector of Python modules to check for and install if missing.}

\item{envname}{Name of the virtual environment to use or create. Defaults to "r-reticulate".}
}
\value{
Invisibly returns TRUE if setup is complete.
}
\description{
Call this to manually set up Python and dependencies. The function checks if Python is available via the \code{reticulate} package, and if not, it creates a virtual environment and installs the specified Python modules.
}
\examples{
\dontrun{
python_ready(modules = c("keras", "tensorflow", "numpy"),
            envname = "r-reticulate")
}
}
