% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatastreamUserCreated_TimeSeries.R
\name{DSTimeSeriesDataInput}
\alias{DSTimeSeriesDataInput}
\title{DSTimeSeriesDataInput}
\value{
DSTimeSeriesDataInput object
}
\description{
This class is a supporting attribute for the DateInput property of the DSTimeSeriesRequestObject.
It is used to supply the raw data for the timeseries.
}
\note{
Datastream takes the StartDate, Frequency and Values properties defined here and creates the timeseries based
only on these parameters.The EndDate is not actually used internally other than for logging purposes. The true end
date is calculated based on the start date, frequency and the supplied list of values. Supply too few or too many values
and the mainframe will accept them and set the end date accordingly based on the given frequency for the item.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{StartDate}}{A datetime value defining the start date for the timeseries.}

\item{\code{EndDate}}{A datetime value defining the end date for the timeseries.}

\item{\code{Frequency}}{The frequency of the timeseries. One of the DSUserObjectFrequency values defined in
DSUserDataObjectBase.R}

\item{\code{Values}}{An array of float values. Use NULL to represent NotANumber for non-trading days. Alternatively, if you
set the DatastreamUserCreated_TimeSeries property useNaNforNotANumber as True, you can use float NaN values.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DSTimeSeriesDataInput-new}{\code{DSTimeSeriesDataInput$new()}}
\item \href{#method-DSTimeSeriesDataInput-clone}{\code{DSTimeSeriesDataInput$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSTimeSeriesDataInput-new"></a>}}
\if{latex}{\out{\hypertarget{method-DSTimeSeriesDataInput-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSTimeSeriesDataInput$new(
  startDate = NULL,
  endDate = NULL,
  frequency = DSUserObjectFrequency$Daily,
  values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{startDate}}{A datetime value defining the start date for the timeseries.}

\item{\code{endDate}}{A datetime value defining the end date for the timeseries.}

\item{\code{frequency}}{The frequency of the timeseries.}

\item{\code{values}}{An array of float values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSTimeSeriesDataInput object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSTimeSeriesDataInput-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DSTimeSeriesDataInput-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSTimeSeriesDataInput$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
