% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeacoQC-class.R
\docType{class}
\name{PeacoQC-class}
\alias{PeacoQC-class}
\title{S4 PeacoQC Class}
\value{
A PeacoQC object
}
\description{
A PeacoQC object that holds pertinent PeacoQC data QC run information
This class should never be called explicitly. If a user would like to create a new Cytobank PeacoQC object, utilize the \link{peacoqc.new} function, or any other \link[=peacoqc]{PeacoQC endpoints that return PeacoQC objects documented in the 'Details' section}.
}
\section{Slots}{

\describe{
\item{\code{author}}{character representing the author of the PeacoQC analysis}

\item{\code{attachment_id}}{numeric representing the PeacoQC attachment to the source experiment containing the PeacoQC results}

\item{\code{channel_unique_identifiers}}{list of character representing a list of unique channel identifiers}

\item{\code{compensation_id}}{the compensation ID selected for the PeacoQC data QC}

\item{\code{completed}}{logical representing whether or not the PeacoQC is complete}

\item{\code{consecutive_bins}}{numeric if 'good' bins are located between bins that are removed, they will also be marked as 'bad'. Can be set to any integer between 1 and 50 (inclusive)}

\item{\code{detection_method}}{character representing the method(s) used to detect and filter out anomalies.
\emph{- choose from the following : \code{("all" [default], "IT", "MAD")}}}

\item{\code{errors}}{list of character representing a list of error messages of the PeacoQC}

\item{\code{failed}}{logical representing whether or not the PeacoQC is failed}

\item{\code{fcs_files}}{list of integers or character representing a list of FCS file IDs}

\item{\code{final_result}}{character representing whether or not the PeacoQC is successful}

\item{\code{heatmap_attachment_id}}{numeric representing the PeacoQC heatmap image attachment to the source experiment}

\item{\code{it_limit}}{numeric representing the IsolationTree parameter. Higher values mean the IT method will be less strict. Can be set to any float between 0.2 and 1.0(inclusive)}

\item{\code{mad}}{numeric representing the MAD parameter. Higher values mean the MAD method will be less strict. Can be set to any integer between 1 and 100 (inclusive)}

\item{\code{max_bins}}{numeric representing the maximum number of bins that can be used in the cleaning process. If this value is lowered, larger bins will be made. Can be set to any integer between 40 and 1,000,000 (inclusive)}

\item{\code{name}}{the name of the advanced analysis}

\item{\code{peaco_qc_id}}{numeric representing the PeacoQC ID}

\item{\code{remove_margins}}{if the value is true, they will remove margin events based on the internal description of the fcs file. Can be set to a boolean value}

\item{\code{source_experiment}}{the source experiment ID the advanced analysis is associated with}

\item{\code{status}}{character representing the status of the advanced analysis}

\item{\code{type}}{character}

\item{\code{use_internal_scales_for_margins}}{logical this parameter is required when removeMargins is set to true. Set to true, the events will transtorm with fcs file internal scales. Set to false, the events will transform with cytobank scales. Can be set to a boolean value}

\item{\code{validFcsFileIds}}{list of integers or character representing a list of valid FCS file IDs can run PeacoQC}
}}

