% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxFunC.R
\name{AuxFunC}
\alias{AuxFunC}
\title{Auxiliary functions using C}
\usage{
AuxFunC(data)
}
\arguments{
\item{data}{Matrix (x,y) of size n x 2}
}
\value{
\item{tau}{Kendall's tau}

\item{rho}{Spearman's rho}

\item{Fx}{Empirical cdf of x}

\item{Fxm}{Left-limit of the empirical cdf of x}

\item{Fy}{Empirical cdf of y}

\item{Fym}{Left-limit of the empirical cdf of y}
}
\description{
This function computes the empirical margins, their left-limits, Kendall's tau and Spearman's rho for arbitrary data
}
\examples{
data(simgumbel)
out=AuxFunC(simgumbel)


}
\references{
Nasri (2022). Test of serial dependence for arbitrary distributions. JMVA

Nasri & Remillard (2023). Tests of independence and randomness for arbitrary data using copula-based covariances, arXiv 2301.07267.
}
