% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcf_grid.R
\name{gcf_grid}
\alias{gcf_grid}
\title{Create contour plot from grid data using ggplot2}
\usage{
gcf_grid(
  x = seq(0, 1, length.out = nrow(z)),
  y = seq(0, 1, length.out = ncol(z)),
  z,
  xlim = range(x, finite = TRUE),
  ylim = range(y, finite = TRUE),
  zlim = range(z, finite = TRUE),
  with_lines = FALSE,
  lines_only = FALSE,
  bins = 8,
  interpolate = TRUE,
  levels = pretty(zlim, nlevels),
  nlevels = 20,
  color.palette = cm.colors.strong,
  col = color.palette(length(levels) - 1),
  asp = NA,
  las = 1,
  bar = F,
  pts = NULL,
  reset.par = TRUE,
  pretitle = "",
  posttitle = "",
  main = NULL,
  mainminmax = !bar,
  mainminmax_minmax = TRUE,
  afterplotfunc = NULL,
  cex.main = par()$cex.main,
  ...
)
}
\arguments{
\item{x}{x values, must form grid with y.
If not given, it is assumed to be from 0 to 1.}

\item{y}{y values, must form grid with x.
If not given, it is assumed to be from 0 to 1.}

\item{z}{z values at grid locations}

\item{xlim}{x limits for the plot.}

\item{ylim}{y limits for the plot.}

\item{zlim}{z limits for the plot.}

\item{with_lines}{Should lines be added on top of 
contour to show contours?}

\item{lines_only}{Should no fill be used, only contour lines?}

\item{bins}{Number of lines used when using `with_lines` or `lines_only`}

\item{interpolate}{Will smooth out contours}

\item{levels}{a set of levels which are used to partition the range of z.
Must be strictly increasing (and finite). Areas with z values between
consecutive levels are painted with the same color.}

\item{nlevels}{if levels is not specified, the range of z, values is
divided into approximately this many levels.}

\item{color.palette}{a color palette function to be used to assign colors
in the plot. Defaults to cm.colors. Other options include rainbow,
heat.colors, terrain.colors, topo.colors, and function(x) \{gray((1:x)/x)\}.}

\item{col}{an explicit set of colors to be used in the plot. This argument
overrides any palette function specification. There should be one less
color than levels}

\item{asp}{the y/x aspect ratio, see plot.window.}

\item{las}{the style of labeling to be used. The default is to use
horizontal labeling.}

\item{bar}{Should a bar showing the output range and colors be shown on the right?}

\item{pts}{Points to plot on top of contour}

\item{reset.par}{Should the graphical parameters be reset before exiting?
Usually should be unless you need to add something to the plot
afterwards and bar is TRUE.}

\item{pretitle}{Text to be preappended to end of plot title}

\item{posttitle}{Text to be appended to end of plot title}

\item{main}{Title for the plot}

\item{mainminmax}{whether the min and max values should be shown
in the title of plot}

\item{mainminmax_minmax}{Whether [min,max]= should be shown in title
or just the numbers}

\item{afterplotfunc}{Function to call after plotting, such as adding
points or lines.}

\item{cex.main}{The size of the main title. 1.2 is default.}

\item{...}{additional graphical parameters, currently only passed to title().}
}
\value{
ggplot2 object
}
\description{
The same as cf_grid_screen but uses ggplot2 for the plot.
}
\examples{
x <- y <- seq(-4*pi, 4*pi, len = 27)
r <- sqrt(outer(x^2, y^2, "+"))
gcf_grid(cos(r^2)*exp(-r/(2*pi)))
gcf_grid(r, color.palette=heat.colors, bar=TRUE)
gcf_grid(r, color.palette=function(x) {gray((1:x)/x)}, bar=TRUE)
}
