% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinpmatr.R
\name{combinpmatr}
\alias{combinpmatr}
\title{Combined input matrix with C++ optimization}
\usage{
combinpmatr(X, Wk = NULL, use_cpp = TRUE)
}
\arguments{
\item{X}{A data matrix N by M, in which there are N judges and M objects to be judged. 
Each row is a ranking of the objects which are represented by the columns. 
Alternatively X can contain the rankings observed only once. In this case the argument Wk must be used}

\item{Wk}{Optional: the frequency of each ranking in the data}

\item{use_cpp}{Logical. If TRUE (default), use the optimized C++ implementation. 
If FALSE, use the original R implementation.}
}
\value{
The M by M combined input matrix
}
\description{
Compute the Combined input matrix of a data set as defined by Emond and Mason (2002).
This version uses C++ for improved performance.
}
\details{
This function now uses an optimized C++ implementation (\code{combinpmatr_impl})
  for improved performance. The original R implementation is preserved for reference and
  can be accessed by setting \code{use_cpp = FALSE}.
  
  The C++ implementation provides significant speedup (typically 10-100x) compared to
  the R implementation, especially for large datasets with many judges and objects.
}
\examples{
# Simple example
X <- matrix(c(1,2,3,4, 2,1,4,3, 1,3,2,4), nrow=3, byrow=TRUE)
CI <- combinpmatr(X)

# With weights
CI_weighted <- combinpmatr(X, Wk=c(2, 1, 3))

# Compare implementations
\dontrun{
data(APAred) 
system.time(CI1 <- combinpmatr(APAred, use_cpp=TRUE))
system.time(CI2 <- combinpmatr(APAred, use_cpp=FALSE))
all.equal(CI1, CI2)  # Should be TRUE
}

}
\references{
Emond, E. J., and Mason, D. W. (2002). A new rank correlation coefficient 
  with application to the consensus ranking problem. Journal of Multi-Criteria Decision 
  Analysis, 11(1), 17-28.
}
\seealso{
\code{\link{tabulaterows}} frequency distribution of a ranking data.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
