% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getsubtree.R
\name{getsubtree}
\alias{getsubtree}
\title{Determine a tree from the main tree-based structure}
\usage{
getsubtree(Tree, cut, tokeep = NULL)
}
\arguments{
\item{Tree}{An object of the class "ranktree" coming form te function \code{ranktree}}

\item{cut}{The maximum number of terminal nodes that the Tree must have}

\item{tokeep}{parameter invoked by other internal functions}
}
\value{
An object of the class "ranktree", containing the same information of the output of the function \code{ranktree}
}
\description{
Given a tree belonging to the class "ranktree", determine a subtree with a given number of terminal nodes
}
\details{
If the pruning sequence returns a series of subtrees with, say, 1,2,4,7,9 terminal nodes and the user set cut=8, 
the function extract the subtree with 7 terminal nodes.
}
\examples{

data("Univranks")
tree <- ranktree(Univranks$rankings,Univranks$predictors,num=50)
#see how many terminal nodes have the trees compomimg the nested sequence of subtrees
infoprun <- tree$pruneinfo$termnodes
#select the tree with, say, 6 terminal nodes
tree6 <- getsubtree(tree,6)


}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
