% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptest.R
\name{ptest}
\alias{ptest}
\title{Permutation test for group differences at within-subject levels}
\usage{
ptest(
  data,
  outcome,
  within,
  between,
  at.within,
  at.between,
  pn = 1000,
  progress.bar = TRUE
)
}
\arguments{
\item{data}{dataframe that contains the data in long format.}

\item{outcome}{outcome variable (i.e., the variable for which the difference should be tested).}

\item{within}{within-subject variable.}

\item{between}{between-subjects variable.}

\item{at.within}{determine for which within-subject levels (e.g., which timepoint) the difference should be tested.}

\item{at.between}{determine the groups in the difference test (should always be of length 2).}

\item{pn}{the number of permutations that should be performed.}

\item{progress.bar}{indicates whether a progress bar will be shown.}
}
\value{
\code{ptest} produces an object of class \code{"clusbootptest"}, containing the following relevant components:
\item{perm.statistics}{A matrix of \code{length(at.within)} rows and \code{pn} columns, containing the Welch t-test statics for all permutations within the \code{at.within} level in the columns. The first column contains the t statistic for the observed data.}
\item{pvalues}{Data frame containing the p values for every \code{at.within} level.}
}
\description{
Perform permutation tests for differences between two groups at given within-subject levels in a long-formatted dataframe
}
\details{
In every permutation cycle, the outcome variable gets permutated and the Welch t test statistic is calculated.
}
\examples{
\dontrun{
meds <- medication[medication$time \%\% 1 == 0,]
set.seed(1)
permtest.1 <- ptest(data = meds, outcome = pos, within = time, between = treat, 
                    at.within = c(0,2,4,6), at.between = c(0,1), pn = 2000)
permtest.1$pvalues}
}
\seealso{
A useful method for the obtained \code{clusbootptest} class object is \code{\link{plot.clusbootptest}}.
}
\author{
Mathijs Deen, Mark de Rooij
}
