% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardization.R
\name{standardization}
\alias{standardization}
\title{Parametric Standardization}
\usage{
standardization(
  data,
  f = NA,
  family = gaussian(),
  simple = pkg.env$simple,
  n.boot = 50,
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables in the model.
This should be the same data used in \code{\link[=init_params]{init_params}}.}

\item{f}{(optional) an object of class "formula" that overrides the default parameter}

\item{family}{the family to be used in the general linear model.
By default, this is set to \code{\link[stats:gaussian]{gaussian}}.}

\item{simple}{a boolean indicator to build default formula with interactions.
If true, interactions will be excluded. If false, interactions will be included. By
default, simple is set to false.
NOTE: if this is changed, the coefficient for treatment may not accurately represent the average causal effect.}

\item{n.boot}{an integer value that indicates number of bootstrap iterations to calculate standard error.}

\item{...}{additional arguments that may be passed to the underlying \code{\link[stats:glm]{glm}} model.}
}
\value{
\code{standardization} returns an object of \code{\link[base:class]{class} "standardization"}.

The functions \code{print}, \code{summary}, and \code{predict} can be used to interact with
the underlying \code{glm} model.

An object of class \code{"standardization"} is a list containing the following:

\item{call}{the matched call.}
\item{formula}{the formula used in the model.}
\item{model}{the underlying glm model.}
\item{ATE}{a data frame containing estimates of the treatment effect
 of the observed, counterfactuals, and risk metrics.}
\item{ATE.summary}{a data frame containing the ATE, SE, and 95\% CI of the ATE. }
}
\description{
`standardization` uses a standard \code{\link[stats:glm]{glm}} linear model to perform parametric standardization
by adjusting bias through including all confounders as covariates. The model will calculate during training both the risk difference
and the risk ratio. Both can be accessed from the model as well as estimates of the counterfactuals of treatment.
}
\examples{
library(causaldata)

data(nhefs)
nhefs.nmv <- nhefs[which(!is.na(nhefs$wt82)), ]
nhefs.nmv$qsmk <- as.factor(nhefs.nmv$qsmk)

confounders <- c(
  "sex", "race", "age", "education", "smokeintensity",
  "smokeyrs", "exercise", "active", "wt71"
)

init_params(wt82_71, qsmk,
  covariates = confounders,
  data = nhefs.nmv
)

# model using all defaults
model <- standardization(data = nhefs.nmv)
print(model)
summary(model)
print(model$ATE.summary)
print(model$ATE.summary$Estimate[[2]] -
  model$ATE.summary$Estimate[[3]]) # manually calculate risk difference

}
