% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{acs_patients_df}
\alias{acs_patients_df}
\title{Acute Coronary Syndrome (ACS) Patient Data}
\format{
A data frame with 857 observations and 17 variables:
\describe{
\item{age}{Patient age in years (integer)}
\item{sex}{Patient sex (character)}
\item{cardiogenicShock}{Presence of cardiogenic shock (character)}
\item{entry}{Method of hospital entry (character)}
\item{Dx}{Diagnosis (character)}
\item{EF}{Ejection fraction percentage (numeric)}
\item{height}{Height in cm (numeric)}
\item{weight}{Weight in kg (numeric)}
\item{BMI}{Body Mass Index in kg/m² (numeric)}
\item{obesity}{Obesity status (character)}
\item{TC}{Total cholesterol in mg/dL (numeric)}
\item{LDLC}{LDL cholesterol in mg/dL (integer)}
\item{HDLC}{HDL cholesterol in mg/dL (integer)}
\item{TG}{Triglycerides in mg/dL (integer)}
\item{DM}{Diabetes mellitus status (character)}
\item{HBP}{High blood pressure status (character)}
\item{smoking}{Smoking status (character)}
}
}
\source{
Data taken from the moonBook package version 0.3.1
}
\usage{
data(acs_patients_df)
}
\description{
This dataset, acs_patients_df, is a data frame containing demographic and clinical
data from 857 patients with Acute Coronary Syndrome (ACS). It includes 17 variables
covering patient characteristics, vital signs, laboratory results, and risk factors.
}
\details{
The dataset name has been kept as 'acs_patients_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
