% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{bone_scan_check}
\alias{bone_scan_check}
\title{Check if surface model is fully contained within scan volume}
\usage{
bone_scan_check(surface_mesh, nifti, return_limits = FALSE)
}
\arguments{
\item{surface_mesh}{mesh object (class \code{mesh3d}) or numeric
matrix/dataframe of vertex coordinates (cols: X, Y, Z)}

\item{nifti}{NIfTI image object representing CT scan.}

\item{return_limits}{Logical. If TRUE returns a summary of the bounding boxes
of the scan and mesh}
}
\value{
If any vertices lie outside the scan volume, it
  raises an error.
}
\description{
Check if surface model is fully contained within scan volume
}
\examples{
\donttest{
  # Download CT scan
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_hip.nii.gz"
  scan_filepath <- tempfile(fileext = ".nii.gz")
  download.file(url, scan_filepath, mode = "wb")
  nifti <- import_scan(scan_filepath)
  url2 <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url2, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)
  bone_scan_check(surface_mesh, nifti, return_limits = TRUE)
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
