% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_variate_normal.R
\name{bi.dist.multivariate_normal}
\alias{bi.dist.multivariate_normal}
\title{Samples from a Multivariate Normal distribution.}
\usage{
bi.dist.multivariate_normal(
  loc = 0,
  covariance_matrix = py_none(),
  precision_matrix = py_none(),
  scale_tril = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{loc}{A numeric vector representing the mean vector of the distribution.}

\item{covariance_matrix}{A numeric vector, matrix, or array representing the covariance matrix of the distribution. Must be positive definite.}

\item{precision_matrix}{A numeric vector, matrix, or array representing the precision matrix (inverse of the covariance matrix) of the distribution. Must be positive definite.}

\item{scale_tril}{A numeric vector, matrix, or array representing the lower triangular Cholesky decomposition of the covariance matrix.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector representing an optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector representing the shape of the distribution.}

\item{event}{Integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{Logical; If TRUE, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Multivariate Normal distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Multivariate Normal distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The Multivariate Normal distribution, also known as the Gaussian distribution in multiple dimensions,
is a probability distribution that arises frequently in statistics and machine learning. It is
defined by its mean vector and covariance matrix, which describe the central tendency and
spread of the distribution, respectively.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.multivariate_normal(
loc =  c(1.0, 0.0, -2.0),
covariance_matrix = matrix(
c( 2.0,  0.7, -0.3, 0.7,  1.0,  0.5, -0.3,  0.5,  1.5),
nrow = 3, byrow = TRUE),
sample = TRUE)
}
}
\seealso{
\url{https://num.pyro.ai/en/stable/distributions.html#multivariate-normal}
}
