% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equilibrium_mean.R
\name{equilibrium_mean}
\alias{equilibrium_mean}
\title{Solves the inverse optimization to mean-risk standard optimization  problem  to find equilibrium returns.
The function is invoked by BL_post_distr and arguments are supplemented by BL_post_distr.}
\usage{
equilibrium_mean(dat, w_m, RM, risk = c("CVAR", "DCVAR", "LSAD", "MAD"),
  alpha = 0.95)
}
\arguments{
\item{dat}{Time series of returns data; dat = cbind(rr, pk), where \eqn{rr} is an array (time series) of market asset returns,
for \eqn{n} returns and \eqn{k} assets it is an array with \eqn{\dim(rr) = (n, k)},
\eqn{pk} is a vector of length \eqn{n} containing probabilities of returns.}

\item{w_m}{Market portfolio.}

\item{RM}{Market_expected_return.}

\item{risk}{A risk measure, one from the list  c("CVAR", "DCVAR", "LSAD", "MAD").}

\item{alpha}{Value of alpha quantile in the definition of risk measures CVAR and DCVAR. Can be any number when risk measure is parameter free.}
}
\value{
\tabular{llll}{
\code{market_returns}  \tab a vector of market returns obtain by inverse optimization; this is vector \eqn{E(r)}\cr

\code{ }  \tab  from the description of this function.
}
}
\description{
The function computes the vector of equilibrium returns implied by a market portfolio.
The vector of means for the mean-risk optimization problem is found by inverse optimization. \cr
The optimization problem is:\cr
\eqn{\min F(w_m^{T} r)}\cr
subject to\cr
\eqn{w_m^{T} E(r) \ge RM},\cr
where \cr
\eqn{F} is a risk measure -- one from the list  c("CVAR", "DCVAR", "LSAD", "MAD"),\cr
\eqn{r}  is a time series of market returns,\cr
\eqn{w_m}  is  market portfolio,\cr
\eqn{RM}  is  market expected return.
}
\examples{

# In normal usage all data are supplemented by function BL_post_distr.
library(mvtnorm)
k = 3 
num =100
dat <-  cbind(rmvnorm (n=num, mean = rep(0,k), sigma=diag(k)), matrix(1/num,num,1)) 
# a data sample with num rows and (k+1) columns for k assets;
w_m <- rep(1/k,k) # market portfolio.
RM = 0.05 # market expected return.
equilibrium_mean (dat, w_m, RM, risk = "CVAR", alpha = 0.95) 

}
\references{
Palczewski, J., Palczewski, A., Black-Litterman Model for Continuous Distributions (2016). Available at SSRN: https://ssrn.com/abstract=2744621.
}
