% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{fit_pHMM}
\alias{fit_pHMM}
\title{Fit a Partially Hidden Markov Model (pHMM)}
\usage{
fit_pHMM(
  y,
  xlabeled,
  nstates,
  ppi_start = NULL,
  A_start = NULL,
  mean_start,
  covariance_start = NULL,
  known_mean = NULL,
  known_covariance = NULL,
  equal_covariance = FALSE,
  covariance_structure = "full",
  max_iter = 200,
  tol = 0.001,
  verbose = FALSE
)
}
\arguments{
\item{y}{A numeric matrix of dimension \eqn{T \times d}, where each row
corresponds to a \eqn{d}-dimensional observation at time \eqn{t}.}

\item{xlabeled}{An integer vector of length \eqn{T} with partially observed
states. Known states must be integers in \eqn{1, \ldots, N}; unknown states
should be coded as \code{NA}.}

\item{nstates}{Integer. The total number of hidden states to fit.}

\item{ppi_start}{Numeric vector of length \code{nstates} giving the initial
state distribution. If \code{NULL}, defaults to \code{c(1,0,...,0)}.}

\item{A_start}{Numeric \code{nstates} \eqn{\times} \code{nstates} transition probability
matrix. If \code{NULL}, defaults to a transition matrix with diagonal
entries equal to \code{1-0.01*(nstates-1)} and all off-diagonal entries equal to \code{0.01}.}

\item{mean_start}{List of length \code{nstates} containing numeric mean
vectors for the emission distributions.}

\item{covariance_start}{List of covariance matrices for the emission
distributions. Must be of length \code{nstates}, unless
\code{equal_covariance = TRUE}, in which case it must be of length 1.
If \code{NULL}, defaults to identity matrices.}

\item{known_mean}{Optional list of known mean vectors. Use \code{NA} for
unknown elements.}

\item{known_covariance}{Optional list of known covariance matrices. Use
\code{NA} for unknown elements.}

\item{equal_covariance}{Logical. If \code{TRUE}, all states are constrained
to share a common covariance matrix.}

\item{covariance_structure}{Character string specifying the covariance
structure. Either \code{"full"} (default) or \code{"diagonal"}.}

\item{max_iter}{Maximum number of EM iterations. Default is 200.}

\item{tol}{Convergence tolerance for log-likelihood and parameter change.
Default is \code{1e-3}.}

\item{verbose}{Logical. If \code{TRUE}, prints log-likelihood progress at
each iteration.}
}
\value{
A list with components:
\itemize{
  \item \code{y}, \code{xlabeled}: the input data.
  \item \code{log_lik}, \code{log_lik_vec}: final and trace of log-likelihood.
  \item \code{iter}: number of EM iterations performed.
  \item \code{logB}, \code{log_alpha}, \code{log_beta}, \code{log_gamma},
        \code{log_xi}: posterior quantities from the Baum-Welch algorithm.
  \item \code{logAhat}, \code{mean_hat}, \code{covariance_hat},
        \code{log_pi_hat}: estimated model parameters.
  \item \code{AIC}, \code{BIC}: information criteria for model selection.
}
}
\description{
Fits a partially hidden Markov model (pHMM) to multivariate time series
observations \eqn{y} with partially observed process states \eqn{x}, using a
constrained Baum-Welch algorithm. The function allows the user to provide
custom initial parameters, and supports constraints on known means and/or
covariances, as well as equal or diagonal covariance structures.
}
\examples{
library(ActiveLearning4SPM)
set.seed(123)
dat <- simulate_stream(T0 = 100, TT = 500)
y <- dat$y
xlabeled <- dat$x
d <- ncol(dat$y)
xlabeled[sample(1:600, 300)] <- NA
out <- fit_pHMM(y = y,
                xlabeled = xlabeled,
                nstates = 3,
                mean_start = list(rep(0, d), rep(1, d), rep(-1, d)),
                equal_covariance = TRUE)
out$AIC

}
\references{
Capezza, C., Lepore, A., & Paynabar, K. (2025).
  Stream-Based Active Learning for Process Monitoring.
  \emph{Technometrics}. <doi:10.1080/00401706.2025.2561744>.
}
