## ----setup, include=FALSE-----------------------------------------------------
library(LearningRlab)
library(graphics)
knitr::opts_chunk$set(
  comment = "#>", 
  collapse = TRUE
)

## -----------------------------------------------------------------------------
data <- c(1,1,2,3,4,7,8,8,8,10,10,11,12,15,20,22,25)
plot(data); 
data2 <- c(1,1,4,5,5,5,7,8,10,10,10,11,20,22,22,24,25)
plot(data2);

#Binomial variables
n = 3
x = 2
p = 0.7
    
#Poisson variables
lam = 2
k = 3

#Normal variables
nor = 0.1

#T-Student variables
xt = 290 
ut = 310
st = 50
nt = 16


## -----------------------------------------------------------------------------
mean_(data)


## -----------------------------------------------------------------------------
geometricMean_(data)


## -----------------------------------------------------------------------------
mode_(data)


## -----------------------------------------------------------------------------
median_(data)


## -----------------------------------------------------------------------------
standardDeviation_(data)


## -----------------------------------------------------------------------------
averageDeviation_(data)


## -----------------------------------------------------------------------------
variance_(data)


## -----------------------------------------------------------------------------
quartile_(data)


## -----------------------------------------------------------------------------
percentile_(data,0.3)


## -----------------------------------------------------------------------------
frecuency_abs(data,1)


## -----------------------------------------------------------------------------
frecuency_relative(data,20)


## -----------------------------------------------------------------------------
frecuency_absolute_acum(data,1)


## -----------------------------------------------------------------------------
frecuency_relative_acum(data,20)


## -----------------------------------------------------------------------------
covariance_(data, data2)


## -----------------------------------------------------------------------------
harmonicMean_(data)


## -----------------------------------------------------------------------------
pearson_(data,data2)



## -----------------------------------------------------------------------------
cv_(data)



## -----------------------------------------------------------------------------
laplace_(data,data2)



## -----------------------------------------------------------------------------
binomial_(n,x,p)



## -----------------------------------------------------------------------------
poisson_(k,lam)



## -----------------------------------------------------------------------------
normal_(nor)



## -----------------------------------------------------------------------------
tstudent_(xt,ut,st,nt)



## -----------------------------------------------------------------------------
chisquared_(data,data2)



## -----------------------------------------------------------------------------
fisher_(data,data2)



## -----------------------------------------------------------------------------
explain.mean(data)


## -----------------------------------------------------------------------------
explain.geometricMean(data)


## -----------------------------------------------------------------------------
explain.mode(data)


## -----------------------------------------------------------------------------
explain.median(data)


## -----------------------------------------------------------------------------
explain.standardDeviation(data)


## -----------------------------------------------------------------------------
explain.averageDeviation(data)


## -----------------------------------------------------------------------------
explain.variance(data)


## -----------------------------------------------------------------------------
explain.quartile(data)


## -----------------------------------------------------------------------------
explain.percentile(data)


## -----------------------------------------------------------------------------
explain.absolute_frecuency(data,10)


## -----------------------------------------------------------------------------
explain.relative_frecuency(data,8)


## -----------------------------------------------------------------------------
explain.absolute_acum_frecuency(data,10)


## -----------------------------------------------------------------------------
explain.relative_acum_frecuency(data,8)


## -----------------------------------------------------------------------------
explain.covariance(data,data2)


## -----------------------------------------------------------------------------
explain.harmonicMean(data)



## -----------------------------------------------------------------------------
explain.pearson(data,data2)



## -----------------------------------------------------------------------------
explain.cv(data)



## -----------------------------------------------------------------------------
explain.laplace(data,data2)



## -----------------------------------------------------------------------------
explain.binomial(n,x,p)



## -----------------------------------------------------------------------------
explain.poisson(k,lam)



## -----------------------------------------------------------------------------
explain.normal(nor)



## -----------------------------------------------------------------------------
explain.tstudent(xt,ut,st,nt)



## -----------------------------------------------------------------------------
explain.chisquared(data,data2)



## -----------------------------------------------------------------------------
explain.fisher(data,data2)



