## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 4,
  dpi = 120
)
set.seed(1)

## ----message=FALSE, warning=FALSE---------------------------------------------
#Load required packages 
library(CircaCP)
library(ggplot2)

## -----------------------------------------------------------------------------
csv <- system.file("extdata", "NHANES_11111.csv", package = "CircaCP")

df <- import_acti_file(csv, "Date", "Time", "MIMS")

head(df)

## -----------------------------------------------------------------------------
screen_fun <- if (exists("screen_wear", mode = "function")) {
  screen_wear
} else {
  stop("No screening function (screen_wear*) found in CircaCP.")
}

out <- screen_fun(
  df,
  min_days     = 5,
  max_zero_run = 200
)

out$status

## -----------------------------------------------------------------------------
stopifnot(exists("sleep_cos", mode = "function"))
clean_df = out$clean_df
cos_df <- sleep_cos(clean_df, thr = 0.4)
cos_df$cos_para
cos_df$RMSE

## -----------------------------------------------------------------------------
stopifnot(exists("sleep_detection", mode = "function"))
clean_df = out$clean_df
newdf <- sleep_detection(clean_df, thr = 0.4, dist = "ZAG")
head(newdf)

## -----------------------------------------------------------------------------
ggplot2::ggplot(newdf, ggplot2::aes(x = seq_along(Activity))) +
    ggplot2::geom_line(ggplot2::aes(y = Activity_norm), alpha = 0.4) +
    ggplot2::geom_line(ggplot2::aes(y = cosinor/2), alpha = 0.4, color = "magenta") +
    ggplot2::geom_line(ggplot2::aes(y = label.cos), color = "blue") +
    ggplot2::labs(x = "Minute", y = "Activity", title = unique(newdf$id)) +
    ggplot2::scale_color_manual(
            name = NULL,
           values = c(
           "Activity (norm)" = "grey40",
           "Cosinor"     = "magenta",
            "Cosinor label"   = "blue"))+
  ggplot2::theme_bw(12)

## -----------------------------------------------------------------------------
ggplot2::ggplot(newdf, ggplot2::aes(x = seq_along(Activity))) +
    ggplot2::geom_line(ggplot2::aes(y = Activity_norm), alpha = 0.4) +
    ggplot2::geom_line(ggplot2::aes(y = cosinor/2), alpha = 0.4, color = "magenta") +
    ggplot2::geom_line(ggplot2::aes(y = label.sw), color = "forestgreen") +
    ggplot2::labs(x = "Minute", y = "Activity", title = unique(newdf$id)) +
    ggplot2::scale_color_manual(
            name = NULL,
           values = c(
           "Activity (norm)" = "grey40",
           "Cosinor / 2"     = "magenta",
            "Cosinor label"   = "blue",
            "Sleep/Wake"      = "forestgreen"))+
  ggplot2::theme_bw(12)

## -----------------------------------------------------------------------------
np <- extract_nonparametric_metrics(newdf, L_window = 300, M_window=600)
head(np)

## -----------------------------------------------------------------------------
if (exists("extract_sleep_metrics_df", mode = "function")) {
  metrics_df <- extract_sleep_metrics_df(newdf)
} else if (exists("extract_sleep_metrics", mode = "function")) {
  metrics_df <- extract_sleep_metrics(newdf)  # may be a list
} else {
  stop("No extract_sleep_metrics* function found.")
}
head(metrics_df)

