/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.FileIterator;
import blbutil.Filter;
import blbutil.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import vcf.VcfMetaInfo;

public final class VcfHeader {
    private static final String SHORT_HEADER_PREFIX = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO";
    public static final String HEADER_PREFIX = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";
    private static final int nShortHeaderFields = StringUtil.countFields("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO", '\t');
    private static final int nLongHeaderFields = StringUtil.countFields("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT", '\t');
    private final File file;
    private final VcfMetaInfo[] metaInfoLines;
    private final String headerLine;
    private final int nHeaderFields;
    private final Samples samples;
    private final boolean[] filter;

    public VcfHeader(FileIterator<String> fileIterator, Filter<String> filter) {
        Object object;
        ArrayList<VcfMetaInfo> arrayList = new ArrayList<VcfMetaInfo>(20);
        Object object2 = null;
        while (fileIterator.hasNext() && object2 == null) {
            object = ((String)fileIterator.next()).trim();
            if (((String)object).startsWith("##")) {
                arrayList.add(new VcfMetaInfo((String)object));
                continue;
            }
            if (((String)object).startsWith(SHORT_HEADER_PREFIX)) {
                object2 = object;
                continue;
            }
            VcfHeader.headerError((String)object, fileIterator.file());
        }
        assert (object2 != null);
        object = StringUtil.getFields(object2, '\t');
        int n = VcfHeader.nSamples((String[])object, object2, fileIterator.file());
        this.file = fileIterator.file();
        this.metaInfoLines = arrayList.toArray(new VcfMetaInfo[0]);
        this.headerLine = object2;
        this.nHeaderFields = ((Object)object).length;
        this.filter = new boolean[n];
        this.samples = VcfHeader.getSamplesAndSetFilter((String[])object, filter, this.filter);
    }

    private static boolean headerError(String string, File file) {
        Object[] objectArray;
        String string2 = "File source: " + (file != null ? file : "stdin or unknown");
        if (!string.startsWith("#")) {
            String string3 = "Missing line (#CHROM ...) after meta-information lines" + Const.nl + string2 + Const.nl + string;
            throw new IllegalArgumentException(string3);
        }
        Object[] objectArray2 = StringUtil.getFields(string, nShortHeaderFields);
        if (Arrays.equals(objectArray2 = Arrays.copyOf(objectArray2, nShortHeaderFields), objectArray = StringUtil.getFields(SHORT_HEADER_PREFIX, '\t'))) {
            String string4 = "Header line is white-space delimited, but not tab delimited" + Const.nl + string2 + Const.nl + string;
            throw new IllegalArgumentException(string4);
        }
        String string5 = "Error in meta-information line or header line" + Const.nl + string2 + Const.nl + string;
        throw new IllegalArgumentException(string5);
    }

    private static int nSamples(String[] stringArray, String string, File file) {
        if (stringArray.length == nShortHeaderFields) {
            return 0;
        }
        if (stringArray.length == nLongHeaderFields) {
            if (!stringArray[nLongHeaderFields - 1].equals("FORMAT")) {
                String string2 = "File source: " + (file != null ? file : "stdin or unknown");
                String string3 = "Ninth field of header line is not \"FORMAT\"" + Const.nl + string2 + Const.nl + string;
                throw new IllegalArgumentException(string3);
            }
            return 0;
        }
        return stringArray.length - nLongHeaderFields;
    }

    private static Samples getSamplesAndSetFilter(String[] stringArray, Filter<String> filter, boolean[] blArray) {
        if (blArray.length == 0) {
            return new Samples(new int[0]);
        }
        ArrayList<String> arrayList = new ArrayList<String>(blArray.length);
        for (int i = 0; i < blArray.length; ++i) {
            String string = stringArray[nLongHeaderFields + i];
            if (filter.accept(string)) {
                arrayList.add(string);
                continue;
            }
            blArray[i] = true;
        }
        return Samples.fromIds(arrayList.toArray(new String[0]));
    }

    public File file() {
        return this.file;
    }

    public int nMetaInfoLines() {
        return this.metaInfoLines.length;
    }

    public VcfMetaInfo metaInfoLine(int n) {
        return this.metaInfoLines[n];
    }

    public String headerLine() {
        return this.headerLine;
    }

    public boolean filter(int n) {
        return this.filter[n];
    }

    public int nHeaderFields() {
        return this.nHeaderFields;
    }

    public int nUnfilteredSamples() {
        return this.filter.length;
    }

    public Samples samples() {
        return this.samples;
    }

    public String[] sampleIds() {
        return this.samples.ids();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(400);
        for (int i = 0; i < this.metaInfoLines.length; ++i) {
            stringBuilder.append(this.metaInfoLines[i]);
            stringBuilder.append(Const.nl);
        }
        stringBuilder.append(this.headerLine);
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }
}

