/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromIds;
import blbutil.Const;
import blbutil.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Marker
implements Comparable<Marker> {
    private static final int MIN_NUMBER_FIELDS = 8;
    private static final String[] EMPTY_ID_ARRAY = new String[0];
    private static final Map<String, String[]> allelesMap = new HashMap<String, String[]>(24);
    private final int chromIndex;
    private final int pos;
    private final String[] ids;
    private final String id;
    private final String[] alleles;
    private final int nGenotypes;
    private final int end;

    public Marker(String string) {
        String[] stringArray = StringUtil.getFields(string, '\t', 9);
        if (stringArray.length < 8) {
            String string2 = "VCF record does not contain at least 8 tab-delimited fields: " + string;
            throw new IllegalArgumentException(string2);
        }
        for (int i = 0; i < 5; ++i) {
            stringArray[i] = new String(stringArray[i]);
        }
        Marker.checkCHROM(stringArray[0], string);
        Marker.checkPOS(stringArray[1], string);
        String[] stringArray2 = Marker.checkID(stringArray[2], string);
        Marker.checkREF(stringArray[3], string);
        String[] stringArray3 = Marker.checkALT(stringArray[4], string);
        this.chromIndex = ChromIds.instance().indexOf(stringArray[0]);
        this.pos = Integer.parseInt(stringArray[1]);
        this.ids = stringArray2;
        this.id = stringArray2.length > 0 ? stringArray2[0] : stringArray[0] + ':' + this.pos;
        this.alleles = Marker.alleles(stringArray[3], stringArray3);
        this.nGenotypes = this.alleles.length * (this.alleles.length + 1) / 2;
        this.end = Marker.extractEnd(stringArray[7]);
    }

    public static Marker flipStrand(Marker marker) {
        return new Marker(marker);
    }

    private Marker(Marker marker) {
        Marker marker2 = marker;
        this.chromIndex = marker2.chromIndex;
        this.pos = marker2.pos;
        this.ids = marker2.ids;
        this.id = marker2.id;
        this.alleles = (String[])marker2.alleles.clone();
        for (int i = 0; i < marker2.alleles.length; ++i) {
            if (this.alleles[i].charAt(0) == '<') continue;
            this.alleles[i] = Marker.flipAllele(marker2.alleles[i]);
        }
        this.nGenotypes = marker2.nGenotypes;
        this.end = marker2.end;
    }

    private static String flipAllele(String string) {
        char[] cArray = new char[string.length()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Marker.flipBase(string.charAt(i));
        }
        return new String(cArray);
    }

    private static char flipBase(char c) {
        switch (c) {
            case 'A': {
                return 'T';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'T': {
                return 'A';
            }
            case 'N': {
                return 'N';
            }
            case '*': {
                return '*';
            }
        }
        assert (false);
        return '\u0000';
    }

    private static void checkCHROM(String string, String string2) {
        if (string.isEmpty() || string.equals(".")) {
            String string3 = "missing CHROM field: " + string2;
            throw new IllegalArgumentException(string3);
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != ':' && !Character.isWhitespace(c)) continue;
            String string4 = "invalid character in CHROM field ['" + c + "']: " + string2;
            throw new IllegalArgumentException(string4);
        }
    }

    private static void checkPOS(String string, String string2) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            String string3 = "invalid POS field [" + string + "]: " + string2;
            throw new IllegalArgumentException(string3);
        }
    }

    private static String[] checkID(String string, String string2) {
        String[] stringArray;
        if (string.isEmpty()) {
            String string3 = "missing ID field: " + string2;
            throw new IllegalArgumentException(string3);
        }
        if (string.equals(".")) {
            return EMPTY_ID_ARRAY;
        }
        for (String string4 : stringArray = StringUtil.getFields(string, ';')) {
            int n = string4.length();
            for (int i = 0; i < n; ++i) {
                char c = string4.charAt(i);
                if (!Character.isWhitespace(c)) continue;
                String string5 = "marker identifier (" + string4 + ") contains white-space: " + string2;
                throw new IllegalArgumentException(string5);
            }
        }
        return stringArray;
    }

    private static void checkREF(String string, String string2) {
        if (string.isEmpty()) {
            String string3 = "missing REF field: " + string2;
            throw new IllegalArgumentException(string3);
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = Character.toUpperCase(string.charAt(i));
            if (c == 'A' || c == 'C' || c == 'G' || c == 'T' || c == 'N') continue;
            String string4 = "REF allele [" + string + "] is not a sequence" + " of A, C, T, G, or N characters" + Const.nl + string2;
            throw new IllegalArgumentException(string4);
        }
    }

    private static String[] checkALT(String string, String string2) {
        if (string.isEmpty()) {
            String string3 = "missing ALT field: " + string2;
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = EMPTY_ID_ARRAY;
        if (!string.equals(".")) {
            stringArray = StringUtil.getFields(string, ',');
        }
        if (stringArray.length >= 126) {
            String string4 = "More than 126 ALT alleles: " + string2;
            throw new IllegalArgumentException(string4);
        }
        for (String string5 : stringArray) {
            Marker.checkAltAllele(string5, string2);
        }
        return stringArray;
    }

    private static void checkAltAllele(String string, String string2) {
        int n = string.length();
        if (n >= 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
            for (int i = 1; i < n - 1; ++i) {
                char c = string.charAt(i);
                if (!Character.isWhitespace(c) && c != ',' && c != '<' && c != '>') continue;
                String string3 = "invalid allele (" + string + "): " + string2;
                throw new IllegalArgumentException(string3);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                char c = Character.toUpperCase(string.charAt(i));
                if (c == 'A' || c == 'C' || c == 'G' || c == 'T' || c == 'N' || c == '*') continue;
                String string4 = "ALT allele [" + string + "] is not a sequence of" + " A, C, T, G, N, or '*' characters" + Const.nl + string2;
                throw new IllegalArgumentException(string4);
            }
        }
    }

    private static String[] alleles(String string, String[] stringArray) {
        if (Marker.isSNV(string, stringArray)) {
            String string2 = string;
            for (String string3 : stringArray) {
                string2 = string2 + string3;
            }
            String[] stringArray2 = allelesMap.get(string2);
            if (stringArray2 == null) {
                stringArray2 = Marker.createAllelesArray(string, stringArray);
                allelesMap.put(string2, stringArray2);
            }
            return stringArray2;
        }
        return Marker.createAllelesArray(string, stringArray);
    }

    private static boolean isSNV(String string, String[] stringArray) {
        if (string.length() != 1) {
            return false;
        }
        for (String string2 : stringArray) {
            if (string2.length() == 1) continue;
            return false;
        }
        return true;
    }

    private static String[] createAllelesArray(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    private static int extractEnd(String string) {
        String[] stringArray = StringUtil.getFields(string, ';');
        String string2 = "END=";
        for (String string3 : stringArray) {
            if (!string3.startsWith(string2)) continue;
            String string4 = string3.substring(4);
            int n = string4.length();
            for (int i = 0; i < n; ++i) {
                char c = string4.charAt(i);
                if (Character.isDigit(c)) continue;
                String string5 = "INFO END field has non-numeric value: " + string;
                throw new IllegalArgumentException(string5);
            }
            return Integer.parseInt(string4);
        }
        return -1;
    }

    public String chrom() {
        return ChromIds.instance().id(this.chromIndex);
    }

    public int chromIndex() {
        return this.chromIndex;
    }

    public int pos() {
        return this.pos;
    }

    public int nIds() {
        return this.ids.length;
    }

    public String id(int n) {
        return this.ids[n];
    }

    public String id() {
        return this.id;
    }

    public int nAlleles() {
        return this.alleles.length;
    }

    public int nGenotypes() {
        return this.nGenotypes;
    }

    public String allele(int n) {
        return this.alleles[n];
    }

    public int end() {
        return this.end;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(this.chrom());
        stringBuilder.append('\t');
        stringBuilder.append(this.pos);
        if (this.ids.length == 0) {
            stringBuilder.append('\t');
            stringBuilder.append('.');
        } else {
            for (n = 0; n < this.ids.length; ++n) {
                stringBuilder.append(n == 0 ? (char)'\t' : ';');
                stringBuilder.append(this.ids[n]);
            }
        }
        if (this.alleles.length == 1) {
            stringBuilder.append('\t');
            stringBuilder.append(this.alleles[0]);
            stringBuilder.append('\t');
            stringBuilder.append('.');
        } else {
            for (n = 0; n < this.alleles.length; ++n) {
                stringBuilder.append(n < 2 ? (char)'\t' : ',');
                stringBuilder.append(this.alleles[n]);
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 5;
        n = 29 * n + this.chromIndex;
        n = 29 * n + this.pos;
        for (int i = 0; i < this.alleles.length; ++i) {
            n = 29 * n + this.alleles[i].hashCode();
        }
        n = 29 * n + this.end;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Marker marker = (Marker)object;
        if (this.chromIndex != marker.chromIndex) {
            return false;
        }
        if (this.pos != marker.pos) {
            return false;
        }
        if (!Arrays.equals(this.alleles, marker.alleles)) {
            return false;
        }
        return this.end == marker.end;
    }

    @Override
    public int compareTo(Marker marker) {
        if (this.chromIndex != marker.chromIndex) {
            return this.chromIndex < marker.chromIndex ? -1 : 1;
        }
        if (this.pos != marker.pos) {
            return this.pos < marker.pos ? -1 : 1;
        }
        int n = Math.min(this.alleles.length, marker.alleles.length);
        for (int i = 0; i < n; ++i) {
            int n2 = this.alleles[i].compareTo(marker.alleles[i]);
            if (n2 == 0) continue;
            return n2;
        }
        if (this.alleles.length != marker.alleles.length) {
            return this.alleles.length < marker.alleles.length ? -1 : 1;
        }
        if (this.end != marker.end) {
            return this.end < marker.end ? -1 : 1;
        }
        return 0;
    }
}

