/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import blbutil.Const;
import haplotype.HapPair;
import java.util.BitSet;
import vcf.Marker;
import vcf.Markers;

public final class BitHapPair
implements HapPair {
    private final int idIndex;
    private final Markers markers;
    private final BitSet alleles1;
    private final BitSet alleles2;

    public BitHapPair(Markers markers, int n, byte[] byArray, byte[] byArray2) {
        if (byArray.length != markers.nMarkers()) {
            String string = "alleles1.length=" + byArray.length + " != markers.nMarkers()=" + markers.nMarkers();
            throw new IllegalArgumentException(string);
        }
        if (byArray2.length != markers.nMarkers()) {
            String string = "alleles2.length=" + byArray2.length + " != markers.nMarkers()=" + markers.nMarkers();
            throw new IllegalArgumentException(string);
        }
        this.markers = markers;
        this.idIndex = n;
        this.alleles1 = BitHapPair.toBitSet(markers, byArray);
        this.alleles2 = BitHapPair.toBitSet(markers, byArray2);
    }

    private BitHapPair(Markers markers, int n, BitSet bitSet, BitSet bitSet2) {
        this.markers = markers;
        this.idIndex = n;
        this.alleles1 = bitSet;
        this.alleles2 = bitSet2;
    }

    private static BitSet toBitSet(Markers markers, byte[] byArray) {
        int n = 0;
        BitSet bitSet = new BitSet(markers.sumHaplotypeBits());
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by < 0 || by >= markers.marker(i).nAlleles()) {
                String string = "allele \"" + by + "\" out of bounds for marker: " + markers.marker(i);
                throw new IllegalArgumentException(string);
            }
            int n2 = 1;
            int n3 = markers.sumHaplotypeBits(i + 1) - markers.sumHaplotypeBits(i);
            for (int j = 0; j < n3; ++j) {
                boolean bl = (by & n2) == n2;
                bitSet.set(n++, bl);
                n2 <<= 1;
            }
        }
        return bitSet;
    }

    @Override
    public byte allele1(int n) {
        return this.allele(this.alleles1, n);
    }

    @Override
    public byte allele2(int n) {
        return this.allele(this.alleles2, n);
    }

    private byte allele(BitSet bitSet, int n) {
        int n2 = this.markers.sumHaplotypeBits(n);
        int n3 = this.markers.sumHaplotypeBits(n + 1);
        if (n3 == n2 + 1) {
            return bitSet.get(n2) ? (byte)1 : 0;
        }
        byte by = 0;
        byte by2 = 1;
        for (int i = n2; i < n3; ++i) {
            if (bitSet.get(i)) {
                by = (byte)(by + by2);
            }
            by2 = (byte)(by2 << 1);
        }
        return by;
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public int idIndex() {
        return this.idIndex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sampleIdIndex=");
        stringBuilder.append(this.idIndex);
        stringBuilder.append(Const.nl);
        stringBuilder.append(this.alleles1);
        stringBuilder.append(Const.nl);
        stringBuilder.append(this.alleles2);
        return stringBuilder.toString();
    }
}

