/*
 * Decompiled with CFR 0.152.
 */
package dag;

public final class Score
implements Comparable<Score> {
    private final int nodeA;
    private final int nodeB;
    private final float score;

    public Score(int n, int n2, float f, boolean bl) {
        if (f < 0.0f) {
            if (f == 0.0f && !bl) {
                String string = "isMergeable==false && score==0.0f";
                throw new IllegalArgumentException(string);
            }
            throw new IllegalArgumentException("score: " + f);
        }
        this.nodeA = n;
        this.nodeB = n2;
        this.score = bl ? f : -f;
    }

    public int nodeA() {
        return this.nodeA;
    }

    public int nodeB() {
        return this.nodeB;
    }

    public float score() {
        return this.score < 0.0f ? -this.score : this.score;
    }

    public boolean isMergeable() {
        return this.score > 0.0f;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Score score = (Score)object;
        if (this.nodeA != score.nodeA) {
            return false;
        }
        if (this.nodeB != score.nodeB) {
            return false;
        }
        return Float.floatToIntBits(this.score) == Float.floatToIntBits(score.score);
    }

    public int hashCode() {
        int n = 5;
        n = 53 * n + this.nodeA;
        n = 53 * n + this.nodeB;
        n = 53 * n + Float.floatToIntBits(this.score);
        return n;
    }

    @Override
    public int compareTo(Score score) {
        int n = -Boolean.compare(this.isMergeable(), score.isMergeable());
        if (n != 0) {
            return n;
        }
        n = Float.compare(this.score(), score.score());
        if (n != 0) {
            return n;
        }
        if (this.nodeA() != score.nodeA()) {
            return this.nodeA() < score.nodeA() ? -1 : 1;
        }
        if (this.nodeB() != score.nodeB()) {
            return this.nodeB() < score.nodeB() ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[nodeA=");
        stringBuilder.append(this.nodeA());
        stringBuilder.append(", nodeB=");
        stringBuilder.append(this.nodeB());
        stringBuilder.append(", score=");
        stringBuilder.append(this.score());
        stringBuilder.append(" isMergeable=");
        stringBuilder.append(this.isMergeable());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

