/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.Const;
import dag.Dag;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class DagUtils {
    private DagUtils() {
    }

    public static String dagStats(Dag dag) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        int n = 7;
        double d = dag.nEdges();
        double d2 = dag.nNodes();
        double d3 = dag.nMarkers();
        long l = (int)Math.round(d / d3);
        double d4 = d / d2;
        int n2 = Math.round(dag.nodeCnt(0, 0) / (float)l);
        String string = String.valueOf(l);
        String string2 = String.valueOf(dag.maxEdges());
        String string3 = decimalFormat.format(d4);
        String string4 = String.valueOf(n2);
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("mean edges/level: ");
        stringBuilder.append(string);
        DagUtils.padField(stringBuilder, n - string.length());
        stringBuilder.append("max edges/level: ");
        stringBuilder.append(string2);
        stringBuilder.append(Const.nl);
        stringBuilder.append("mean edges/node:  ");
        stringBuilder.append(string3);
        DagUtils.padField(stringBuilder, n - string3.length());
        stringBuilder.append("mean count/edge: ");
        stringBuilder.append(string4);
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }

    private static void padField(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
    }

    public static int count(byte[] byArray, byte by) {
        int n = 0;
        for (byte by2 : byArray) {
            if (by2 != by) continue;
            ++n;
        }
        return n;
    }

    public static int count(int[] nArray, int n) {
        int n2 = 0;
        for (int n3 : nArray) {
            if (n3 != n) continue;
            ++n2;
        }
        return n2;
    }

    public static int count(float[] fArray, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        int n = 0;
        for (float f2 : fArray) {
            if (f2 != f) continue;
            ++n;
        }
        return n;
    }

    public static byte[] removeValues(byte[] byArray, byte by) {
        int n = DagUtils.count(byArray, by);
        byte[] byArray2 = new byte[byArray.length - n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == by) continue;
            byArray2[n2++] = byArray[i];
        }
        assert (n2 == byArray2.length);
        return byArray2;
    }

    public static int[] removeValues(int[] nArray, int n) {
        int n2 = DagUtils.count(nArray, n);
        int[] nArray2 = new int[nArray.length - n2];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            nArray2[n3++] = nArray[i];
        }
        assert (n3 == nArray2.length);
        return nArray2;
    }

    public static float[] removeValues(float[] fArray, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        int n = DagUtils.count(fArray, f);
        float[] fArray2 = new float[fArray.length - n];
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == f) continue;
            fArray2[n2++] = fArray[i];
        }
        assert (n2 == fArray2.length);
        return fArray2;
    }

    public static int count(AtomicIntegerArray atomicIntegerArray, int n) {
        int n2 = 0;
        int n3 = atomicIntegerArray.length();
        for (int i = 0; i < n3; ++i) {
            if (atomicIntegerArray.get(i) != n) continue;
            ++n2;
        }
        return n2;
    }

    public static int[] removeValues(AtomicIntegerArray atomicIntegerArray, int n) {
        int n2 = DagUtils.count(atomicIntegerArray, n);
        int[] nArray = new int[atomicIntegerArray.length() - n2];
        int n3 = 0;
        int n4 = atomicIntegerArray.length();
        for (int i = 0; i < n4; ++i) {
            int n5 = atomicIntegerArray.get(i);
            if (n5 == n) continue;
            nArray[n3++] = n5;
        }
        assert (n3 == nArray.length);
        return nArray;
    }

    public static byte[] removeValues(AtomicIntegerArray atomicIntegerArray, byte by) {
        int n = DagUtils.count(atomicIntegerArray, (int)by);
        byte[] byArray = new byte[atomicIntegerArray.length() - n];
        int n2 = 0;
        int n3 = atomicIntegerArray.length();
        for (int i = 0; i < n3; ++i) {
            byte by2 = (byte)atomicIntegerArray.get(i);
            if (by2 == by) continue;
            byArray[n2++] = by2;
        }
        assert (n2 == byArray.length);
        return byArray;
    }

    public static float[] removeValues(AtomicIntegerArray atomicIntegerArray, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        int n = Float.floatToIntBits(f);
        int n2 = DagUtils.count(atomicIntegerArray, n);
        float[] fArray = new float[atomicIntegerArray.length() - n2];
        int n3 = 0;
        int n4 = atomicIntegerArray.length();
        for (int i = 0; i < n4; ++i) {
            int n5 = atomicIntegerArray.get(i);
            if (n5 == n) continue;
            fArray[n3++] = Float.intBitsToFloat(n5);
        }
        assert (n3 == fArray.length);
        return fArray;
    }
}

