/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.FileIterator;
import blbutil.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.util.BlockCompressedInputStream;

public class InputIterator
implements FileIterator<String> {
    public static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private final BufferedReader in;
    private String next = null;

    public InputIterator(InputStream inputStream) {
        this(inputStream, 0x400000);
    }

    public InputIterator(InputStream inputStream, int n) {
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader, n);
            this.next = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Utilities.exit("Error reading " + inputStream, iOException);
        }
        this.in = bufferedReader;
    }

    @Override
    public File file() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.next;
        try {
            this.next = this.in.readLine();
        }
        catch (IOException iOException) {
            Utilities.exit("Error reading " + this.in, iOException);
        }
        return string;
    }

    @Override
    public void remove() {
        String string = "remove() is not supported by LineIterator";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            Utilities.exit("Error closing " + this.in, iOException);
        }
        this.next = null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("[next = ");
        stringBuilder.append(this.next);
        stringBuilder.append("\nBufferedReader = ");
        stringBuilder.append(this.in);
        return stringBuilder.toString();
    }

    public static InputIterator fromGzipFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                if (InputIterator.isBGZipFile(file)) {
                    return new InputIterator(new BlockCompressedInputStream(fileInputStream));
                }
                return new InputIterator(new GZIPInputStream(fileInputStream));
            }
            return new InputIterator(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening " + file, fileNotFoundException);
        }
        catch (IOException iOException) {
            Utilities.exit("Error reading " + file, iOException);
        }
        assert (false);
        return null;
    }

    private static boolean isBGZipFile(File file) throws IOException {
        boolean bl = false;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            bl = BlockCompressedInputStream.isValidFile(bufferedInputStream);
        }
        return bl;
    }

    public static InputIterator fromGzipFile(String string) {
        return InputIterator.fromGzipFile(new File(string));
    }

    public static InputIterator fromTextFile(File file) {
        try {
            return new InputIterator(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening " + file, fileNotFoundException);
            assert (false);
            return null;
        }
    }

    public static InputIterator fromTextFile(String string) {
        return InputIterator.fromTextFile(new File(string));
    }
}

