/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.associations.AbstractAssociator;
import weka.associations.AssociationRules;
import weka.associations.AssociationRulesProducer;
import weka.core.Attribute;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

@KFStep(name="Associator", category="Associations", toolTipText="Weka associator wrapper", iconPath="")
public class Associator
extends WekaAlgorithmWrapper {
    private static final long serialVersionUID = -589410455393151511L;
    protected weka.associations.Associator m_associatorTemplate;

    @Override
    public Class getWrappedAlgorithmClass() {
        return weka.associations.Associator.class;
    }

    @Override
    public void setWrappedAlgorithm(Object algo) {
        super.setWrappedAlgorithm(algo);
        this.m_defaultIconPath = "weka/gui/knowledgeflow/icons/DefaultAssociator.gif";
    }

    @ProgrammaticProperty
    public void setAssociator(weka.associations.Associator associator) {
        this.setWrappedAlgorithm(associator);
    }

    public weka.associations.Associator getAssociator() {
        return (weka.associations.Associator)this.getWrappedAlgorithm();
    }

    @Override
    public void stepInit() throws WekaException {
        if (!(this.getWrappedAlgorithm() instanceof weka.associations.Associator)) {
            throw new WekaException("Wrapped algorithm is not an instance of a weka.associations.Associator!");
        }
        try {
            this.m_associatorTemplate = AbstractAssociator.makeCopy(this.getAssociator());
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        Instances insts = (Instances)data.getPrimaryPayload();
        Integer setNum = (Integer)data.getPayloadElement("aux_set_num");
        Integer maxSetNum = (Integer)data.getPayloadElement("aux_max_set_num");
        try {
            if (!this.isStopRequested()) {
                this.getStepManager().processing();
                weka.associations.Associator associator = AbstractAssociator.makeCopy(this.m_associatorTemplate);
                associator.buildAssociations(insts);
                this.outputAssociatorData(associator, setNum, maxSetNum);
                this.outputTextData(associator, insts, setNum);
                this.outputGraphData(associator, insts, setNum);
                if (!this.isStopRequested()) {
                    this.getStepManager().finished();
                } else {
                    this.getStepManager().interrupted();
                }
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected void outputAssociatorData(weka.associations.Associator associator, Integer setNum, Integer maxSetNum) throws WekaException {
        if (this.getStepManager().numOutgoingConnectionsOfType("batchAssociator") == 0) {
            return;
        }
        Data out = new Data("batchAssociator", associator);
        if (setNum != null && maxSetNum != null) {
            out.setPayloadElement("aux_set_num", setNum);
            out.setPayloadElement("aux_max_set_num", maxSetNum);
        }
        if (associator instanceof AssociationRulesProducer) {
            AssociationRules rules = ((AssociationRulesProducer)((Object)associator)).getAssociationRules();
            out.setPayloadElement("batch_association_rules", rules);
        }
        this.getStepManager().outputData(out);
    }

    protected void outputTextData(weka.associations.Associator associator, Instances train, Integer setNum) throws WekaException {
        if (this.getStepManager().numOutgoingConnectionsOfType("text") == 0) {
            return;
        }
        String modelString = associator.toString();
        String titleString = associator.getClass().getName();
        titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
        modelString = "=== Associator model ===\n\nScheme:   " + titleString + "\n" + "Relation: " + train.relationName() + "\n\n" + modelString;
        titleString = "Model: " + titleString;
        Data textData = new Data("text", modelString);
        textData.setPayloadElement("aux_textTitle", titleString);
        if (setNum != null) {
            textData.setPayloadElement("aux_set_num", setNum);
        }
        this.getStepManager().outputData(textData);
    }

    protected void outputGraphData(weka.associations.Associator associator, Instances insts, Integer setNum) throws WekaException {
        if (!(associator instanceof Drawable) || this.getStepManager().numOutgoingConnectionsOfType("graph") == 0) {
            return;
        }
        try {
            String graphString = ((Drawable)((Object)associator)).graph();
            int graphType = ((Drawable)((Object)associator)).graphType();
            String grphTitle = associator.getClass().getCanonicalName();
            grphTitle = grphTitle.substring(grphTitle.lastIndexOf(46) + 1, grphTitle.length());
            String set = setNum != null ? "Set " + setNum : "";
            grphTitle = set + " (" + insts.relationName() + ") " + grphTitle;
            Data graphData = new Data("graph");
            graphData.setPayloadElement("graph", graphString);
            graphData.setPayloadElement("graph_title", grphTitle);
            graphData.setPayloadElement("graph_type", graphType);
            this.getStepManager().outputData(graphData);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() == 0) {
            result.addAll(Arrays.asList("dataSet", "trainingSet", "testSet"));
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() > 0) {
            result.add("batchAssociator");
            result.add("text");
        }
        result.add("info");
        return result;
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (connectionName.equals("text")) {
            ArrayList<Attribute> attInfo = new ArrayList<Attribute>();
            attInfo.add(new Attribute("Title", (List<String>)null));
            attInfo.add(new Attribute("Text", (List<String>)null));
            return new Instances("TextEvent", attInfo, 0);
        }
        if (connectionName.equals("batchAssociator") && this.m_associatorTemplate instanceof AssociationRulesProducer) {
            String[] metricNames = ((AssociationRulesProducer)((Object)this.m_associatorTemplate)).getRuleMetricNames();
            ArrayList<Attribute> attInfo = new ArrayList<Attribute>();
            attInfo.add(new Attribute("LHS", (List<String>)null));
            attInfo.add(new Attribute("RHS", (List<String>)null));
            attInfo.add(new Attribute("Support"));
            for (String metricName : metricNames) {
                attInfo.add(new Attribute(metricName));
            }
            return new Instances("batch_association_rules", attInfo, 0);
        }
        return null;
    }
}

