/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.WekaException;
import weka.gui.ResultHistoryPanel;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.GraphViewer;

public class GraphViewerInteractiveView
extends BaseInteractiveViewer {
    private static final long serialVersionUID = 2109423349272114409L;
    protected ResultHistoryPanel m_history;
    protected JButton m_clearButton = new JButton("Clear results");
    protected JSplitPane m_splitPane;
    protected TreeVisualizer m_treeVisualizer;
    protected GraphVisualizer m_graphVisualizer;
    JPanel m_holderPanel = new JPanel(new BorderLayout());

    @Override
    public String getViewerName() {
        return "Graph Viewer";
    }

    @Override
    public void init() throws WekaException {
        this.addButton(this.m_clearButton);
        this.m_history = new ResultHistoryPanel(null);
        this.m_history.setBorder(BorderFactory.createTitledBorder("Result list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -5174882230278923704L;

            @Override
            public void mouseClicked(MouseEvent e) {
                String name;
                Object data;
                int index = GraphViewerInteractiveView.this.m_history.getList().locationToIndex(e.getPoint());
                if (index != -1 && (data = GraphViewerInteractiveView.this.m_history.getNamedObject(name = GraphViewerInteractiveView.this.m_history.getNameAtIndex(index))) instanceof Data) {
                    String grphString = (String)((Data)data).getPrimaryPayload();
                    Integer grphType = (Integer)((Data)data).getPayloadElement("graph_type");
                    if (GraphViewerInteractiveView.this.m_treeVisualizer != null || GraphViewerInteractiveView.this.m_graphVisualizer != null) {
                        GraphViewerInteractiveView.this.m_holderPanel.remove(GraphViewerInteractiveView.this.m_treeVisualizer != null ? GraphViewerInteractiveView.this.m_treeVisualizer : GraphViewerInteractiveView.this.m_graphVisualizer);
                    }
                    if (grphType == 1) {
                        GraphViewerInteractiveView.this.m_treeVisualizer = new TreeVisualizer(null, grphString, (NodePlace)new PlaceNode2());
                        GraphViewerInteractiveView.this.m_holderPanel.add((Component)GraphViewerInteractiveView.this.m_treeVisualizer, "Center");
                        GraphViewerInteractiveView.this.m_splitPane.revalidate();
                    } else if (grphType == 2) {
                        GraphViewerInteractiveView.this.m_graphVisualizer = new GraphVisualizer();
                        try {
                            GraphViewerInteractiveView.this.m_graphVisualizer.readBIF(grphString);
                        }
                        catch (BIFFormatException ex) {
                            ex.printStackTrace();
                        }
                        GraphViewerInteractiveView.this.m_graphVisualizer.layoutGraph();
                        GraphViewerInteractiveView.this.m_holderPanel.add((Component)GraphViewerInteractiveView.this.m_graphVisualizer, "Center");
                        GraphViewerInteractiveView.this.m_splitPane.revalidate();
                    }
                }
            }
        });
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        String name;
                        Object data;
                        if (!lm.isSelectedIndex(i)) continue;
                        if (i == -1 || (data = GraphViewerInteractiveView.this.m_history.getNamedObject(name = GraphViewerInteractiveView.this.m_history.getNameAtIndex(i))) == null || !(data instanceof Data)) break;
                        String grphString = (String)((Data)data).getPrimaryPayload();
                        Integer grphType = (Integer)((Data)data).getPayloadElement("graph_type");
                        if (GraphViewerInteractiveView.this.m_treeVisualizer != null || GraphViewerInteractiveView.this.m_graphVisualizer != null) {
                            GraphViewerInteractiveView.this.m_holderPanel.remove(GraphViewerInteractiveView.this.m_treeVisualizer != null ? GraphViewerInteractiveView.this.m_treeVisualizer : GraphViewerInteractiveView.this.m_graphVisualizer);
                        }
                        if (grphType == 1) {
                            GraphViewerInteractiveView.this.m_treeVisualizer = new TreeVisualizer(null, grphString, (NodePlace)new PlaceNode2());
                            GraphViewerInteractiveView.this.m_holderPanel.add((Component)GraphViewerInteractiveView.this.m_treeVisualizer, "Center");
                            GraphViewerInteractiveView.this.m_splitPane.revalidate();
                            break;
                        }
                        if (grphType != 2) break;
                        GraphViewerInteractiveView.this.m_graphVisualizer = new GraphVisualizer();
                        try {
                            GraphViewerInteractiveView.this.m_graphVisualizer.readBIF(grphString);
                        }
                        catch (BIFFormatException ex) {
                            ex.printStackTrace();
                        }
                        GraphViewerInteractiveView.this.m_graphVisualizer.layoutGraph();
                        GraphViewerInteractiveView.this.m_holderPanel.add((Component)GraphViewerInteractiveView.this.m_graphVisualizer, "Center");
                        GraphViewerInteractiveView.this.m_splitPane.revalidate();
                        break;
                    }
                }
            }
        });
        this.m_splitPane = new JSplitPane(1, this.m_history, this.m_holderPanel);
        this.add((Component)this.m_splitPane, "Center");
        this.m_holderPanel.setPreferredSize(new Dimension(800, 600));
        boolean first = true;
        for (Data d : ((GraphViewer)this.getStep()).getDatasets()) {
            String title = (String)d.getPayloadElement("graph_title");
            this.m_history.addResult(title, new StringBuffer());
            this.m_history.addObject(title, d);
            if (!first) continue;
            String grphString = (String)d.getPrimaryPayload();
            Integer grphType = (Integer)d.getPayloadElement("graph_type");
            if (grphType == 1) {
                this.m_treeVisualizer = new TreeVisualizer(null, grphString, (NodePlace)new PlaceNode2());
                this.m_holderPanel.add((Component)this.m_treeVisualizer, "Center");
            } else if (grphType == 2) {
                this.m_graphVisualizer = new GraphVisualizer();
                try {
                    this.m_graphVisualizer.readBIF(grphString);
                }
                catch (BIFFormatException ex) {
                    ex.printStackTrace();
                }
                this.m_graphVisualizer.layoutGraph();
                this.m_holderPanel.add((Component)this.m_graphVisualizer, "Center");
            }
            this.m_splitPane.revalidate();
            first = false;
        }
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphViewerInteractiveView.this.m_history.clearResults();
                ((GraphViewer)GraphViewerInteractiveView.this.getStep()).getDatasets().clear();
                if (GraphViewerInteractiveView.this.m_treeVisualizer != null || GraphViewerInteractiveView.this.m_graphVisualizer != null) {
                    GraphViewerInteractiveView.this.m_splitPane.remove(GraphViewerInteractiveView.this.m_holderPanel);
                    GraphViewerInteractiveView.this.revalidate();
                }
            }
        });
    }
}

