/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.SimpleBatchFilter;
import weka.filters.SupervisedFilter;

public class ClassBalancer
extends SimpleBatchFilter
implements SupervisedFilter,
WeightedInstancesHandler {
    static final long serialVersionUID = 6237337831221353842L;

    @Override
    public String globalInfo() {
        return "Reweights the instances in the data so that each class has the same total weight. The total sum of weights accross all instances will be maintained. Only the weights in the first batch of data received by this filter are changed, so it can be used with the FilteredClassifier.";
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) {
        return new Instances(inputFormat, 0);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (this.isFirstBatchDone()) {
            return new Instances(instances);
        }
        Instances result = new Instances(instances, instances.numInstances());
        double[] sumOfWeightsPerClass = new double[instances.numClasses()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance inst = instances.instance(i);
            int n = (int)inst.classValue();
            sumOfWeightsPerClass[n] = sumOfWeightsPerClass[n] + inst.weight();
        }
        double sumOfWeights = Utils.sum(sumOfWeightsPerClass);
        double factor = sumOfWeights / (double)instances.numClasses();
        for (int i = 0; i < instances.numInstances(); ++i) {
            result.add(instances.instance(i));
            Instance newInst = result.instance(i);
            this.copyValues(newInst, false, instances, this.outputFormatPeek());
            newInst.setWeight(factor * newInst.weight() / sumOfWeightsPerClass[(int)newInst.classValue()]);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] args) {
        ClassBalancer.runFilter(new ClassBalancer(), args);
    }
}

