/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaPackageManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;
import weka.experiment.InstancesResultListener;
import weka.experiment.PropertyNode;
import weka.experiment.RandomSplitResultProducer;
import weka.experiment.RemoteExperiment;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.xml.XMLExperiment;

public class Experiment
implements Serializable,
OptionHandler,
RevisionHandler {
    static final long serialVersionUID = 44945596742646663L;
    public static String FILE_EXTENSION = ".exp";
    protected ResultListener m_ResultListener = new InstancesResultListener();
    protected ResultProducer m_ResultProducer = new RandomSplitResultProducer();
    protected int m_RunLower = 1;
    protected int m_RunUpper = 10;
    protected DefaultListModel m_Datasets = new DefaultListModel();
    protected boolean m_UsePropertyIterator = false;
    protected PropertyNode[] m_PropertyPath;
    protected Object m_PropertyArray;
    protected String m_Notes = "";
    protected String[] m_AdditionalMeasures = null;
    protected boolean m_ClassFirst = false;
    protected boolean m_AdvanceDataSetFirst = true;
    protected transient int m_RunNumber;
    protected transient int m_DatasetNumber;
    protected transient int m_PropertyNumber;
    protected transient boolean m_Finished = true;
    protected transient Instances m_CurrentInstances;
    protected transient int m_CurrentProperty;

    public void classFirst(boolean flag) {
        this.m_ClassFirst = flag;
    }

    public boolean getAdvanceDataSetFirst() {
        return this.m_AdvanceDataSetFirst;
    }

    public void setAdvanceDataSetFirst(boolean newAdvanceDataSetFirst) {
        this.m_AdvanceDataSetFirst = newAdvanceDataSetFirst;
    }

    public boolean getUsePropertyIterator() {
        return this.m_UsePropertyIterator;
    }

    public void setUsePropertyIterator(boolean newUsePropertyIterator) {
        this.m_UsePropertyIterator = newUsePropertyIterator;
    }

    public PropertyNode[] getPropertyPath() {
        return this.m_PropertyPath;
    }

    public void setPropertyPath(PropertyNode[] newPropertyPath) {
        this.m_PropertyPath = newPropertyPath;
    }

    public void setPropertyArray(Object newPropArray) {
        this.m_PropertyArray = newPropArray;
    }

    public Object getPropertyArray() {
        return this.m_PropertyArray;
    }

    public int getPropertyArrayLength() {
        return Array.getLength(this.m_PropertyArray);
    }

    public Object getPropertyArrayValue(int index) {
        return Array.get(this.m_PropertyArray, index);
    }

    public int getCurrentRunNumber() {
        return this.m_RunNumber;
    }

    public int getCurrentDatasetNumber() {
        return this.m_DatasetNumber;
    }

    public int getCurrentPropertyNumber() {
        return this.m_PropertyNumber;
    }

    public void initialize() throws Exception {
        this.m_RunNumber = this.getRunLower();
        this.m_DatasetNumber = 0;
        this.m_PropertyNumber = 0;
        this.m_CurrentProperty = -1;
        this.m_CurrentInstances = null;
        this.m_Finished = false;
        if (this.m_UsePropertyIterator && this.m_PropertyArray == null) {
            throw new Exception("Null array for property iterator");
        }
        if (this.getRunLower() > this.getRunUpper()) {
            throw new Exception("Lower run number is greater than upper run number");
        }
        if (this.getDatasets().size() == 0) {
            throw new Exception("No datasets have been specified");
        }
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        this.determineAdditionalResultMeasures();
        this.m_ResultProducer.setResultListener(this.m_ResultListener);
        this.m_ResultProducer.setAdditionalMeasures(this.m_AdditionalMeasures);
        this.m_ResultProducer.preProcess();
        String[] columnConstraints = this.m_ResultListener.determineColumnConstraints(this.m_ResultProducer);
        if (columnConstraints != null) {
            this.m_ResultProducer.setAdditionalMeasures(columnConstraints);
        }
    }

    private void determineAdditionalResultMeasures() throws Exception {
        this.m_AdditionalMeasures = null;
        ArrayList<String> measureNames = new ArrayList<String>();
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            Enumeration<String> am = ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).enumerateMeasures();
            while (am.hasMoreElements()) {
                String mname = am.nextElement();
                if (mname.startsWith("measure")) {
                    if (measureNames.indexOf(mname) != -1) continue;
                    measureNames.add(mname);
                    continue;
                }
                throw new Exception("Additional measures in " + this.m_ResultProducer.getClass().getName() + " must obey the naming convention" + " of starting with \"measure\"");
            }
        }
        if (this.m_UsePropertyIterator && this.m_PropertyArray != null) {
            for (int i = 0; i < Array.getLength(this.m_PropertyArray); ++i) {
                Object current = Array.get(this.m_PropertyArray, i);
                if (!(current instanceof AdditionalMeasureProducer)) continue;
                Enumeration<String> am = ((AdditionalMeasureProducer)current).enumerateMeasures();
                while (am.hasMoreElements()) {
                    String mname = am.nextElement();
                    if (mname.startsWith("measure")) {
                        if (measureNames.indexOf(mname) != -1) continue;
                        measureNames.add(mname);
                        continue;
                    }
                    throw new Exception("Additional measures in " + current.getClass().getName() + " must obey the naming convention" + " of starting with \"measure\"");
                }
            }
        }
        if (measureNames.size() > 0) {
            this.m_AdditionalMeasures = new String[measureNames.size()];
            for (int i = 0; i < measureNames.size(); ++i) {
                this.m_AdditionalMeasures[i] = (String)measureNames.get(i);
            }
        }
    }

    protected void setProperty(int propertyDepth, Object origValue) throws Exception {
        PropertyDescriptor current = this.m_PropertyPath[propertyDepth].property;
        Object subVal = null;
        if (propertyDepth < this.m_PropertyPath.length - 1) {
            Method getter = current.getReadMethod();
            Object[] getArgs = new Object[]{};
            subVal = getter.invoke(origValue, getArgs);
            this.setProperty(propertyDepth + 1, subVal);
        } else {
            subVal = Array.get(this.m_PropertyArray, this.m_PropertyNumber);
        }
        Method setter = current.getWriteMethod();
        Object[] args = new Object[]{subVal};
        setter.invoke(origValue, args);
    }

    public boolean hasMoreIterations() {
        return !this.m_Finished;
    }

    public void nextIteration() throws Exception {
        if (this.m_UsePropertyIterator && this.m_CurrentProperty != this.m_PropertyNumber) {
            this.setProperty(0, this.m_ResultProducer);
            this.m_CurrentProperty = this.m_PropertyNumber;
        }
        if (this.m_CurrentInstances == null) {
            File currentFile = (File)this.getDatasets().elementAt(this.m_DatasetNumber);
            AbstractFileLoader loader = ConverterUtils.getLoaderForFile(currentFile);
            loader.setFile(currentFile);
            Instances data = new Instances(loader.getDataSet());
            if (data.classIndex() == -1) {
                if (this.m_ClassFirst) {
                    data.setClassIndex(0);
                } else {
                    data.setClassIndex(data.numAttributes() - 1);
                }
            }
            this.m_CurrentInstances = data;
            this.m_ResultProducer.setInstances(this.m_CurrentInstances);
        }
        this.m_ResultProducer.doRun(this.m_RunNumber);
        this.advanceCounters();
    }

    public void advanceCounters() {
        if (this.m_AdvanceDataSetFirst) {
            ++this.m_RunNumber;
            if (this.m_RunNumber > this.getRunUpper()) {
                this.m_RunNumber = this.getRunLower();
                ++this.m_DatasetNumber;
                this.m_CurrentInstances = null;
                if (this.m_DatasetNumber >= this.getDatasets().size()) {
                    this.m_DatasetNumber = 0;
                    if (this.m_UsePropertyIterator) {
                        ++this.m_PropertyNumber;
                        if (this.m_PropertyNumber >= Array.getLength(this.m_PropertyArray)) {
                            this.m_Finished = true;
                        }
                    } else {
                        this.m_Finished = true;
                    }
                }
            }
        } else {
            ++this.m_RunNumber;
            if (this.m_RunNumber > this.getRunUpper()) {
                this.m_RunNumber = this.getRunLower();
                if (this.m_UsePropertyIterator) {
                    ++this.m_PropertyNumber;
                    if (this.m_PropertyNumber >= Array.getLength(this.m_PropertyArray)) {
                        this.m_PropertyNumber = 0;
                        ++this.m_DatasetNumber;
                        this.m_CurrentInstances = null;
                        if (this.m_DatasetNumber >= this.getDatasets().size()) {
                            this.m_Finished = true;
                        }
                    }
                } else {
                    ++this.m_DatasetNumber;
                    this.m_CurrentInstances = null;
                    if (this.m_DatasetNumber >= this.getDatasets().size()) {
                        this.m_Finished = true;
                    }
                }
            }
        }
    }

    public void runExperiment(boolean verbose) {
        while (this.hasMoreIterations()) {
            try {
                if (verbose) {
                    String current = "Iteration:";
                    if (this.getUsePropertyIterator()) {
                        int cnum = this.getCurrentPropertyNumber();
                        String ctype = this.getPropertyArray().getClass().getComponentType().getName();
                        int lastDot = ctype.lastIndexOf(46);
                        if (lastDot != -1) {
                            ctype = ctype.substring(lastDot + 1);
                        }
                        String cname = " " + ctype + "=" + (cnum + 1) + ":" + this.getPropertyArrayValue(cnum).getClass().getName();
                        current = current + cname;
                    }
                    String dname = ((File)this.getDatasets().elementAt(this.getCurrentDatasetNumber())).getName();
                    current = current + " Dataset=" + dname + " Run=" + this.getCurrentRunNumber();
                    System.out.println(current);
                }
                this.nextIteration();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex.getMessage());
                this.advanceCounters();
            }
        }
    }

    public void runExperiment() {
        this.runExperiment(false);
    }

    public void postProcess() throws Exception {
        this.m_ResultProducer.postProcess();
    }

    public DefaultListModel getDatasets() {
        return this.m_Datasets;
    }

    public void setDatasets(DefaultListModel ds) {
        this.m_Datasets = ds;
    }

    public ResultListener getResultListener() {
        return this.m_ResultListener;
    }

    public void setResultListener(ResultListener newResultListener) {
        this.m_ResultListener = newResultListener;
    }

    public ResultProducer getResultProducer() {
        return this.m_ResultProducer;
    }

    public void setResultProducer(ResultProducer newResultProducer) {
        this.m_ResultProducer = newResultProducer;
    }

    public int getRunUpper() {
        return this.m_RunUpper;
    }

    public void setRunUpper(int newRunUpper) {
        this.m_RunUpper = newRunUpper;
    }

    public int getRunLower() {
        return this.m_RunLower;
    }

    public void setRunLower(int newRunLower) {
        this.m_RunLower = newRunLower;
    }

    public String getNotes() {
        return this.m_Notes;
    }

    public void setNotes(String newNotes) {
        this.m_Notes = newNotes;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tThe lower run number to start the experiment from.\n\t(default 1)", "L", 1, "-L <num>"));
        newVector.addElement(new Option("\tThe upper run number to end the experiment at (inclusive).\n\t(default 10)", "U", 1, "-U <num>"));
        newVector.addElement(new Option("\tThe dataset to run the experiment on.\n\t(required, may be specified multiple times)", "T", 1, "-T <arff file>"));
        newVector.addElement(new Option("\tThe full class name of a ResultProducer (required).\n\teg: weka.experiment.RandomSplitResultProducer", "P", 1, "-P <class name>"));
        newVector.addElement(new Option("\tThe full class name of a ResultListener (required).\n\teg: weka.experiment.CSVResultListener", "D", 1, "-D <class name>"));
        newVector.addElement(new Option("\tA string containing any notes about the experiment.\n\t(default none)", "N", 1, "-N <string>"));
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to result producer " + this.m_ResultProducer.getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)this.m_ResultProducer)).listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String dataName;
        String lowerString = Utils.getOption('L', options);
        if (lowerString.length() != 0) {
            this.setRunLower(Integer.parseInt(lowerString));
        } else {
            this.setRunLower(1);
        }
        String upperString = Utils.getOption('U', options);
        if (upperString.length() != 0) {
            this.setRunUpper(Integer.parseInt(upperString));
        } else {
            this.setRunUpper(10);
        }
        if (this.getRunLower() > this.getRunUpper()) {
            throw new Exception("Lower (" + this.getRunLower() + ") is greater than upper (" + this.getRunUpper() + ")");
        }
        this.setNotes(Utils.getOption('N', options));
        this.getDatasets().removeAllElements();
        do {
            if ((dataName = Utils.getOption('T', options)).length() == 0) continue;
            File dataset = new File(dataName);
            this.getDatasets().addElement(dataset);
        } while (dataName.length() != 0);
        if (this.getDatasets().size() == 0) {
            throw new Exception("Required: -T <arff file name>");
        }
        String rlName = Utils.getOption('D', options);
        if (rlName.length() == 0) {
            throw new Exception("Required: -D <ResultListener class name>");
        }
        rlName = rlName.trim();
        int breakLoc = rlName.indexOf(32);
        String clName = rlName;
        String rlOptionsString = "";
        String[] rlOptions = null;
        if (breakLoc != -1) {
            clName = rlName.substring(0, breakLoc);
            rlOptionsString = rlName.substring(breakLoc).trim();
            rlOptions = Utils.splitOptions(rlOptionsString);
        }
        this.setResultListener((ResultListener)Utils.forName(ResultListener.class, clName, rlOptions));
        String rpName = Utils.getOption('P', options);
        if (rpName.length() == 0) {
            throw new Exception("Required: -P <ResultProducer class name>");
        }
        this.setResultProducer((ResultProducer)Utils.forName(ResultProducer.class, rpName, Utils.partitionOptions(options)));
    }

    @Override
    public String[] getOptions() {
        this.m_UsePropertyIterator = false;
        this.m_PropertyPath = null;
        this.m_PropertyArray = null;
        String[] rpOptions = new String[]{};
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            rpOptions = ((OptionHandler)((Object)this.m_ResultProducer)).getOptions();
        }
        String[] options = new String[rpOptions.length + this.getDatasets().size() * 2 + 11];
        int current = 0;
        options[current++] = "-L";
        options[current++] = "" + this.getRunLower();
        options[current++] = "-U";
        options[current++] = "" + this.getRunUpper();
        if (this.getDatasets().size() != 0) {
            for (int i = 0; i < this.getDatasets().size(); ++i) {
                options[current++] = "-T";
                options[current++] = this.getDatasets().elementAt(i).toString();
            }
        }
        if (this.getResultListener() != null) {
            options[current++] = "-D";
            options[current++] = this.getResultListener().getClass().getName();
        }
        if (this.getResultProducer() != null) {
            options[current++] = "-P";
            options[current++] = this.getResultProducer().getClass().getName();
        }
        if (!this.getNotes().equals("")) {
            options[current++] = "-N";
            options[current++] = this.getNotes();
        }
        options[current++] = "--";
        System.arraycopy(rpOptions, 0, options, current, rpOptions.length);
        current += rpOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        int i;
        String result = "Runs from: " + this.m_RunLower + " to: " + this.m_RunUpper + '\n';
        result = result + "Datasets:";
        for (i = 0; i < this.m_Datasets.size(); ++i) {
            result = result + " " + this.m_Datasets.elementAt(i);
        }
        result = result + '\n';
        result = result + "Custom property iterator: " + (this.m_UsePropertyIterator ? "on" : "off") + "\n";
        if (this.m_UsePropertyIterator) {
            if (this.m_PropertyPath == null) {
                throw new Error("*** null propertyPath ***");
            }
            if (this.m_PropertyArray == null) {
                throw new Error("*** null propertyArray ***");
            }
            if (this.m_PropertyPath.length > 1) {
                result = result + "Custom property path:\n";
                for (i = 0; i < this.m_PropertyPath.length - 1; ++i) {
                    PropertyNode pn = this.m_PropertyPath[i];
                    result = result + "" + (i + 1) + "  " + pn.parentClass.getName() + "::" + pn.toString() + ' ' + pn.value.toString() + '\n';
                }
            }
            result = result + "Custom property name:" + this.m_PropertyPath[this.m_PropertyPath.length - 1].toString() + '\n';
            result = result + "Custom property values:\n";
            for (i = 0; i < Array.getLength(this.m_PropertyArray); ++i) {
                Object current = Array.get(this.m_PropertyArray, i);
                result = result + " " + (i + 1) + " " + current.getClass().getName() + " " + current.toString() + '\n';
            }
        }
        result = result + "ResultProducer: " + this.m_ResultProducer + '\n';
        result = result + "ResultListener: " + this.m_ResultListener + '\n';
        if (!this.getNotes().equals("")) {
            result = result + "Notes: " + this.getNotes();
        }
        return result;
    }

    public static Experiment read(String filename) throws Exception {
        Experiment result;
        if (KOML.isPresent() && filename.toLowerCase().endsWith(".koml")) {
            result = (Experiment)KOML.read(filename);
        } else if (filename.toLowerCase().endsWith(".xml")) {
            XMLExperiment xml = new XMLExperiment();
            result = (Experiment)xml.read(filename);
        } else {
            FileInputStream fi = new FileInputStream(filename);
            ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
            result = (Experiment)oi.readObject();
            oi.close();
        }
        return result;
    }

    public static void write(String filename, Experiment exp) throws Exception {
        if (KOML.isPresent() && filename.toLowerCase().endsWith(".koml")) {
            KOML.write(filename, (Object)exp);
        } else if (filename.toLowerCase().endsWith(".xml")) {
            XMLExperiment xml = new XMLExperiment();
            xml.write(filename, (Object)exp);
        } else {
            FileOutputStream fo = new FileOutputStream(filename);
            ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(fo));
            oo.writeObject(exp);
            oo.close();
        }
    }

    public static void main(String[] args) {
        try {
            WekaPackageManager.loadPackages(false, true, false);
            Experiment exp = null;
            String xmlOption = Utils.getOption("xml", args);
            if (!xmlOption.equals("")) {
                args = new XMLOptions(xmlOption).toArray();
            }
            String expFile = Utils.getOption('l', args);
            String saveFile = Utils.getOption('s', args);
            boolean runExp = Utils.getFlag('r', args);
            boolean verbose = Utils.getFlag("verbose", args);
            if (expFile.length() == 0) {
                exp = new Experiment();
                try {
                    exp.setOptions(args);
                    Utils.checkForRemainingOptions(args);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    String result = "Usage:\n\n-l <exp|xml file>\n\tLoad experiment from file (default use cli options).\n\tThe type is determined, based on the extension (" + FILE_EXTENSION + " or .xml)\n" + "-s <exp|xml file>\n" + "\tSave experiment to file after setting other options.\n" + "\tThe type is determined, based on the extension (" + FILE_EXTENSION + " or .xml)\n" + "\t(default don't save)\n" + "-r\n" + "\tRun experiment (default don't run)\n" + "-xml <filename | xml-string>\n" + "\tget options from XML-Data instead from parameters.\n" + "-verbose\n" + "\toutput progress information to std out." + "\n";
                    Enumeration<Option> enm = exp.listOptions();
                    while (enm.hasMoreElements()) {
                        Option option = enm.nextElement();
                        result = result + option.synopsis() + "\n";
                        result = result + option.description() + "\n";
                    }
                    throw new Exception(result + "\n" + ex.getMessage());
                }
            } else {
                String dataName;
                exp = Experiment.read(expFile);
                if (exp instanceof RemoteExperiment) {
                    throw new Exception("Cannot run remote experiment using Experiment class. Use RemoteExperiment class instead!");
                }
                do {
                    if ((dataName = Utils.getOption('T', args)).length() == 0) continue;
                    File dataset = new File(dataName);
                    exp.getDatasets().addElement(dataset);
                } while (dataName.length() != 0);
            }
            System.err.println("Experiment:\n" + exp.toString());
            if (saveFile.length() != 0) {
                Experiment.write(saveFile, exp);
            }
            if (runExp) {
                System.err.println("Initializing...");
                exp.initialize();
                System.err.println("Iterating...");
                exp.runExperiment(verbose);
                System.err.println("Postprocessing...");
                exp.postProcess();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12564 $");
    }
}

