/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.RandomTree;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.Utils;
import weka.gui.ProgrammaticProperty;

public class RandomForest
extends Bagging {
    static final long serialVersionUID = 1116839470751428698L;

    @Override
    protected int defaultNumberOfIterations() {
        return 100;
    }

    public RandomForest() {
        RandomTree rTree = new RandomTree();
        rTree.setDoNotCheckCapabilities(true);
        super.setClassifier(rTree);
        super.setRepresentCopiesUsingWeights(true);
        this.setNumIterations(this.defaultNumberOfIterations());
    }

    @Override
    public Capabilities getCapabilities() {
        return new RandomTree().getCapabilities();
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.RandomTree";
    }

    @Override
    protected String[] defaultClassifierOptions() {
        String[] args = new String[]{"-do-not-check-capabilities"};
        return args;
    }

    @Override
    public String globalInfo() {
        return "Class for constructing a forest of random trees.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "Random Forests");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "45");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "5-32");
        return result;
    }

    @Override
    @ProgrammaticProperty
    public void setClassifier(Classifier newClassifier) {
        if (!(newClassifier instanceof RandomTree)) {
            throw new IllegalArgumentException("RandomForest: Argument of setClassifier() must be a RandomTree.");
        }
        super.setClassifier(newClassifier);
    }

    @Override
    @ProgrammaticProperty
    public void setRepresentCopiesUsingWeights(boolean representUsingWeights) {
        if (!representUsingWeights) {
            throw new IllegalArgumentException("RandomForest: Argument of setRepresentCopiesUsingWeights() must be true.");
        }
        super.setRepresentCopiesUsingWeights(representUsingWeights);
    }

    public String numFeaturesTipText() {
        return ((RandomTree)this.getClassifier()).KValueTipText();
    }

    public int getNumFeatures() {
        return ((RandomTree)this.getClassifier()).getKValue();
    }

    public void setNumFeatures(int newNumFeatures) {
        ((RandomTree)this.getClassifier()).setKValue(newNumFeatures);
    }

    public String maxDepthTipText() {
        return ((RandomTree)this.getClassifier()).maxDepthTipText();
    }

    public int getMaxDepth() {
        return ((RandomTree)this.getClassifier()).getMaxDepth();
    }

    public void setMaxDepth(int value) {
        ((RandomTree)this.getClassifier()).setMaxDepth(value);
    }

    public String breakTiesRandomlyTipText() {
        return ((RandomTree)this.getClassifier()).breakTiesRandomlyTipText();
    }

    public boolean getBreakTiesRandomly() {
        return ((RandomTree)this.getClassifier()).getBreakTiesRandomly();
    }

    public void setBreakTiesRandomly(boolean newBreakTiesRandomly) {
        ((RandomTree)this.getClassifier()).setBreakTiesRandomly(newBreakTiesRandomly);
    }

    @Override
    public String toString() {
        if (this.m_Classifiers == null) {
            return "RandomForest: No model built yet.";
        }
        StringBuffer buffer = new StringBuffer("RandomForest\n\n");
        buffer.append(super.toString());
        return buffer.toString();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSize of each bag, as a percentage of the\n\ttraining set size. (default 100)", "P", 1, "-P"));
        newVector.addElement(new Option("\tCalculate the out of bag error.", "O", 0, "-O"));
        newVector.addElement(new Option("\tWhether to store out of bag predictions in internal evaluation object.", "store-out-of-bag-predictions", 0, "-store-out-of-bag-predictions"));
        newVector.addElement(new Option("\tWhether to output complexity-based statistics when out-of-bag evaluation is performed.", "output-out-of-bag-complexity-statistics", 0, "-output-out-of-bag-complexity-statistics"));
        newVector.addElement(new Option("\tPrint the individual classifiers in the output", "print", 0, "-print"));
        newVector.addElement(new Option("\tNumber of iterations.\n\t(current value " + this.getNumIterations() + ")", "I", 1, "-I <num>"));
        newVector.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)\n\t(use 0 to auto-detect number of cores)", "num-slots", 1, "-num-slots <num>"));
        ArrayList<Option> list = Collections.list(((OptionHandler)((Object)this.getClassifier())).listOptions());
        newVector.addAll(list);
        return newVector.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-P");
        result.add("" + this.getBagSizePercent());
        if (this.getCalcOutOfBag()) {
            result.add("-O");
        }
        if (this.getStoreOutOfBagPredictions()) {
            result.add("-store-out-of-bag-predictions");
        }
        if (this.getOutputOutOfBagComplexityStatistics()) {
            result.add("-output-out-of-bag-complexity-statistics");
        }
        if (this.getPrintClassifiers()) {
            result.add("-print");
        }
        result.add("-I");
        result.add("" + this.getNumIterations());
        result.add("-num-slots");
        result.add("" + this.getNumExecutionSlots());
        if (this.getDoNotCheckCapabilities()) {
            result.add("-do-not-check-capabilities");
        }
        Vector<String> classifierOptions = new Vector<String>();
        Collections.addAll(classifierOptions, ((OptionHandler)((Object)this.getClassifier())).getOptions());
        Option.deleteFlagString(classifierOptions, "-do-not-check-capabilities");
        result.addAll(classifierOptions);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String bagSize = Utils.getOption('P', options);
        if (bagSize.length() != 0) {
            this.setBagSizePercent(Integer.parseInt(bagSize));
        } else {
            this.setBagSizePercent(100);
        }
        this.setCalcOutOfBag(Utils.getFlag('O', options));
        this.setStoreOutOfBagPredictions(Utils.getFlag("store-out-of-bag-predictions", options));
        this.setOutputOutOfBagComplexityStatistics(Utils.getFlag("output-out-of-bag-complexity-statistics", options));
        this.setPrintClassifiers(Utils.getFlag("print", options));
        String iterations = Utils.getOption('I', options);
        if (iterations.length() != 0) {
            this.setNumIterations(Integer.parseInt(iterations));
        } else {
            this.setNumIterations(this.defaultNumberOfIterations());
        }
        String numSlots = Utils.getOption("num-slots", options);
        if (numSlots.length() != 0) {
            this.setNumExecutionSlots(Integer.parseInt(numSlots));
        } else {
            this.setNumExecutionSlots(1);
        }
        RandomTree classifier = (RandomTree)AbstractClassifier.forName(this.defaultClassifierString(), options);
        this.setDoNotCheckCapabilities(classifier.getDoNotCheckCapabilities());
        this.setSeed(classifier.getSeed());
        this.setDebug(classifier.getDebug());
        this.setNumFeatures(classifier.getNumDecimalPlaces());
        classifier.setDoNotCheckCapabilities(true);
        this.setClassifier(classifier);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12645 $");
    }

    public static void main(String[] argv) {
        RandomForest.runClassifier(new RandomForest(), argv);
    }
}

