/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.ANR;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.Globals.FileManagement;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.GCNet;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.ProcessConfig;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.ProcessDataset;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Randomize;

public class ClassifierMLPerceptron {
    static Randomize rand;
    static Vector noisyInstances;

    private static int argmax(double[] x) {
        double max = x[0];
        int imax = 0;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
            imax = i;
        }
        return imax;
    }

    private static void neuralClassificationLS(boolean tty, ProcessConfig pc) {
        try {
            ProcessDataset pd = new ProcessDataset();
            String line = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processClassifierDataset(line, true);
            } else {
                pd.oldClusteringProcess(line);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            pd.showDatasetStatistics();
            double[][] X = pd.getX();
            int[] C = pd.getC();
            int[] Ct = new int[C.length];
            int nClasses = pd.getNclasses();
            double[] eMaximum = pd.getImaximum();
            double[] eMinimum = pd.getIminimum();
            int[] nIpartition = new int[nInputs];
            double[][] Cbin = new double[nData][nClasses];
            for (int i = 0; i < nData; ++i) {
                Cbin[i][C[i]] = 1.0;
            }
            int[] elements = ProcessConfig.parNetTopo;
            int nLayers = elements.length;
            System.out.println(nLayers);
            System.out.println(nInputs);
            System.out.println(nClasses);
            System.out.println(elements[0]);
            int weightDimension = 0;
            if (nLayers == 0) {
                weightDimension = (nInputs + 1) * nClasses;
            } else {
                weightDimension = (nInputs + 1) * elements[0];
                for (int i = 1; i < nLayers; ++i) {
                    weightDimension += (elements[i - 1] + 1) * elements[i];
                }
                weightDimension += nClasses * (elements[nLayers - 1] + 1);
            }
            double[] weights = new double[weightDimension];
            GCNet gcn = new GCNet();
            double error = gcn.nntrain(nInputs, 1, X, Cbin, elements, weights, rand);
            double nfaults = 0.0;
            try {
                for (int i = 0; i < X.length; ++i) {
                    double[] resp = gcn.nnoutput(X[i]);
                    int clase = ClassifierMLPerceptron.argmax(resp);
                    if (clase != C[i]) {
                        nfaults += 1.0;
                    }
                    Ct[i] = clase;
                }
                System.out.println("Train error=" + (nfaults /= (double)nData));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            ProcessDataset pdt = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(1);
            if (ProcessConfig.parNewFormat) {
                pdt.processClassifierDataset(line, false);
            } else {
                pdt.oldClusteringProcess(line);
            }
            int nprueba = pdt.getNdata();
            int npvariables = pdt.getNvariables();
            int npentradas = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (npentradas != nInputs) {
                throw new IOException("Test file IOERR");
            }
            double[][] Xp = pdt.getX();
            int[] Cp = pdt.getC();
            int[] Co = new int[Cp.length];
            try {
                nfaults = 0.0;
                for (int i = 0; i < Xp.length; ++i) {
                    double[] resp = gcn.nnoutput(Xp[i]);
                    int clase = ClassifierMLPerceptron.argmax(resp);
                    if (clase != Cp[i]) {
                        nfaults += 1.0;
                    }
                    Co[i] = clase;
                }
                System.out.println("Test error=" + (nfaults /= (double)Cp.length));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            noisyInstances = gcn.getNoisyInstances();
            System.out.println(noisyInstances);
            System.out.println((String)ProcessConfig.parInputData.get(0));
            System.out.println(ProcessConfig.parResultTrainName);
            System.out.println((String)ProcessConfig.parInputData.get(1));
            System.out.println(ProcessConfig.parResultName);
            ClassifierMLPerceptron.createDatasets((String)ProcessConfig.parInputData.get(0), ProcessConfig.parResultTrainName, (String)ProcessConfig.parInputData.get(1), ProcessConfig.parResultName);
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " File not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read Error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algo = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        ClassifierMLPerceptron cl = new ClassifierMLPerceptron();
        ClassifierMLPerceptron.neuralClassificationLS(tty, pc);
    }

    public static void createDatasets(String trainIN, String trainOUT, String testIN, String testOUT) {
        InstanceSet is = new InstanceSet();
        Instance[] instances = null;
        try {
            is.readSet(trainIN, false);
            instances = is.getInstances();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int numAtt = Attributes.getInputNumAttributes();
        String header = "";
        header = "@relation " + Attributes.getRelationName() + "\n";
        header = header + Attributes.getInputAttributesHeader();
        header = header + Attributes.getOutputAttributesHeader();
        header = header + Attributes.getInputHeader() + "\n";
        header = header + Attributes.getOutputHeader() + "\n";
        header = header + "@data\n";
        FileManagement fm = new FileManagement();
        Attribute[] att = Attributes.getInputAttributes();
        boolean saltar = false;
        try {
            fm.initWrite(trainOUT);
            fm.writeLine(header);
            int numNoisyEx = 0;
            for (int i = 0; i < instances.length; ++i) {
                Integer auxInteger1;
                int auxInt2;
                saltar = false;
                if (numNoisyEx < noisyInstances.size() && (auxInt2 = (auxInteger1 = (Integer)noisyInstances.get(numNoisyEx)).intValue()) == i) {
                    ++numNoisyEx;
                    saltar = true;
                }
                if (saltar) continue;
                boolean[] missing = instances[i].getInputMissingValues();
                String newInstance = "";
                for (int j = 0; j < numAtt; ++j) {
                    if (missing[j]) {
                        newInstance = newInstance + "?";
                    } else {
                        if (att[j].getType() == 2) {
                            newInstance = newInstance + instances[i].getInputRealValues(j);
                        }
                        if (att[j].getType() == 1) {
                            newInstance = newInstance + (int)instances[i].getInputRealValues(j);
                        }
                        if (att[j].getType() == 0) {
                            newInstance = newInstance + instances[i].getInputNominalValues(j);
                        }
                    }
                    newInstance = newInstance + ", ";
                }
                String className = instances[i].getOutputNominalValues(0);
                newInstance = newInstance + className + "\n";
                fm.writeLine(newInstance);
            }
            fm.closeWrite();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            String s;
            File Archi1 = new File(testIN);
            File Archi2 = new File(testOUT);
            BufferedReader in = new BufferedReader(new FileReader(Archi1));
            PrintWriter out = new PrintWriter(new FileWriter(Archi2));
            while ((s = in.readLine()) != null) {
                out.println(s);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

