### R code from vignette source 'Vignette.Rnw'

###################################################
### code chunk number 1: Vignette.Rnw:38-41
###################################################
require(ggplot2)
require(reshape2)
require(plyr)


###################################################
### code chunk number 2: Vignette.Rnw:43-44
###################################################
require(MGLM)


###################################################
### code chunk number 3: Vignette.Rnw:49-51
###################################################
data(iris)
Y <-iris[, 1:4]


###################################################
### code chunk number 4: scatter1
###################################################
scatter.plot <- function(Y, main=NULL, free=TRUE, ...){
   "ID" <- "variable1"<-"value1" <- "value" <- NULL
  if(is.matrix(Y)){
    Y <- as.data.frame(Y)
    Y$ID <- rownames(Y)
  }else if(is.data.frame(Y)){
    Y$ID <- row.names(Y)
  }else{
    stop("Please provide a matrix or a data frame.")
  }
  meltDf <- melt(Y, id='ID')
  names(meltDf) <- c("ID", "variable1", "value1")
  out <- ddply(meltDf, .(variable1), function(df, df2){
    excl <- unique(df$variable)
    outDf <- merge(df, df2, by="ID")
  }, Y)
  meltDf2 <- melt(out, id=c("ID", "variable1", "value1"))
  meltDf2$value <- ifelse(meltDf2$variable1==meltDf2$variable, NA, 
                          meltDf2$value)
  meltDf2 <- subset(meltDf2, !is.na(value))
  if(!free){
  plot <- ggplot(meltDf2, aes(x=value1, y=value)) + 
    geom_point() + 
    facet_grid(variable1~variable,as.table=FALSE) +
    xlab("") + ylab("") + ggtitle(main) + 
    theme_bw()+
    theme(axis.text.x=element_text(size=6),
          axis.text.y=element_text(size=6))
  }else{
    plot <- ggplot(meltDf2, aes(x=value1, y=value)) + 
      geom_point() + 
      facet_wrap(variable1~variable,as.table=FALSE, scales="free") +
      xlab("") + ylab("") + ggtitle(main) + 
      theme_bw()+
      theme(axis.text.x=element_text(size=6),
            axis.text.y=element_text(size=6))
  }
  

  return(plot)
}

scatter.plot(Y, free=TRUE)


###################################################
### code chunk number 5: corr
###################################################
corr.plot <- function(Y, main=NULL){
  "Var1" <- "Var2" <- "value" <- NULL
  df <- melt(cor(Y))
  names(df) <- c(c("Var1", "Var2", "value"))
  plot <- qplot(x=Var1, y=Var2, data=subset(df, Var1!=Var2), 
    fill=factor(as.character(sign(value)), levels=c("-1", "1")), 
    alpha=value, geom="tile")+
    theme_bw()+
    scale_alpha(guide=FALSE)+
    scale_fill_discrete("", drop=FALSE) + 
    ggtitle(main)+
    xlab("") + ylab("")

  return(plot)
}
corr.plot(Y)


###################################################
### code chunk number 6: scatter1
###################################################
scatter.plot <- function(Y, main=NULL, free=TRUE, ...){
   "ID" <- "variable1"<-"value1" <- "value" <- NULL
  if(is.matrix(Y)){
    Y <- as.data.frame(Y)
    Y$ID <- rownames(Y)
  }else if(is.data.frame(Y)){
    Y$ID <- row.names(Y)
  }else{
    stop("Please provide a matrix or a data frame.")
  }
  meltDf <- melt(Y, id='ID')
  names(meltDf) <- c("ID", "variable1", "value1")
  out <- ddply(meltDf, .(variable1), function(df, df2){
    excl <- unique(df$variable)
    outDf <- merge(df, df2, by="ID")
  }, Y)
  meltDf2 <- melt(out, id=c("ID", "variable1", "value1"))
  meltDf2$value <- ifelse(meltDf2$variable1==meltDf2$variable, NA, 
                          meltDf2$value)
  meltDf2 <- subset(meltDf2, !is.na(value))
  if(!free){
  plot <- ggplot(meltDf2, aes(x=value1, y=value)) + 
    geom_point() + 
    facet_grid(variable1~variable,as.table=FALSE) +
    xlab("") + ylab("") + ggtitle(main) + 
    theme_bw()+
    theme(axis.text.x=element_text(size=6),
          axis.text.y=element_text(size=6))
  }else{
    plot <- ggplot(meltDf2, aes(x=value1, y=value)) + 
      geom_point() + 
      facet_wrap(variable1~variable,as.table=FALSE, scales="free") +
      xlab("") + ylab("") + ggtitle(main) + 
      theme_bw()+
      theme(axis.text.x=element_text(size=6),
            axis.text.y=element_text(size=6))
  }
  

  return(plot)
}

scatter.plot(Y, free=TRUE)


###################################################
### code chunk number 7: corr
###################################################
corr.plot <- function(Y, main=NULL){
  "Var1" <- "Var2" <- "value" <- NULL
  df <- melt(cor(Y))
  names(df) <- c(c("Var1", "Var2", "value"))
  plot <- qplot(x=Var1, y=Var2, data=subset(df, Var1!=Var2), 
    fill=factor(as.character(sign(value)), levels=c("-1", "1")), 
    alpha=value, geom="tile")+
    theme_bw()+
    scale_alpha(guide=FALSE)+
    scale_fill_discrete("", drop=FALSE) + 
    ggtitle(main)+
    xlab("") + ylab("")

  return(plot)
}
corr.plot(Y)


###################################################
### code chunk number 8: Vignette.Rnw:151-157
###################################################
set.seed(123)
n <- 200
d <- 4
alpha <- rep(1,d)
m <- 50
Y <- rmn(m, alpha, n)


###################################################
### code chunk number 9: Vignette.Rnw:160-162
###################################################
mnFit <- MGLMfit(Y, dist="DM")
print(mnFit)


###################################################
### code chunk number 10: Vignette.Rnw:169-175
###################################################
set.seed(123)
n <- 200
d <- 4
alpha <- rep(1, d)
m <- 50
Y <- rdirm(m, alpha, n)


###################################################
### code chunk number 11: Vignette.Rnw:177-179
###################################################
dmFit <- MGLMfit(Y, dist="DM")
print(dmFit)


###################################################
### code chunk number 12: Vignette.Rnw:186-188
###################################################
gdmFit <- MGLMfit(Y, dist="GDM")
print(gdmFit)


###################################################
### code chunk number 13: Vignette.Rnw:196-205
###################################################
set.seed(124)
n <- 200
d <- 4
alpha <- rep(1, d-1)
beta <- rep(1, d-1)
m <- 50
Y <- rgdirm(m, alpha, beta, n)
gdmFit <- MGLMfit(Y, dist="GDM")
print(gdmFit)


###################################################
### code chunk number 14: Vignette.Rnw:211-220
###################################################
set.seed(1220)
n <- 100
d <- 4
p <- 5
prob <- rep(0.2, d)
beta <- 10
Y <- rnegmn(prob, beta, n)
negmnFit <- MGLMfit(Y, dist="NegMN")
print(negmnFit)


###################################################
### code chunk number 15: Vignette.Rnw:238-251
###################################################
set.seed(1234)
n <- 200
p <- 5
d <- 4
X <- matrix(runif(p*n), n, p)
alpha <- matrix(c(0.6, 0.8, 1), p, d-1, byrow=TRUE)
alpha[c(1,2),] <- 0
Alpha <- exp(X%*%alpha)
beta <- matrix(c(1.2, 1, 0.6), p, d-1, byrow=TRUE)
beta[c(1,2),] <- 0
Beta <- exp(X%*%beta)
m <- runif(n, min=0, max=25) + 25
Y <- rgdirm(m, Alpha, Beta)


###################################################
### code chunk number 16: Vignette.Rnw:257-259
###################################################
mnReg <- MGLMreg(Y~0+X, dist="MN")
print(mnReg)


###################################################
### code chunk number 17: Vignette.Rnw:266-268
###################################################
dmReg <- MGLMreg(Y~0+X, dist="DM")
print(dmReg)


###################################################
### code chunk number 18: Vignette.Rnw:275-277
###################################################
gdmReg <- MGLMreg(Y~0+X, dist="GDM")
print(gdmReg)


###################################################
### code chunk number 19: Vignette.Rnw:284-286
###################################################
negReg <- MGLMreg(Y~0+X, dist="NegMN", regBeta=FALSE)
print(negReg)


###################################################
### code chunk number 20: Vignette.Rnw:300-303
###################################################
newX <- matrix(runif(1*p), 1, p)
pred <- predict(gdmReg, newX)
pred


###################################################
### code chunk number 21: Vignette.Rnw:319-329
###################################################
set.seed(118)
n <- 100
p <- 10
d <- 5
m <- rbinom(n, 200, 0.8)
X <- matrix(rnorm(n*p),n, p)
alpha <- matrix(0, p, d)
alpha[c(1,3, 5), ] <- 1
Alpha <- exp(X%*%alpha)
Y <- rdirm(size=m, alpha=Alpha)


###################################################
### code chunk number 22: Vignette.Rnw:334-336
###################################################
sweep <- MGLMtune(Y~0+X, dist="DM", penalty="sweep", ngridpt=30)
print(sweep$select)


###################################################
### code chunk number 23: Vignette.Rnw:360-362
###################################################
group <- MGLMtune(Y~0+X, dist="DM", penalty="group", ngridpt=30)
print(group$select)


###################################################
### code chunk number 24: Vignette.Rnw:386-388
###################################################
nuclear <- MGLMtune(Y~0+X, dist="DM", penalty="nuclear", ngridpt=30, warm.start=FALSE)
print(nuclear$select)


