package Acme::MetaSyntactic::dune;

use strict;
use warnings;

our $VERSION = '0.01';

use Acme::MetaSyntactic::MultiList;

use parent 'Acme::MetaSyntactic::MultiList';

__PACKAGE__->init();

=head1 NAME

Acme::MetaSyntactic::dune - For he is the Kwisatz Haderach!

=head1 SYNOPSIS

	meta dune
	meta --category individuals dune
	meta --category individuals/fish_speakers dune

=head1 DESCRIPTION

This C<< Acme::MetaSyntactic >> theme contains codenames related to the Dune series.

There are several subcategories; see below for a full list. The default is
C<:all>. Codenames can appear in more than one.

=head1 THEMES AND SUBTHEMES

=over 2

=item bene_gesserit

=item creatures

=item events

=item fremen_culture

=item houses

=item individuals/caladanians

=item individuals/cogitors

=item individuals/counts

=item individuals/countesses

=item individuals/females

=item individuals/fish_speakers

=item individuals/fremen

=item individuals/ixians

=item individuals/league_of_nobles_members

=item individuals/males

=item individuals/new_sisterhood

=item individuals/sorceresses_of_rossak

=item individuals/swordmasters

=item individuals/mentats

=item individuals/religious_figures

=item individuals/scientists

=item individuals/slaves

=item individuals/titans

=item individuals/zenshiites

=item individuals/zensunnis

=item organizations

=item places/arrakis_locations

=item places/cities

=item places/planets

=item technology/devices

=item technology/general

=item technology/holtzman_technology

=item technology/starship

=item technology/thinking_machines

=item technology/vehicles

=item technology/weapons

=back

=head1 SOURCES

The Dune wiki, L<http://dune.wikia.com/>

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<http://dune.wikia.com/>

=head1 AUTHOR

Mike Cartmell, C<< <mike at mikec.me> >>

=head1 ACKNOWLEDGEMENTS

=over 2 

=item Frank Herbert, for writing Dune.

=item David Lynch, for directing the film.

=item David Buckhurst, for he is the Kwisatz Haderach.

=back

=head1 LICENSE AND COPYRIGHT

Copyright 2013 Mike Cartmell.

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=cut

1;

__DATA__
# default
:all
# names bene_gesserit
abomination accadia acolyte alma_mavis_taraza aloana_streggi anirul archives_mother aver_yohsa awareness_spectrum azhar_book baram bellonda bene_gesserit_training breeding_program burzmali calissa carlana cassius_ida_treac chapterhouse cienna clairby corysta cristane dardanius_leona_shard darwi_odrade dortujla duana ego_memory elyen females fintil gaius_helen_mohiam garimi genetic_memory genetics gianne_idaho guilt_caster harishka hesterion hidden_noble_rank hidden_rank holy_sister irulan jalanto janet_roxbrough jessica kipuna kwisatz_haderach kwisatz_mother lampadas lanali linchine litany_against_fear lobia loschy_teg lucilla luran_geasa marcus_claire_luyseyal margot_fenring marius_alethea_blasco mater_cogita_vera miles_teg miral_alchem missionaria_protectiva montemagni mother_commander mother_superior mothers murbella organizations_and_groups osafa_chram other_memory palma panoplia_propheticus placido_salat prana_bindu pre_born prester proctor quintinius_violet_chenoeh raquella_berto_anirul rebecca reverend_mother sabanda schwangyu sheeana_brugh star_jewel_project stokes stokia suipol tamalane tanisia_idaho tawsuoko tertius_eileen_anteac tessia_vernius thora tonia_obregah_xo truthsayer wallach_ix wanna_marcus water_of_life weirding_way
# names creatures
blackbird bristleback burrhorse butterfish butterfish centipede desert_hare desert_hawk desert_mouse desert_owl eagle elecran futar gaze_hound hawk heart_scallop kangaroo_mouse kulon laccifera_arctica laza_tiger leech_bat milkbug panther_fish qaraa ruh_yak salusan_bull salusan_tiger sandtrout sandworm scorpion seaworm slarpon slig turtlebug
# names events
arbelough arrakis_revolt ascension_of_house assault_on_poritrin assault_on_rossak battle_at_ularda battle_of_arrakeen battle_of_bela_tegeuse battle_of_caladan battle_of_corrin battle_of_earth battle_of_ellram battle_of_englichannel battle_of_giedi_prime battle_of_iv_anbus battle_of_ix battle_of_ix battle_of_peridot_colony battle_of_zimia battles butlerian_jihad butlerian_jihad civil_war famine_times first_golden_age first_hrethgir_rebellion great_convention great_purge great_spice_war great_spice_war honru_massacre kralizec lampadas liberation_of_giedi_prime liberation_of_honru liberation_of_ix liberation_of_parmentier liberation_of_tyndall little_dark_ages rebellion_of_ix rebellion_on_earth return_of_the_honored_matres scattering second_battle_of_ix second_battle_of_zimia second_reunification silicon_plague star_jewel_project time_of_titans tupile_treaty
# names fremen_culture
amtal_rule arrakis_revolt baradye_pistol battle_of_arrakeen bi_lal_kaifa cast_out catchbasin cave_of_ridges coffee creosote_bush crysknife deathstill deep_desert desert_mouse eyes_of_ibad fedaykin fremkit gift_to_the_thirsty jihad maker_hook mudir naib oral_history paracompass planting_areas sayyadina shadout shai_hulud sietch skull_tomb spice_melange spice_orgy stillsuit stillsuit_shops stilltent tahaddi_challenge the_eyes_of_muaddib thumper wali wandering_zensunni water_of_life water_rings watertube weirding_way wind_etching windtrap yali
# names houses
house_atreides house_corrino house_ecaz house_fenring house_galloway house_ginaz house_hagal house_heiron house_jaederan house_jongleur house_khumali house_major house_masudi house_mcnaught house_metulli house_moritani house_mutelli house_nebiro house_ordos house_pardee house_plana house_rabban house_richese house_taligari house_tantor house_thorvald house_vernius house_wayku
# names individuals caladanians
brom deegan duncan_idaho elto_vitt estes gurney_halleck helena hoh_vitt jessica kagin kalem kuros leronica leto minos_ix minos_viii minotauros paulos_xvi paulos_xviii philippos_xv swain thufir_hawat victor
# names individuals cogitors
arn_eklo kwyna reticulus vidad
# names individuals counts
glossu hasimir ilban otho
# names individuals countesses
edwina margot
# names individuals females
accadia alexandra_ecaz alia alra_kio amia_yo anirul annine ardeth aver_yohsa baram barbara_mutelli becca bellonda brigit_paterson bruda_viol calissa camie_boro caree_debrak carlana chalice chamal chani_kynes chaola_fenring chiara cienna cilla_moritani cirni_fenring cleopatra clere_ruitt clio_ii corysta cristane crystane_and_tara daphne darwi_odrade dimela doria doris_bhrazen duana dunamis edwina elpek elyen emmi_rabban falina faroula fintil firenza_thorvald floriscia_xico frieth gaius_helen_mohiam garimi ghanima gianne_idaho gillian_lieuw glyffa habla hadi_benotto harah harishka hecate helena hellica helmina_berto_anirul hierta hippolute hwi_noree ilesa_ecaz ingva iriel irina_lankiveil irulan jalanto janess_idaho janess_milam janet_roxbrough jehane_golitle jehanne_butler jessica jessica_boro_ginjo josifa juno kailea_vernius karida_julan katarina katarina_omal kiria kohe_tantor kubebe kwyna lanali lenise leronica_tergiet lichna linchine livia_butler lobia logno lovisa_rogier lucilla lucille_tantor luran_geasa mapes marha maria_i marie_fenring marotin mesa_ecaz miral_alchem mitha montemagni muertana_sarobella munoza_chen murbella nathra_kiane nayla niriem norma_cevna nortie_vandego octa_butler omilia oracle_of_time osafa_chram ozza quintinius_violet_chenoeh ramallo rayna_butler rebecca rinya_idaho roella rugi sabanda salusa sanya_ecaz serena_butler shando_vernius sheel_tantor siona steff_young stina_pilru taina tanisia_idaho thora tonia_obregah_xo urania victoria wandra_butler wensicia wensicia_mutelli yuell_onder yuta_brey yvette_hagal
# names individuals fish_speakers
ardeth duncan_idaho nayla siaynoq
# names individuals fremen
akrab al_baz alia aliid chani_kynes defa_l_fanini duncan_idaho enno farok faroula forad frieth geoff ghanima harah heinar ichwan_bedwine iduali ishmael jafar jamis javid jerath jessica kaleff kamal_salah karmara_al_jofar korba leto_ii lichna liet_kynes mapes mitha muaddib ommun otheym pardot_kynes paul ramallo rothar shaitan sheeana_brugh shishakli stilgar the_preacher uliet umma usul warrick 
# names individuals ixians
bronso_of_ix cammar_pilru ctair_pilru davee_rogo dmurr_pilru dominic_vernius gaylord_vernius handon hwi_noree jehanne_butler kailea_vernius miral_alchem norma_cevna rhombur_vernius shando_vernius shayama_sen stina_pilru suboid tessia_vernius tio_holtzman urania xerxes yuta_brey zhaz
# names individuals league_of_nobles_members
bovko_manresa brevin_okukovich chiry emil_tantor faykan_butler fredo_butler hosten_fru jaymes_powder jimbay_whit jool_noret keats lauderdale lucille_tantor manion_butler nivny_omura pinquer_jibb quentin_butler rajid_suk rell_arkov rico rikov_butler sajak_bludd steff_young sumi tambir_boro_ginjo tio_holtzman vannibal_meach vaughn_wilby xavier yorek_thurr
# names individuals males
abdel abulurd_rabban achilleus agamemnon agamemnon aimilianos ajax aken_hesban akrab al_baz albe alberto_ginaztera albertus alexander alexandros alexios aliid alkman ammon anton_miche aquim aristeteles_aigisthodes armand_ecaz arn_eklo aaudrii avelard bain_ogaree barbarossa basil beely_ridondo bel_moulay beowulf bijaz bindikk_narvi biondi brom_tergiet bronso_of_ix buer_agarves burah burbage burzmali chalic christopher_kuenn clairby claude_jozziny colus constantine_xi corrin costin crozeed ctair_pilru cyril dalak_fenring damiano_fulgencio daryai_ezhar_vi davee_rogo deegan demetrios dhartha dioicetes_asetirides dmurr_pilru dondar_kooreeg ebbin ebrahim edric elas_yungar elhiim eli_dupleix elias elim elliott elrood elto_vitt enno ereboam ertun esteban_borges estes estil ezhar fafnir fallen_emperor faradn farok favo_bludd faykan_butler ferdinand_ecaz feyd firus forad forbin four_arms fredo_butler frigo_bludd hasimir_fenring hundri_arbar iakobos iason jav_barri kagin konstantinos leto manion_butler manion_butler_the_innocent moneo old_duke paul piter_de_vries porce_bludd quentin_butler rikov_butler rivvy_dinari sajak_bludd tambir_boro_ginjo toure_bomoko victor vorian xander_boro_ginjo
# names individuals mentats
ammon bellonda cyril gilbertus_albans grodon_orpar_playt_iii miles_teg noree_moneo paul piter_de_vries radnor rhajia thufir_hawat twisted_mentat
# names individuals new_sisterhood
archives_mother caree_debrak doria gianne_idaho iriel janess_idaho kiria laera mother_commander rinya_idaho tanisia_idaho valkyries wikki_aztin
# names individuals religious_figures
alia iblis_ginjo livia_butler manion_butler_the_innocent oracle_of_time serena_butler urania xavier
# names individuals sorceresses_of_rossak
camio conqee_cenva heoma karee_marques rucia silin ticia_cenva tirbes zufa_cenva
# names individuals scientists
christopher_kuenn daiwid_kuuan davee_rogo doris_bhrazen dorit_pachtra gweleder_dadas_nerm hoont_kauriip hundri_arbar ibrahim_vaughn_holtzman ingslei irina_lankiveil jehane_golitle krai kruwl_sheivvun lors_karden maro_ghappato mohandas_suk neja_nnam_krib norma_cenva norma_cevna nortie_vandego rajid_suk ravan staivan tio_holtzman tyrj
# names individuals slaves
amia_yo bel_moulay chamal falina ingu ohan_freer ozza rafel solver taina
# names individuals swordmasters
borys chirox ginaz ginaz_tenth_level hiih_resser istian_goss janess_idaho jav_barri jool_noret mord_cour nar_trig rivvy_dinari shar whitmore_bludd zon_noret
# names individuals titans
agamemnon ajax alexander barbarossa caesar dante hecate juno tamerlane tlaloc xerxes
# names individuals zenshiites
aliid bel_moulay rhengalid
# names individuals zensunnis
abdel aziz chamal dhartha ebrahim elhiim falina glyffa hierta ibin_manzuur ingu ishmael jafar marha ozza rafel selim_wormrider taina tiddoc weyop
# names organizations
army_of_humanity army_of_the_jihad bene_gesserit bene_tleilax bhotani choam cogitor cult_of_serena dragoon foldspace_shipping_company fremen giedi_prime_home_guard ginaz_swordmasters honored_matres humanity_first ixian ixian_confederacy jihad_council jipol landsraad league_armada library_confraternity lishash_confederation lords_council martyrists muadru new_sisterhood parmentier_home_guard qizarate rakian_priesthood roc salusan_militia sardau sardaukar seraphim sisters_in_isolation sixth_draco_wing slaver smuggler spacing_guild suboid suk_inner_school theater_of_shards titans transcom vengeance_fleet venkee_enterprises water_peddlers_union zimia_guard
# names places arrakis_locations
arrakeen_pyons arrakis carthag cave_of_ridges deep_desert false_wall_west forbidden_forest oxtyn_pyons planting_areas plaster_basin school_of_planetology sihaya_pyons skull_tomb tsimpo_pyons tyono_pyons
# names places cities
arrakeen bandalong barony byzantium cala_city carthag comati corrinth dar_es_balat elacca giedi_city harko niubbe ritka starda thalidei vernii ysai zimia
# names places planets
acline al_dhifar andioya arbelough arrakis bela_tegeuse buzzell caladan ceres chapterhouse chusuk corrin corrin_quasi_nebula crompton culat dan dendros draconis_iv duvalle earth ecaz eluzai enfeil extaris galicia gallatin gamma_vertis_vii gammu gamont giedi_prime ginaz grand_hain grumman hagal harmonthep hassika_v hessra hestia iii_delta_kaising iii_delta_pavonis ipyr ishia ishkal ix jericha junction jupiter juzzubal kaitain kolhar kronin lampadas lankiveil lernaeus liesco_ii lishash maktiun_iii markon menaris naraj niushe norstrilia novebruns palma parlon pilargo pital places poritrin prison_planet qelso reenol renditai revona rhisso richese rikkas_planet ronto rossak salusa_secundus sarash_zillish seban sikun tupile wallach_ix zabulon zanovar
# names technology devices
baliset filmbook glowglobe gom_jabbar house_shield poison_snooper royal_cart scrambler_web servok shield
# names technology general
12_uri amal atomics awareness_spectrum_narcotic axlotl_tanks baradye_pistol bioholo biometal breeding_program carryall catchbasin choam computer cone_of_silence crushers cymek distrans duncan_idaho_gholas ego_likeness filmbook fire_thread flowmetal gelcircuitry gelsphere genetics ghola glowglobe guidance_cube lasgun life_extension maker_hook mathematical_compiler medpack medpak methcar mist_tube navigator_tank nells_chamber neurelectronics nullentropy organ_farms pentashield ponta_neuroknife preservation_canister scout_flyer sealant_bag servo_receiver shield space_travel spice_harvester spice_melange stasis_coffin stillsuit stilltent t_probe thinking_machines thoughtrodes thumper twisted_mentat ultraspice watcheyes watertube windtrap
# names technology holtzman_technology
alloy_resonance_generator glowpanel holtzman holtzman_effect holtzman_waves laser_pen point_source_nodes scrambler_grenade scrambler_web shield space_travel suspensor_nullification_effect suspensors
# names technology starship
ballista blockade_runner dream_voyager frigate heighliner javelin kindjal monitor norma_cevna spacefolder troop_carrier
# names technology thinking_machines
artificial_intelligence butlerian_jihad centrans chirox combat_mek construction_robots corridor_of_mirrors cymek erasmus flowmetal gelcircuitry gelsphere great_purge guidance_cube ibrahim_vaughn_holtzman independent_robot neurelectronics omnius omnius_scourge optic_threads piranha_mites robotic_vessel seurat titans valetbot watcheyes
# names technology vehicles
airvan boatcar driftbarge flyer groundcar levtrain limocar ornithopter orship railtaxi spice_harvesters spotter
# names technology weapons
bodkin cellgun chandler_pistol crysknife electronic_scrambler emperors_blade farzee_rifle flame_gel gom_jabbar hunter_seeker inkvine kindjal lasgun maula_pistol nanoblade ponta_neuroknife pulse_atomics pulse_projectiles pulse_sword reversant scrambler_grenade scrambler_mine slip_tip stone_burner stun_ball stun_projector stunner weirding_module weirding_way
