// Copyright (c) 2006-2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// MKM: I copied this from the PHP port
// (https://github.com/lstrojny/php-cld/blob/master/cld_encodings.h);
// it just copies the encodings out of encodings.pb.h and
// gives them string matching string constants

#include "encodings/proto/encodings.pb.h"

struct cld_encoding {
  const char *name;
  Encoding encoding;
};

const cld_encoding cld_encoding_info[] = {
{"ISO_8859_1", ISO_8859_1},
{"ISO_8859_2", ISO_8859_2},
{"ISO_8859_3", ISO_8859_3},
{"ISO_8859_4", ISO_8859_4},
{"ISO_8859_5", ISO_8859_5},
{"ISO_8859_6", ISO_8859_6},
{"ISO_8859_7", ISO_8859_7},
{"ISO_8859_8", ISO_8859_8},
{"ISO_8859_9", ISO_8859_9},
{"ISO_8859_10", ISO_8859_10},
{"JAPANESE_EUC_JP", JAPANESE_EUC_JP},
{"JAPANESE_SHIFT_JIS", JAPANESE_SHIFT_JIS},
{"JAPANESE_JIS", JAPANESE_JIS},
{"CHINESE_BIG5", CHINESE_BIG5},
{"CHINESE_GB", CHINESE_GB},
{"CHINESE_EUC_CN", CHINESE_EUC_CN},
{"KOREAN_EUC_KR", KOREAN_EUC_KR},
{"UNICODE", UNICODE},
{"CHINESE_EUC_DEC", CHINESE_EUC_DEC},
{"CHINESE_CNS", CHINESE_CNS},
{"CHINESE_BIG5_CP950", CHINESE_BIG5_CP950},
{"JAPANESE_CP932", JAPANESE_CP932},
{"UTF8", UTF8},
{"UNKNOWN_ENCODING", UNKNOWN_ENCODING},
{"ASCII_7BIT", ASCII_7BIT},
{"RUSSIAN_KOI8_R", RUSSIAN_KOI8_R},
{"RUSSIAN_CP1251", RUSSIAN_CP1251},
{"MSFT_CP1252", MSFT_CP1252},
{"RUSSIAN_KOI8_RU", RUSSIAN_KOI8_RU},
{"MSFT_CP1250", MSFT_CP1250},
{"ISO_8859_15", ISO_8859_15},
{"MSFT_CP1254", MSFT_CP1254},
{"MSFT_CP1257", MSFT_CP1257},
{"ISO_8859_11", ISO_8859_11},
{"MSFT_CP874", MSFT_CP874},
{"MSFT_CP1256", MSFT_CP1256},
{"MSFT_CP1255", MSFT_CP1255},
{"ISO_8859_8_I", ISO_8859_8_I},
{"HEBREW_VISUAL", HEBREW_VISUAL},
{"CZECH_CP852", CZECH_CP852},
{"CZECH_CSN_369103", CZECH_CSN_369103},
{"MSFT_CP1253", MSFT_CP1253},
{"RUSSIAN_CP866", RUSSIAN_CP866},
{"ISO_8859_13", ISO_8859_13},
{"ISO_2022_KR", ISO_2022_KR},
{"GBK", GBK},
{"GB18030", GB18030},
{"BIG5_HKSCS", BIG5_HKSCS},
{"ISO_2022_CN", ISO_2022_CN},
{"TSCII", TSCII},
{"TAMIL_MONO", TAMIL_MONO},
{"TAMIL_BI", TAMIL_BI},
{"JAGRAN", JAGRAN},
{"MACINTOSH_ROMAN", MACINTOSH_ROMAN},
{"UTF7", UTF7},
{"BHASKAR", BHASKAR},
{"HTCHANAKYA", HTCHANAKYA},
{"UTF16BE", UTF16BE},
{"UTF16LE", UTF16LE},
{"UTF32BE", UTF32BE},
{"UTF32LE", UTF32LE},
{"BINARYENC", BINARYENC},
{"HZ_GB_2312", HZ_GB_2312},
{"UTF8UTF8", UTF8UTF8},
{"TAM_ELANGO", TAM_ELANGO},
{"TAM_LTTMBARANI", TAM_LTTMBARANI},
{"TAM_SHREE", TAM_SHREE},
{"TAM_TBOOMIS", TAM_TBOOMIS},
{"TAM_TMNEWS", TAM_TMNEWS},
{"TAM_WEBTAMIL", TAM_WEBTAMIL},
{"KDDI_SHIFT_JIS", KDDI_SHIFT_JIS},
{"DOCOMO_SHIFT_JIS", DOCOMO_SHIFT_JIS},
{"SOFTBANK_SHIFT_JIS", SOFTBANK_SHIFT_JIS},
{"KDDI_ISO_2022_JP", KDDI_ISO_2022_JP},
{"SOFTBANK_ISO_2022_JP", SOFTBANK_ISO_2022_JP},
};

COMPILE_ASSERT(arraysize(cld_encoding_info) == NUM_ENCODINGS, cld_encoding_info_length_is_wrong);
