# $Id: 00-load.t 1395 2015-09-14 21:16:13Z willem $
# 

use strict;
use Test::More tests => 2;


my @module = qw(
	Net::DNS::SEC
	Net::DNS::SEC::DSA
	Net::DNS::SEC::ECDSA
	Net::DNS::SEC::ECCGOST
	Net::DNS::SEC::RSA
	Net::DNS::SEC::Keyset
	Net::DNS::SEC::Private
	Crypt::OpenSSL::Bignum
	Crypt::OpenSSL::DSA
	Crypt::OpenSSL::EC
	Crypt::OpenSSL::ECDSA
	Crypt::OpenSSL::RSA
	Digest::GOST
	Digest::SHA
	File::Spec
	MIME::Base64
	Net::DNS
	Net::DNS::RR::DNSKEY
	Net::DNS::RR::KEY
	Net::DNS::RR::RRSIG
	Net::DNS::RR::SIG
	);


diag("\nThese tests were run with:\n");
foreach my $module (@module) {
	my $loaded = eval("require $module") || 0;
	my $revnum = $loaded ? $module->VERSION : "\t\tn/a";
	diag sprintf "\t%-25s  %s", $module, $revnum || '?';
}


use_ok('Net::DNS::SEC::Private');

use_ok('Net::DNS::SEC::Keyset');

