
######################################################################
## $Id: TextField.pm 12457 2009-01-20 13:55:26Z spadkins $
######################################################################

package App::Widget::TextField;
$VERSION = (q$Revision: 12457 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Widget::Stylizable;
@ISA = ( "App::Widget::Stylizable" );

use strict;

=head1 NAME

App::Widget::TextField - An HTML text field

=head1 SYNOPSIS

   $name = "first_name";
   # official way
   use App;
   $context = App->context();
   $w = $context->widget($name);
   # OR ...
   $w = $context->widget($name,
      class => "App::Widget::TextField",
      size  => 8,                 # from HTML spec
      maxlength => 18,            # from HTML spec
      tabindex => 1,              # from HTML spec
      style => "mystyle",         # from HTML to support CSS
      color => "#6666CC",         # from CSS spec
      font_size => "10px",        # from CSS spec
      border_style => "solid",    # from CSS spec
      border_width => "1px",      # from CSS spec
      border_color => "#6666CC",  # from CSS spec
      padding => "2px",           # from CSS spec
      background_color => "#ccffcc",           # from CSS spec
      font_family => "Verdana, Geneva, Arial", # from CSS spec
      override => 1,              # increase precedence of following options to "override" from "default"
      #validate => "date",         # not impl. yet ("date", "time", "datetime", "enum", "number", "integer", ":regexp")
      #autocomplete => \@previous_choices,  # not impl. yet
   );

   # internal way
   use App::Widget::TextField;
   $w = App::Widget::TextField->new($name);

=cut

######################################################################
# CONSTANTS
######################################################################

######################################################################
# ATTRIBUTES
######################################################################

# INPUTS FROM THE ENVIRONMENT

=head1 DESCRIPTION

This class is a <input type=text> HTML element.

=cut

######################################################################
# INITIALIZATION
######################################################################

# no special initialization

######################################################################
# EVENTS
######################################################################

# no events

######################################################################
# OUTPUT METHODS
######################################################################

sub unstyled_html {
    my $self = shift;
    my ($name, $value, $html_value, $html, $var, $size, $maxlength, $tabindex, $readonly, $html_attribs, $enable_warn, $enable_warning_widget);
    $name = $self->{name};
    $value = $self->fget_value();
    $html_value = $self->html_escape($value);
    $size = $self->get("size");
    $maxlength = $self->get("maxlength");
    $tabindex = $self->get("tabindex");
    $readonly = $self->get("readonly");
    $html_attribs = $self->html_attribs();
    $enable_warn = $self->get("enable_warning");
    $enable_warning_widget = $self->get("enable_warning_widget");
    $html = "<input type=\"text\" name=\"${name}\" value=\"$html_value\"";
    $html .= " size=\"$size\"" if ($size);
    $html .= " maxlength=\"$maxlength\"" if ($maxlength);
    $html .= " tabindex=\"$tabindex\"" if ($tabindex);
    $html .= " readonly=\"$readonly\"" if ($readonly);
    $html .= " $html_attribs" if ($html_attribs);
    if($enable_warn) {
        $html .= " onkeydown=\"javascript: var enable_warning = context.getElementByName('" . $enable_warning_widget . "'); ";
        $html .= " enable_warning.value = 'enabled';\" ";
    }
    $html .= "/>";
    $html;
}

1;

