# $Id: Constants.pm,v 1.4 2004/07/13 16:21:44 mj Exp $

package Games::IL2Device::Constants;
use strict;
use warnings;

use vars qw( %KEYS );

%KEYS = (
	 'ACCELERATE_TIME' => 435,
	 'ACCESSIBLE' => 4,		# (KEY)
	 'ACCESSIBLE_SET' => 6,	# (KEY)
	 'ADJUST_SIGHT_LEFT' => 201,
	 'ADJUST_SIGHT_RIGHT' => 199,
	 'AILERON' => 84,
	 'AILERON_SET' => 85,# (FLOAT)
	 'AILERON_TRIM' => 94,
	 'AILERON_TRIM_SET' => 95,		# (FLOAT)
	 'AIRBRAKE' => 172,
	 'AIRBRAKE_SET' => 173,
	 'ALTIMETER' => 40,
	 'ANGULAR_SPEED' => 38,
	 'ATTACH_DETACH_AIRCRAFT' => 179,
	 'AZIMUTH' => 42,
	 'BAIL_OUT' => 405,
	 'BEACON_AZIMUTH' => 44,
	 'BOOST' => 104,
	 'BOOST_SET' => 105,
	 'BRAKES' => 90,
	 'BRAKES_SET' => 91,	# (FLOAT)
	 'CHASE_VIEW' => 393,
	 'CHAT' => 419,
	 'COCKPITS' => 24,
	 'COCKPIT_CUR' => 26,
	 'COCKPIT_LIGHTS' => 409,
	 'COCKPIT_VIEW' => 355,
	 'COWL_FLAPS' => 171,
	 'DECELERATE_TIME' => 439,
	 'DECREASE_FOV' => 353,
	 'DECREASE_SIGHT_ALTITUDE' => 205,
	 'DECREASE_SIGHT_DISTANCE' => 197,
	 'DECREASE_SIGHT_VELOCITY' => 209,
	 'DEV_VERSION' => 2,
	 'ELEVATOR' => 86,
	 'ELEVATOR_SET' => 87,		# (FLOAT)
	 'ELEVATOR_TRIM' => 96,
	 'ELEVATOR_TRIM_SET' => 97,		# (FLOAT)
	 'ENGINES' => 28,
	 'EXTERNAL_PADLOCK_CLOSEST_ENEMY_AIR' => 385,
	 'EXTERNAL_PADLOCK_CLOSEST_ENEMY_GROUND' => 391,
	 'EXTERNAL_PADLOCK_ENEMY_AIR' => 381,
	 'EXTERNAL_PADLOCK_ENEMY_GROUND' => 387,
	 'EXTERNAL_PADLOCK_FRIENDLY_AIR' => 383,
	 'EXTERNAL_PADLOCK_FRIENDLY_GROUND' => 389,
	 'EXTERNAL_VIEW' => 359,
	 'FEATHER_PROP' => 162,
	 'FEATHER_PROP_SET' => 163,
	 'FIRE_EXTINGUISHER' => 161,
	 'FLAPS' => 82,
	 'FLAPS_SET' => 83,		# (FLOAT)
	 'FLY_BY_VIEW' => 365,
	 'FOV_30' => 347,
	 'FOV_35' => 345,
	 'FOV_40' => 343,
	 'FOV_45' => 341,
	 'FOV_50' => 339,
	 'FOV_55' => 337,
	 'FOV_60' => 335,
	 'FOV_65' => 333,
	 'FOV_70' => 331,
	 'FOV_75' => 329,
	 'FOV_80' => 327,
	 'FOV_85' => 325,
	 'FOV_90' => 323,
	 'FUEL' => 50,
	 'GEAR' => 164,
	 'GEAR_POS_C' => 60,
	 'GEAR_POS_L' => 56,
	 'GEAR_POS_R' => 58,
	 'GEAR_SET' => 165,
	 'GUNNER_FIRE' => 220,
	 'GUNNER_FIRE_SET' => 221,
	 'GUNNER_MOVE' => 223,		# (INT, INT, INT)
	 'INCREASE_FOV' => 351,
	 'INCREASE_SIGHT_ALTITUDE' => 203,
	 'INCREASE_SIGHT_DISTANCE' => 195,
	 'INCREASE_SIGHT_VELOCITY' => 207,
	 'INSTANT_VIEW_FORWARD' => 479,		# (INT 0/1)
	 'JETTISON_DROPTANKS' => 177,
	 'JUMP_TO_COCKPIT_1' => 303,
	 'JUMP_TO_COCKPIT_10' => 321,
	 'JUMP_TO_COCKPIT_2' => 305,
	 'JUMP_TO_COCKPIT_3' => 307,
	 'JUMP_TO_COCKPIT_4' => 309,
	 'JUMP_TO_COCKPIT_5' => 311,
	 'JUMP_TO_COCKPIT_6' => 313,
	 'JUMP_TO_COCKPIT_7' => 315,
	 'JUMP_TO_COCKPIT_8' => 317,
	 'JUMP_TO_COCKPIT_9' => 319,
	 'LEVEL_STABILIZER' => 100,
	 'LEVEL_STABILIZER_SET' => 101,		# (FLOAT)
	 'LOCK_TAIL_WHEEL' => 174,
	 'LOCK_TAIL_WHEEL_SET' => 175,
	 'LOWER_GEAR_MANUALLY' => 169,
	 'MAGNETO' => 62,		# (INT ENGINE ID)
	 'MAGNETO_NEXT' => 106,	# RETURN (INT 0-3)
	 'MAGNETO_NEXT_SET' => 107,
	 'MAGNETO_PREV' => 108,	# RETURN (INT 0-3)
	 'MAGNETO_PREV_SET' => 109,
	 'MANIFOLD' => 66,		# (INT ENGINE ID)
	 'NEXT_ENEMY_CHASE_VIEW' => 397,
	 'NEXT_ENEMY_VIEW' => 363,
	 'NEXT_FRIENDLY_CHASE_VIEW' => 395,
	 'NEXT_FRIENDLY_VIEW' => 361,
	 'NORMAL_TIME' => 437,
	 'NO_COCKPIT_VIEW' => 357,
	 'ONLINE_RATING' => 421,		# (INT 0/1)
	 'OVERLOAD' => 52,
	 'PADLOCK_ENEMY' => 367,
	 'PADLOCK_ENEMY_GROUND' => 371,
	 'PADLOCK_FRIENDLY' => 369,
	 'PADLOCK_FRIENDLY_GROUND' => 373,
	 'PADLOCK_NEXT' => 375,
	 'PADLOCK_PREV' => 377,
	 'PAUSE_GAME' => 441,
	 'PITCH' => 48,
	 'PLANE' => 22,
	 'POWER' => 80,
	 'POWER_SET' => 81,		# (FLOAT)
	 'PROP_PITCH' => 92,
	 'PROP_PITCH_SET' => 93,		# (FLOAT)
	 'QUICK_START_SAVE_TRACK' => 429,
	 'RADIO_CHANNEL_SWITCH' => 433,
	 'RADIO_MUTE_KEY' => 431,		# (INT 0/1)
	 'RAISE_GEAR_MANUALLY' => 167,
	 'ROLL' => 46,
	 'RPM' => 64,		# (INT ENGINE ID)
	 'RUDDER' => 88,
	 'RUDDER_SET' => 89,		# (FLOAT)
	 'RUDDER_TRIM' => 98,
	 'RUDDER_TRIM_SET' => 99,		# (FLOAT)
	 'SELECT_ALL_ENGINES' => 115,
	 'SELECT_ENGINE_1' => 123,
	 'SELECT_ENGINE_2' => 125,
	 'SELECT_ENGINE_3' => 127,
	 'SELECT_ENGINE_4' => 129,
	 'SELECT_ENGINE_5' => 131,
	 'SELECT_ENGINE_6' => 133,
	 'SELECT_ENGINE_7' => 135,
	 'SELECT_ENGINE_8' => 137,
	 'SELECT_LEFT_ENGINES' => 119,
	 'SELECT_RIGHT_ENGINES' => 121,
	 'SHAKE_LEVEL' => 54,
	 'SLIP' => 34,
	 'SPEEDOMETER_INDICATED' => 30,
	 'SUPERCHARGER_NEXT' => 110,
	 'SUPERCHARGER_NEXT_SET' => 111,
	 'SUPERCHARGER_PREV' => 112,
	 'SUPERCHARGER_PREV_SET' => 113,
	 'TEMP_CYLINDERS' => 74,		# (INT ENGINE ID)
	 'TEMP_OILIN' => 68,		# (INT ENGINE ID)
	 'TEMP_OILOUT' => 70,		# (INT ENGINE ID)
	 'TEMP_WATER' => 72,		# (INT ENGINE ID)
	 'TIME_OF_DAY' => 20,
	 'TINTED_RETICLE_DIMMER' => 407,
	 'TOGGLE_ALL_ENGINES' => 139,
	 'TOGGLE_AUTOPILOT' => 401,
	 'TOGGLE_ENGINE' => 103,
	 'TOGGLE_ENGINE_1' => 145,
	 'TOGGLE_ENGINE_2' => 147,
	 'TOGGLE_ENGINE_3' => 149,
	 'TOGGLE_ENGINE_4' => 151,
	 'TOGGLE_ENGINE_5' => 153,
	 'TOGGLE_ENGINE_6' => 155,
	 'TOGGLE_ENGINE_7' => 157,
	 'TOGGLE_ENGINE_8' => 159,
	 'TOGGLE_FOV' => 348,
	 'TOGGLE_FOV_SET' => 349,
	 'TOGGLE_GUNSIGHT' => 399,
	 'TOGGLE_GUN_PODS' => 190,
	 'TOGGLE_GUN_PODS_SET' => 191,
	 'TOGGLE_ICON_TYPES' => 425,
	 'TOGGLE_LANDING_LIGHTS' => 413,
	 'TOGGLE_LEFT_ENGINES' => 141,
	 'TOGGLE_LEVEL_AUTOPILOT' => 403,
	 'TOGGLE_MAP' => 417,
	 'TOGGLE_MIRRORS' => 427,
	 'TOGGLE_NAV_LIGHTS' => 411,
	 'TOGGLE_POS' => 300,
	 'TOGGLE_POS_SET' => 301,
	 'TOGGLE_RIGHT_ENGINES' => 143,
	 'TOGGLE_SIGHT_MODE' => 193,
	 'TOGGLE_SPEED_BAR' => 423,
	 'TOGGLE_WINTIP_SMOKE' => 415,
	 'TRACKIR' => 11,		# (FLOAT, FLOAT, FLOAT)
	 'TURN' => 36,
	 'UNSELECT_ALL_ENGINES' => 117,
	 'VARIOMETER' => 32,
	 'WEAPON_1' => 180,
	 'WEAPON_12' => 188,
	 'WEAPON_12_SET' => 189,
	 'WEAPON_1_SET' => 181,
	 'WEAPON_2' => 182,
	 'WEAPON_2_SET' => 183,
	 'WEAPON_3' => 184,
	 'WEAPON_3_SET' => 185,
	 'WEAPON_4' => 186,
	 'WEAPON_4_SET' => 187,
	);

use vars qw ( %TAGS );
my %RULES = ('^WEAPON' => 'weapons',
	     '^TOGGLE_' => 'toggles',
	     '_TRIM' => 'trims',
	     'VIEW' => 'views',
	     'COCKPIT_|COCKPITS' => 'cockpit',
	     '^ALTIMETER|^AZIMUTH|^FUEL|^MANIFOLD|^RPM|^SLIP|^TEMP_\w+|^VARIOMETER|^MAGNETO|^SPEEDOMETER_INDICATED|^BEACON_AZIMUTH' => 'instruments',
	     '^ANGULAR_SPEED|^PITCH|^ROLL|^TURN|^SLIP|^SHAKE_LEVEL|^PLANE|^OVERLOAD|^TIME_OF_DAY' => 'simulation',
	     '^AILERON.*|^AIRBRAKE.*|^BOOST.*|^BRAKES.*|^COWL_FLAPS|^ELEVATOR.*|^FEATHER_PROP.*|^FLAPS.*|^GEAR.*|^JETTISON_DROPTANKS|^LOCK_TAIL_WHEEL.*|.*_GEAR_MANUALLY|^MAGNETO.*|^POWER.*|^PROP_PITCH.*|^RUDDER.*|^SUPERCHARGER.*|^FIRE_EXTINGUISHER' => 'controls',
	     'ENGINE' => 'engines',
	     '.*' => 'all',
	    );


for my $re (keys %RULES) {
  @{ $TAGS{ $RULES{$re} } } = grep /$re/, keys %KEYS;
}

sub import {
  my $class = shift;
  my @a = @_;
  my @ext;

  no strict 'refs';
  my $pkg = caller;
  
  foreach my $arg ( @a ) {
    push @ext, 
      $arg =~ s/^:// ? @{ $TAGS{$arg} } : $arg;
  }

  foreach my $const ( @ext ) {
    warn __PACKAGE__, ": WARNING '$const' is not defined."
      unless exists $KEYS{$const};
    *{"${pkg}::$const"} = sub { $KEYS{$const} };
  }
}

1;
__END__

=head1 NAME
  
Games::IL2Device::Constants - Constants for devicelinks.

=head1 SYNOPSIS
  
  use Games::IL2Device::Constants qw( :controls PAUSE_GAME );

=head1 DESCRIPTION

I<Games::IL2Device::Constants> provides useful names of keys for
communicating with a IL2 Forgotten Battles client.

You can import a group of keys by defining one of these variables in
your I<use> statement.

=over 4

=item * weapons

=item * toggles

=item * views

=item * cockpit

=item * simulation

=item * controls

=item * engines

=item * all

=back

You can also import single constants by quoting their name in the
I<use> statement.

  use Games::IL2Device::Constants qw( TIME_OF_DAY );

These constants are defined.

EXTERNAL_PADLOCK_FRIENDLY_AIR, POWER_SET, FOV_50,
INSTANT_VIEW_FORWARD, FOV_55, TOGGLE_MIRRORS, JETTISON_DROPTANKS,
PADLOCK_FRIENDLY, TOGGLE_ENGINE_1, TOGGLE_ENGINE_2, TOGGLE_ENGINE_3,
PADLOCK_ENEMY, TOGGLE_ENGINE_4, TOGGLE_ENGINE_5, JUMP_TO_COCKPIT_10,
TOGGLE_ENGINE_6, TOGGLE_ENGINE_7, TOGGLE_ENGINE_8,
INCREASE_SIGHT_ALTITUDE, FLY_BY_VIEW, UNSELECT_ALL_ENGINES, CHAT,
ADJUST_SIGHT_RIGHT, COWL_FLAPS, FOV_60, JUMP_TO_COCKPIT_1,
JUMP_TO_COCKPIT_2, JUMP_TO_COCKPIT_3, TOGGLE_WINTIP_SMOKE,
JUMP_TO_COCKPIT_4, JUMP_TO_COCKPIT_5, FOV_65, JUMP_TO_COCKPIT_6,
SUPERCHARGER_NEXT_SET, JUMP_TO_COCKPIT_7, DECREASE_SIGHT_DISTANCE,
JUMP_TO_COCKPIT_8, SUPERCHARGER_PREV_SET, JUMP_TO_COCKPIT_9,
MAGNETO_NEXT_SET, MAGNETO_PREV_SET, FEATHER_PROP_SET, WEAPON_2_SET,
NORMAL_TIME, SELECT_RIGHT_ENGINES, NO_COCKPIT_VIEW, FOV_70,
NEXT_ENEMY_VIEW, FOV_75, SELECT_LEFT_ENGINES, COCKPIT_LIGHTS,
GUNNER_FIRE_SET, TRACKIR, GUNNER_MOVE, AILERON_SET,
TOGGLE_LEVEL_AUTOPILOT, ATTACH_DETACH_AIRCRAFT,
EXTERNAL_PADLOCK_ENEMY_AIR, EXTERNAL_PADLOCK_CLOSEST_ENEMY_AIR,
ACCELERATE_TIME, INCREASE_SIGHT_DISTANCE, RAISE_GEAR_MANUALLY,
PADLOCK_NEXT, FOV_80, BOOST_SET, PADLOCK_FRIENDLY_GROUND,
TOGGLE_ALL_ENGINES, DECREASE_SIGHT_VELOCITY, FOV_85, AIRBRAKE_SET,
TOGGLE_POS_SET, PROP_PITCH_SET, TINTED_RETICLE_DIMMER, PADLOCK_PREV,
TOGGLE_ICON_TYPES, NEXT_FRIENDLY_CHASE_VIEW, BAIL_OUT,
TOGGLE_SIGHT_MODE, TOGGLE_MAP, ONLINE_RATING, WEAPON_3_SET,
NEXT_FRIENDLY_VIEW, LEVEL_STABILIZER_SET, WEAPON_12_SET,
TOGGLE_RIGHT_ENGINES, FOV_90, RADIO_MUTE_KEY, LOCK_TAIL_WHEEL_SET,
INCREASE_FOV, EXTERNAL_VIEW, GEAR_SET, TOGGLE_AUTOPILOT,
TOGGLE_NAV_LIGHTS, INCREASE_SIGHT_VELOCITY, SELECT_ALL_ENGINES,
TOGGLE_ENGINE, ELEVATOR_TRIM_SET,
EXTERNAL_PADLOCK_CLOSEST_ENEMY_GROUND, SELECT_ENGINE_1,
SELECT_ENGINE_2, TOGGLE_SPEED_BAR, SELECT_ENGINE_3, SELECT_ENGINE_4,
SELECT_ENGINE_5, TOGGLE_GUNSIGHT, SELECT_ENGINE_6, SELECT_ENGINE_7,
EXTERNAL_PADLOCK_FRIENDLY_GROUND, SELECT_ENGINE_8,
TOGGLE_GUN_PODS_SET, PADLOCK_ENEMY_GROUND, TOGGLE_LEFT_ENGINES,
TOGGLE_FOV_SET, RUDDER_TRIM_SET, FOV_30, RADIO_CHANNEL_SWITCH, FOV_35,
WEAPON_4_SET, AILERON_TRIM_SET, QUICK_START_SAVE_TRACK,
DECELERATE_TIME, DECREASE_FOV, EXTERNAL_PADLOCK_ENEMY_GROUND,
DECREASE_SIGHT_ALTITUDE, ADJUST_SIGHT_LEFT, PAUSE_GAME, FLAPS_SET,
TOGGLE_LANDING_LIGHTS, LOWER_GEAR_MANUALLY, FOV_40, COCKPIT_VIEW,
FOV_45, NEXT_ENEMY_CHASE_VIEW, FIRE_EXTINGUISHER, RUDDER_SET,
ELEVATOR_SET, BRAKES_SET, CHASE_VIEW, WEAPON_1_SET, ROLL,
SPEEDOMETER_INDICATED, ACCESSIBLE_SET, AZIMUTH, WEAPON_12, GEAR,
MAGNETO_PREV, ELEVATOR, TOGGLE_POS, PLANE, GEAR_POS_C, TEMP_OILIN,
COCKPITS, AIRBRAKE, ENGINES, GEAR_POS_L, DEV_VERSION, AILERON_TRIM,
AILERON, OVERLOAD, TOGGLE_GUN_PODS, ELEVATOR_TRIM, SHAKE_LEVEL,
GEAR_POS_R, TIME_OF_DAY, MANIFOLD, RUDDER_TRIM, TEMP_CYLINDERS,
FEATHER_PROP, LOCK_TAIL_WHEEL, PITCH, BEACON_AZIMUTH, RPM, TURN,
GUNNER_FIRE, ALTIMETER, ACCESSIBLE, TEMP_WATER, COCKPIT_CUR, FLAPS,
SUPERCHARGER_NEXT, VARIOMETER, MAGNETO, TOGGLE_FOV, LEVEL_STABILIZER,
BRAKES, FUEL, WEAPON_1, WEAPON_2, BOOST, TEMP_OILOUT, POWER, WEAPON_3,
ANGULAR_SPEED, PROP_PITCH, WEAPON_4, SLIP, RUDDER, SUPERCHARGER_PREV
MAGNETO_NEXT

=head1 AUTHOR

Mathias Jansson <mj@pfy.nu>

=head1 COPYRIGHT

This software is free software, you may redistribute it and/or modify
it under the same license as perl itself. IL2 Forgotten battles is the
property of Ubisoft Entertainment and 1C:Maddox games.

Copyright (C) 2004 Mathias Jansson

=head1 SEE ALSO

L<Games::IL2Device::Link> L<perl(1)>.

=cut
