/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebConsole {
    private Formatter formatter_ = new DefaultFormatter();
    private Logger logger_ = new DefaultLogger();

    public void setFormatter(Formatter formatter) {
        this.formatter_ = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter_;
    }

    public void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    public Logger getLogger() {
        return this.logger_;
    }

    public void trace(Object ... args) {
        this.logger_.trace(this.process(args));
    }

    public void debug(Object ... args) {
        this.logger_.debug(this.process(args));
    }

    public void info(Object ... args) {
        this.logger_.info(this.process(args));
    }

    public void warn(Object ... args) {
        this.logger_.warn(this.process(args));
    }

    public void error(Object ... args) {
        this.logger_.error(this.process(args));
    }

    private String process(Object[] objs) {
        if (objs == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        LinkedList<Object> args = new LinkedList<Object>(Arrays.asList(objs));
        Formatter formatter = this.getFormatter();
        if (args.size() > 1 && args.get(0) instanceof String) {
            Pattern p = Pattern.compile("%(\\d*).?(\\d*)[a-zA-Z]");
            Matcher matcher = p.matcher((String)args.remove(0));
            while (matcher.find()) {
                String group = matcher.group();
                char ch = group.charAt(group.length() - 1);
                String replacement = null;
                switch (ch) {
                    case 'o': 
                    case 's': {
                        replacement = formatter.parameterAsString(WebConsole.pop(args));
                        break;
                    }
                    case 'd': 
                    case 'i': {
                        replacement = formatter.parameterAsInteger(WebConsole.pop(args));
                        break;
                    }
                    case 'f': {
                        replacement = formatter.parameterAsFloat(WebConsole.pop(args));
                        break;
                    }
                    default: {
                        replacement = group;
                    }
                }
                matcher.appendReplacement(sb, replacement);
            }
            matcher.appendTail(sb);
        }
        for (Object e : args) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(formatter.printObject(e));
        }
        return sb.toString();
    }

    private static Object pop(List<Object> list) {
        return list.isEmpty() ? null : list.remove(0);
    }

    private static class DefaultLogger
    implements Logger {
        private static final Log LOG = LogFactory.getLog(WebConsole.class);

        private DefaultLogger() {
        }

        @Override
        public void trace(Object message) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(message);
            }
        }

        @Override
        public void debug(Object message) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(message);
            }
        }

        @Override
        public void info(Object message) {
            if (LOG.isInfoEnabled()) {
                LOG.info(message);
            }
        }

        @Override
        public void warn(Object message) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(message);
            }
        }

        @Override
        public void error(Object message) {
            if (LOG.isErrorEnabled()) {
                LOG.error(message);
            }
        }
    }

    private static class DefaultFormatter
    implements Formatter {
        private DefaultFormatter() {
        }

        @Override
        public String printObject(Object o) {
            return this.parameterAsString(o);
        }

        @Override
        public String parameterAsString(Object o) {
            if (o != null) {
                return o.toString();
            }
            return "null";
        }

        @Override
        public String parameterAsInteger(Object o) {
            if (o instanceof Number) {
                return Integer.toString(((Number)o).intValue());
            }
            if (o instanceof String) {
                try {
                    return Integer.toString(Integer.parseInt((String)o));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return "NaN";
        }

        @Override
        public String parameterAsFloat(Object o) {
            if (o instanceof Number) {
                return Float.toString(((Number)o).floatValue());
            }
            if (o instanceof String) {
                try {
                    return Float.toString(Float.parseFloat((String)o));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return "NaN";
        }
    }

    public static interface Formatter {
        public String printObject(Object var1);

        public String parameterAsString(Object var1);

        public String parameterAsInteger(Object var1);

        public String parameterAsFloat(Object var1);
    }

    public static interface Logger {
        public void trace(Object var1);

        public void debug(Object var1);

        public void info(Object var1);

        public void warn(Object var1);

        public void error(Object var1);
    }
}

