=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Tg - Package for language Tajik

=cut

package Locale::CLDR::Locales::Tg;
# This file auto generated from Data\common\main\tg.xml
#	on Fri 17 Jan 12:03:31 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'af' => 'африкаанс',
 				'am' => 'амҳарӣ',
 				'ar' => 'арабӣ',
 				'ar_001' => 'Стандарти муосири арабӣ',
 				'as' => 'ассомӣ',
 				'az' => 'озарбойҷонӣ',
 				'ba' => 'бошқирдӣ',
 				'ban' => 'балинӣ',
 				'be' => 'белорусӣ',
 				'bem' => 'бемба',
 				'bg' => 'булғорӣ',
 				'bn' => 'бинғолӣ',
 				'bo' => 'тибетӣ',
 				'br' => 'бретонӣ',
 				'bs' => 'босниягӣ',
 				'ca' => 'каталонӣ',
 				'ceb' => 'себуано',
 				'cgg' => 'Чига',
 				'chm' => 'марӣ',
 				'chr' => 'черокӣ',
 				'ckb' => 'курдии марказӣ',
 				'co' => 'корсиканӣ',
 				'cs' => 'чехӣ',
 				'cy' => 'валлӣ',
 				'da' => 'даниягӣ',
 				'de' => 'немисӣ',
 				'de_AT' => 'немисии австриягӣ',
 				'de_CH' => 'немисии швейсарии болоӣ',
 				'dsb' => 'сербии поёнӣ',
 				'dv' => 'дивеҳӣ',
 				'dz' => 'дзонгха',
 				'el' => 'юнонӣ',
 				'en' => 'англисӣ',
 				'en_AU' => 'англисии австралиягӣ',
 				'en_CA' => 'англисии канадагӣ',
 				'en_GB' => 'англисии британӣ',
 				'en_GB@alt=short' => 'англисӣ (ШМ)',
 				'en_US' => 'англисии америкоӣ',
 				'en_US@alt=short' => 'англисӣ (ИМ)',
 				'eo' => 'эсперанто',
 				'es' => 'испанӣ',
 				'es_419' => 'испании америкоии лотинӣ',
 				'es_ES' => 'испании аврупоӣ',
 				'es_MX' => 'испании мексикоӣ',
 				'et' => 'эстонӣ',
 				'eu' => 'баскӣ',
 				'fa' => 'форсӣ',
 				'ff' => 'фулаҳ',
 				'fi' => 'финӣ',
 				'fil' => 'филиппинӣ',
 				'fo' => 'фарерӣ',
 				'fr' => 'франсузӣ',
 				'fr_CA' => 'франсузии канадагӣ',
 				'fr_CH' => 'франсузии швейсарӣ',
 				'fy' => 'фризии ғарбӣ',
 				'ga' => 'ирландӣ',
 				'gd' => 'шотландии гэлӣ',
 				'gl' => 'галисиягӣ',
 				'gn' => 'гуаранӣ',
 				'gu' => 'гуҷаротӣ',
 				'ha' => 'ҳауса',
 				'haw' => 'ҳавайӣ',
 				'he' => 'ибронӣ',
 				'hi' => 'ҳиндӣ',
 				'hil' => 'ҳилигайнон',
 				'hr' => 'хорватӣ',
 				'hsb' => 'сербии болоӣ',
 				'ht' => 'гаитии креолӣ',
 				'hu' => 'маҷорӣ',
 				'hy' => 'арманӣ',
 				'hz' => 'ҳереро',
 				'ia' => 'Байни забонӣ',
 				'ibb' => 'ибибио',
 				'id' => 'индонезӣ',
 				'ig' => 'игбо',
 				'is' => 'исландӣ',
 				'it' => 'италиявӣ',
 				'iu' => 'инуктитутӣ',
 				'ja' => 'японӣ',
 				'jv' => 'Ҷаванизӣ',
 				'ka' => 'гурҷӣ',
 				'kk' => 'қазоқӣ',
 				'km' => 'кхмерӣ',
 				'kn' => 'каннада',
 				'ko' => 'кореягӣ',
 				'kok' => 'конканӣ',
 				'kr' => 'канурӣ',
 				'kru' => 'курукс',
 				'ks' => 'кашмирӣ',
 				'ku' => 'курдӣ',
 				'ky' => 'қирғизӣ',
 				'la' => 'лотинӣ',
 				'lb' => 'люксембургӣ',
 				'lo' => 'лаосӣ',
 				'lt' => 'литвонӣ',
 				'lv' => 'латишӣ',
 				'men' => 'менде',
 				'mg' => 'малагасӣ',
 				'mi' => 'маорӣ',
 				'mk' => 'мақдунӣ',
 				'ml' => 'малаяламӣ',
 				'mn' => 'муғулӣ',
 				'mni' => 'манипурӣ',
 				'moh' => 'моҳок',
 				'mr' => 'маратҳӣ',
 				'ms' => 'малайӣ',
 				'mt' => 'малтӣ',
 				'my' => 'бирманӣ',
 				'ne' => 'непалӣ',
 				'niu' => 'ниуэӣ',
 				'nl' => 'голландӣ',
 				'nl_BE' => 'Фламандӣ',
 				'no' => 'норвегӣ',
 				'ny' => 'нянҷа',
 				'oc' => 'окситанӣ',
 				'om' => 'оромо',
 				'or' => 'одия',
 				'pa' => 'панҷобӣ',
 				'pap' => 'папиаменто',
 				'pl' => 'лаҳистонӣ',
 				'ps' => 'пушту',
 				'pt' => 'португалӣ',
 				'pt_BR' => 'португалии бразилиягӣ',
 				'pt_PT' => 'португалии аврупоӣ',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'rm' => 'ретороманӣ',
 				'ro' => 'руминӣ',
 				'ru' => 'русӣ',
 				'rw' => 'киняруанда',
 				'sa' => 'санскрит',
 				'sah' => 'саха',
 				'sat' => 'санталӣ',
 				'sd' => 'синдӣ',
 				'se' => 'самии шимолӣ',
 				'si' => 'сингалӣ',
 				'sk' => 'словакӣ',
 				'sl' => 'словенӣ',
 				'sma' => 'самии ҷанубӣ',
 				'smj' => 'луле самӣ',
 				'smn' => 'инари самӣ',
 				'sms' => 'сколти самӣ',
 				'so' => 'сомалӣ',
 				'sq' => 'албанӣ',
 				'sr' => 'сербӣ',
 				'sv' => 'шведӣ',
 				'syr' => 'суриёнӣ',
 				'ta' => 'тамилӣ',
 				'te' => 'телугу',
 				'tg' => 'тоҷикӣ',
 				'th' => 'тайӣ',
 				'ti' => 'тигриня',
 				'tk' => 'туркманӣ',
 				'to' => 'тонганӣ',
 				'tr' => 'туркӣ',
 				'tt' => 'тоторӣ',
 				'tzm' => 'тамазайти Атласи Марказӣ',
 				'ug' => 'ӯйғурӣ',
 				'uk' => 'украинӣ',
 				'und' => 'забони номаълум',
 				'ur' => 'урду',
 				'uz' => 'ӯзбекӣ',
 				've' => 'венда',
 				'vi' => 'ветнамӣ',
 				'wo' => 'волоф',
 				'yi' => 'идиш',
 				'yo' => 'йоруба',
 				'zh' => 'хитоӣ',
 				'zh@alt=menu' => 'хитоӣ, мандаринӣ',
 				'zh_Hans' => 'хитоии осонфаҳм',
 				'zh_Hans@alt=long' => 'хитоии мандаринии осонфаҳм',
 				'zh_Hant' => 'хитоии анъанавӣ',
 				'zh_Hant@alt=long' => 'хитоии мандаринии анъанавӣ',
 				'zu' => 'Зулу',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'Адламӣ',
 			'Aghb' => 'Албани Қафқозӣ',
 			'Ahom' => 'Ахомӣ',
 			'Arab' => 'Арабӣ',
 			'Aran' => 'Насталиқӣ',
 			'Armi' => 'Арамейкии Империалӣ',
 			'Armn' => 'Арманӣ',
 			'Avst' => 'Авестоӣ',
 			'Bali' => 'Балинесӣ',
 			'Bamu' => 'Бамумӣ',
 			'Bass' => 'Басса Вахӣ',
 			'Batk' => 'Батакӣ',
 			'Beng' => 'Бангладешӣ',
 			'Bhks' => 'Бхайксукӣ',
 			'Bopo' => 'Бопомофоӣ',
 			'Brah' => 'Брахмӣ',
 			'Brai' => 'Брайл',
 			'Bugi' => 'Бугинӣ',
 			'Buhd' => 'Бухидӣ',
 			'Cakm' => 'Чакама',
 			'Cans' => 'Низоми ягонаи ҳиҷои аборигении каннадӣ',
 			'Cari' => 'Карианӣ',
 			'Cham' => 'Чамӣ',
 			'Cher' => 'Черокӣ',
 			'Chrs' => 'Хоразмиёнӣ',
 			'Copt' => 'Коптӣ',
 			'Cpmn' => 'Кипро-Миноанӣ',
 			'Cprt' => 'Кипрӣ',
 			'Cyrl' => 'Кириллӣ',
 			'Deva' => 'Деванагарӣ',
 			'Diak' => 'Дивс Акуру',
 			'Dogr' => 'Догра',
 			'Dsrt' => 'Дезерет',
 			'Dupl' => 'Стенографияи Дуплоянӣ',
 			'Egyp' => 'Иероглифҳои Мисрӣ',
 			'Elba' => 'Элбасан',
 			'Elym' => 'Элимайӣ',
 			'Ethi' => 'Эфиопӣ',
 			'Geor' => 'Гурҷӣ',
 			'Glag' => 'Глаголитикӣ',
 			'Gong' => 'Гунҷала Гондӣ',
 			'Gonm' => 'Масарам Гондӣ',
 			'Goth' => 'Готика',
 			'Gran' => 'Гранта',
 			'Grek' => 'Юнонӣ',
 			'Gujr' => 'Гуҷаротӣ',
 			'Guru' => 'Гумрухӣ',
 			'Hanb' => 'Хан бо Бопомофо',
 			'Hang' => 'Ҳангул',
 			'Hani' => 'Хан',
 			'Hano' => 'Хануну',
 			'Hans' => 'Осонфаҳм',
 			'Hans@alt=stand-alone' => 'Хани осонфаҳм',
 			'Hant' => 'Анъанавӣ',
 			'Hant@alt=stand-alone' => 'Хани анъанавӣ',
 			'Hatr' => 'Хатран',
 			'Hebr' => 'Яҳудӣ',
 			'Hira' => 'Хирагана',
 			'Hluw' => 'Иероглифҳои Анатолӣ',
 			'Hmng' => 'Пахах Хмонг',
 			'Hmnp' => 'Някенг Пуачэ Хмонг',
 			'Hrkt' => 'Ҳиҷоҳои ҷопонӣ',
 			'Hung' => 'Венгерии Куҳна',
 			'Ital' => 'Курсиви Куҳна',
 			'Jamo' => 'Ҷамо',
 			'Java' => 'Ҷаванесӣ',
 			'Jpan' => 'Ҷопонӣ',
 			'Kali' => 'Кайя Ли',
 			'Kana' => 'Катакана',
 			'Kawi' => 'Кавӣ',
 			'Khar' => 'Хароштӣ',
 			'Khmr' => 'Хмерӣ',
 			'Khoj' => 'Хочки',
 			'Kits' => 'Хатти хурди Китонӣ',
 			'Knda' => 'Каннада',
 			'Kore' => 'Кореягӣ',
 			'Kthi' => 'Кайтӣ',
 			'Lana' => 'Ланна',
 			'Laoo' => 'Лао',
 			'Latn' => 'Лотинӣ',
 			'Lepc' => 'Лепча',
 			'Limb' => 'Лимбу',
 			'Lina' => 'Хати А',
 			'Linb' => 'Хати Б',
 			'Lisu' => 'Фрейзер',
 			'Lyci' => 'Ликия',
 			'Lydi' => 'Лидия',
 			'Mahj' => 'Махаҷанӣ',
 			'Maka' => 'Макасарӣ',
 			'Mand' => 'Мандаеан',
 			'Mani' => 'Манихейӣ',
 			'Marc' => 'Маршенӣ',
 			'Medf' => 'Медефаидринӣ',
 			'Mend' => 'Менде',
 			'Merc' => 'Курсиви Мероитӣ',
 			'Mero' => 'Мероитӣ',
 			'Mlym' => 'Малаяламӣ',
 			'Modi' => 'Модӣ',
 			'Mong' => 'Муғулӣ',
 			'Mroo' => 'Мро',
 			'Mtei' => 'Мейтеи Майек',
 			'Mult' => 'Мултанӣ',
 			'Mymr' => 'Мянмар',
 			'Nagm' => 'Наг Мундарӣ',
 			'Nand' => 'Нандинагарӣ',
 			'Narb' => 'Арабии Шимолии Куҳна',
 			'Nbat' => 'Набатаинӣ',
 			'Newa' => 'Нева',
 			'Nkoo' => 'Н’Ко',
 			'Nshu' => 'Нушу',
 			'Ogam' => 'Огам',
 			'Olck' => 'Ол Чикӣ',
 			'Orkh' => 'Оркон',
 			'Orya' => 'Одия',
 			'Osge' => 'Осейҷӣ',
 			'Osma' => 'Османияӣ',
 			'Ougr' => 'Уйғури Куҳна',
 			'Palm' => 'Палмирена',
 			'Pauc' => 'Пау Син Хау',
 			'Perm' => 'Пермикии Куҳна',
 			'Phag' => 'Фагс-па',
 			'Phli' => 'Паҳлавии Хаттӣ',
 			'Phlp' => 'Паҳлавии Псалтирӣ',
 			'Phnx' => 'Финикӣ',
 			'Plrd' => 'Овоии поллардӣ',
 			'Prti' => 'Парфияи Хаттӣ',
 			'Qaag' => 'Завгӯйӣ',
 			'Rjng' => 'Реҷанг',
 			'Rohg' => 'Ханифӣ',
 			'Runr' => 'Руникӣ',
 			'Samr' => 'Самаританӣ',
 			'Sarb' => 'Арабии Ҷанубии Куҳна',
 			'Saur' => 'Саураштра',
 			'Sgnw' => 'Аломатнависӣ',
 			'Shaw' => 'Шавианӣ',
 			'Shrd' => 'Шарада',
 			'Sidd' => 'Сиддам',
 			'Sind' => 'Худовадӣ',
 			'Sinh' => 'Синхала',
 			'Sogd' => 'Суғдӣ',
 			'Sogo' => 'Суғдии Куҳна',
 			'Sora' => 'Сора Сомпенг',
 			'Soyo' => 'Соёмбо',
 			'Sund' => 'Сунданезӣ',
 			'Sylo' => 'Силоти Нагрӣ',
 			'Syrc' => 'Сурёнӣ',
 			'Tagb' => 'Тагбанва',
 			'Takr' => 'Такрӣ',
 			'Tale' => 'Тай Ле',
 			'Talu' => 'Тай Леи Нав',
 			'Taml' => 'Тамилӣ',
 			'Tang' => 'Тангут',
 			'Tavt' => 'Ветнамии Тайӣ',
 			'Telu' => 'Телугу',
 			'Tfng' => 'Тифинаг',
 			'Tglg' => 'Тагалогӣ',
 			'Thaa' => 'Таана',
 			'Thai' => 'Тайӣ',
 			'Tibt' => 'Тибетӣ',
 			'Tirh' => 'Тирхута',
 			'Tnsa' => 'Тангса',
 			'Toto' => 'Тото',
 			'Ugar' => 'Угаритӣ',
 			'Vaii' => 'Вайӣ',
 			'Vith' => 'Виткукӣ',
 			'Wara' => 'Варанг Кшитӣ',
 			'Wcho' => 'Ванчо',
 			'Xpeo' => 'Форсии Куҳна',
 			'Xsux' => 'Хати Сумеро-Аккадӣ',
 			'Yezi' => 'Язидӣ',
 			'Yiii' => 'Юйӣ',
 			'Zanb' => 'Майдони Занабазорӣ',
 			'Zinh' => 'Мерос',
 			'Zmth' => 'Аломати риёзӣ',
 			'Zsye' => 'Эмоҷи',
 			'Zsym' => 'Аломатҳо',
 			'Zxxx' => 'Нонавишта',
 			'Zyyy' => 'Умумӣ',
 			'Zzzz' => 'Скрипти номаълум',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'ҷаҳонӣ',
 			'002' => 'Африқо',
 			'003' => 'Америкаи Шимолӣ',
 			'005' => 'Америкаи Ҷанубӣ',
 			'009' => 'Уқёнус',
 			'011' => 'Африқои Ғарбӣ',
 			'013' => 'Америкаи Марказӣ',
 			'014' => 'Африқои Шимолӣ',
 			'015' => 'Африқои Шарқӣ',
 			'017' => 'Африқои Миёна',
 			'018' => 'Африқои Ҷанубӣ',
 			'019' => 'Америка',
 			'021' => 'Амрикои Шимолӣ',
 			'029' => 'Кариб',
 			'030' => 'Осиёи Шарқӣ',
 			'034' => 'Осиёи Ҷанубӣ',
 			'035' => 'Осиёи Ҷанубу Шарқӣ',
 			'039' => 'Аврупои Ҷанубӣ',
 			'053' => 'Австралияву Осиё',
 			'054' => 'Меланезия',
 			'057' => 'Минтақаи Микронезия',
 			'061' => 'Полинезия',
 			'142' => 'Осиё',
 			'143' => 'Осиёи Марказӣ',
 			'145' => 'Осиёи Ғарбӣ',
 			'150' => 'Аврупо',
 			'151' => 'Аврупои Шарқӣ',
 			'154' => 'Аврупои Шимолӣ',
 			'155' => 'Аврупои Ғарбӣ',
 			'202' => 'Африқои Суб-Сахара',
 			'419' => 'Америкаи Лотинӣ',
 			'AC' => 'Асунсон',
 			'AD' => 'Андорра',
 			'AE' => 'Аморатҳои Муттаҳидаи Араб',
 			'AF' => 'Афғонистон',
 			'AG' => 'Антигуа ва Барбуда',
 			'AI' => 'Ангилия',
 			'AL' => 'Албания',
 			'AM' => 'Арманистон',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктида',
 			'AR' => 'Аргентина',
 			'AS' => 'Самоаи Америка',
 			'AT' => 'Австрия',
 			'AU' => 'Австралия',
 			'AW' => 'Аруба',
 			'AX' => 'Ҷазираҳои Аланд',
 			'AZ' => 'Озарбойҷон',
 			'BA' => 'Босния ва Ҳерсеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгия',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Булғория',
 			'BH' => 'Баҳрайн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сент-Бартелми',
 			'BM' => 'Бермуда',
 			'BN' => 'Бруней',
 			'BO' => 'Боливия',
 			'BQ' => 'Кариби Нидерланд',
 			'BR' => 'Бразилия',
 			'BS' => 'Багам',
 			'BT' => 'Бутон',
 			'BV' => 'Ҷазираи Буве',
 			'BW' => 'Ботсвана',
 			'BY' => 'Белорус',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Ҷазираҳои Кокос (Килинг)',
 			'CD' => 'Конго - Киншаса',
 			'CF' => 'Ҷумҳурии Африқои Марказӣ',
 			'CG' => 'Конго - Браззавил',
 			'CG@alt=variant' => 'Конго (Ҷумҳурии)',
 			'CH' => 'Швейтсария',
 			'CI' => 'Кот-д’Ивуар',
 			'CK' => 'Ҷазираҳои Кук',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Хитой',
 			'CO' => 'Колумбия',
 			'CP' => 'Ҷазираи Клиппертон',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Ҷазираи Крисмас',
 			'CY' => 'Кипр',
 			'CZ' => 'Ҷумҳурии Чех',
 			'DE' => 'Германия',
 			'DG' => 'Диего-Гарсия',
 			'DJ' => 'Ҷибути',
 			'DK' => 'Дания',
 			'DM' => 'Доминика',
 			'DO' => 'Ҷумҳурии Доминикан',
 			'DZ' => 'Алҷазоир',
 			'EA' => 'Сеута ва Мелилла',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстония',
 			'EG' => 'Миср',
 			'EH' => 'Сахараи Ғарбӣ',
 			'ER' => 'Эритрея',
 			'ES' => 'Испания',
 			'ET' => 'Эфиопия',
 			'EU' => 'Иттиҳоди Аврупо',
 			'EZ' => 'Минтақаи Аврупо',
 			'FI' => 'Финляндия',
 			'FJ' => 'Фиҷи',
 			'FK' => 'Ҷазираҳои Фолкленд',
 			'FM' => 'Штатҳои Федеративии Микронезия',
 			'FO' => 'Ҷазираҳои Фарер',
 			'FR' => 'Фаронса',
 			'GA' => 'Габон',
 			'GB' => 'Шоҳигарии Муттаҳида',
 			'GD' => 'Гренада',
 			'GE' => 'Гурҷистон',
 			'GF' => 'Гвианаи Фаронса',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландия',
 			'GM' => 'Гамбия',
 			'GN' => 'Гвинея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Гвинеяи Экваторӣ',
 			'GR' => 'Юнон',
 			'GS' => 'Ҷорҷияи Ҷанубӣ ва Ҷазираҳои Сандвич',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинея-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'Ҳонконг (МММ)',
 			'HK@alt=short' => 'Ҳонконг',
 			'HM' => 'Ҷазираи Ҳерд ва Ҷазираҳои Макдоналд',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватия',
 			'HT' => 'Гаити',
 			'HU' => 'Маҷористон',
 			'IC' => 'Ҷазираҳои Канария',
 			'ID' => 'Индонезия',
 			'IE' => 'Ирландия',
 			'IL' => 'Исроил',
 			'IM' => 'Ҷазираи Мэн',
 			'IN' => 'Ҳиндустон',
 			'IO' => 'Қаламрави Британия дар уқёнуси Ҳинд',
 			'IO@alt=chagos' => 'Галаҷазираи Чагос',
 			'IQ' => 'Ироқ',
 			'IR' => 'Эрон',
 			'IS' => 'Исландия',
 			'IT' => 'Италия',
 			'JE' => 'Ҷерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Урдун',
 			'JP' => 'Япония',
 			'KE' => 'Кения',
 			'KG' => 'Қирғизистон',
 			'KH' => 'Камбоҷа',
 			'KI' => 'Кирибати',
 			'KM' => 'Комор',
 			'KN' => 'Сент-Китс ва Невис',
 			'KP' => 'Кореяи Шимолӣ',
 			'KR' => 'Кореяи Ҷанубӣ',
 			'KW' => 'Қувайт',
 			'KY' => 'Ҷазираҳои Кайман',
 			'KZ' => 'Қазоқистон',
 			'LA' => 'Лаос',
 			'LB' => 'Лубнон',
 			'LC' => 'Сент-Люсия',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либерия',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвия',
 			'LY' => 'Либия',
 			'MA' => 'Марокаш',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черногория',
 			'MF' => 'Ҷазираи Сент-Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Ҷазираҳои Маршалл',
 			'MK' => 'Македонияи Шимолӣ',
 			'ML' => 'Мали',
 			'MM' => 'Мянма',
 			'MN' => 'Муғулистон',
 			'MO' => 'Макао (МММ)',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Ҷазираҳои Марианаи Шимолӣ',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритания',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Малта',
 			'MU' => 'Маврикий',
 			'MV' => 'Малдив',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзия',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибия',
 			'NC' => 'Каледонияи Нав',
 			'NE' => 'Нигер',
 			'NF' => 'Ҷазираи Норфолк',
 			'NG' => 'Нигерия',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерландия',
 			'NO' => 'Норвегия',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Зеландияи Нав',
 			'NZ@alt=variant' => 'Аотеароа Зеландияи Нав',
 			'OM' => 'Умон',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Полинезияи Фаронса',
 			'PG' => 'Папуа Гвинеяи Нав',
 			'PH' => 'Филиппин',
 			'PK' => 'Покистон',
 			'PL' => 'Лаҳистон',
 			'PM' => 'Сент-Пер ва Микелон',
 			'PN' => 'Ҷазираҳои Питкейрн',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Қаламравҳои Фаластинӣ',
 			'PS@alt=short' => 'Фаластин',
 			'PT' => 'Португалия',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Қатар',
 			'QO' => 'Уқёнуси Дур',
 			'RE' => 'Реюнион',
 			'RO' => 'Руминия',
 			'RS' => 'Сербия',
 			'RU' => 'Русия',
 			'RW' => 'Руанда',
 			'SA' => 'Арабистони Саудӣ',
 			'SB' => 'Ҷазираҳои Соломон',
 			'SC' => 'Сейшел',
 			'SD' => 'Судон',
 			'SE' => 'Шветсия',
 			'SG' => 'Сингапур',
 			'SH' => 'Сент Елена',
 			'SI' => 'Словения',
 			'SJ' => 'Шпитсберген ва Ян Майен',
 			'SK' => 'Словакия',
 			'SL' => 'Сиерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалӣ',
 			'SR' => 'Суринам',
 			'SS' => 'Судони Ҷанубӣ',
 			'ST' => 'Сан Томе ва Принсипи',
 			'SV' => 'Эл-Салвадор',
 			'SX' => 'Синт-Маартен',
 			'SY' => 'Сурия',
 			'SZ' => 'Эсватини',
 			'TA' => 'Тристан-да-Куня',
 			'TC' => 'Ҷазираҳои Теркс ва Кайкос',
 			'TD' => 'Чад',
 			'TF' => 'Минтақаҳои Ҷанубии Фаронса',
 			'TG' => 'Того',
 			'TH' => 'Таиланд',
 			'TJ' => 'Тоҷикистон',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Тимори Шарқӣ',
 			'TM' => 'Туркманистон',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Туркия',
 			'TT' => 'Тринидад ва Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайван',
 			'TZ' => 'Танзания',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'Ҷазираҳои Хурди Дурдасти ИМА',
 			'UN' => 'Созмони Милали Муттаҳид',
 			'US' => 'Иёлоти Муттаҳида',
 			'US@alt=short' => 'ИМ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Ӯзбекистон',
 			'VA' => 'Шаҳри Вотикон',
 			'VC' => 'Сент-Винсент ва Гренадина',
 			'VE' => 'Венесуэла',
 			'VG' => 'Ҷазираҳои Виргини Британия',
 			'VI' => 'Ҷазираҳои Виргини ИМА',
 			'VN' => 'Ветнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис ва Футуна',
 			'WS' => 'Самоа',
 			'XA' => 'Псевдо-аксентҳо',
 			'XB' => 'Псевдо-бидӣ',
 			'XK' => 'Косово',
 			'YE' => 'Яман',
 			'YT' => 'Майотта',
 			'ZA' => 'Африкаи Ҷанубӣ',
 			'ZM' => 'Замбия',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Минтақаи номаълум',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'gregorian' => q{Тақвими грегорианӣ},
 				'islamic-civil' => q{Тақвими ҳиҷрӣ (ҷадвал, давраи шаҳрвандӣ)},
 				'islamic-tbla' => q{Тақвими ҳиҷрӣ (ҷадвал, давраи ситорашиносӣ)},
 				'iso8601' => q{Тақвими ISO-8601},
 			},
 			'collation' => {
 				'standard' => q{Тартиби мураттабсозии стандартӣ},
 			},
 			'numbers' => {
 				'arab' => q{Рақамҳои ҳинду-арабӣ},
 				'latn' => q{Рақамҳои ғарбӣ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{Метрӣ},
 			'UK' => q{БК},
 			'US' => q{ИМА},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Забон: {0}',
 			'script' => 'Алифбо: {0}',
 			'region' => 'Минтақа: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ц щ ы ь]},
			index => ['А', 'Б', 'В', 'Г', 'Ғ', 'Д', 'ЕЁ', 'Ж', 'З', 'ИӢ', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'УӮ', 'Ф', 'Х', 'Ҳ', 'Ч', 'Ҷ', 'Ш', 'Ъ', 'Э', 'Ю', 'Я'],
			main => qr{[а б в г ғ д её ж з иӣ й к қ л м н о п р с т уӯ ф х ҳ ч ҷ ш ъ э ю я]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” » ( ) \[ \] § @ * / \& # † ‡ ′ {″«}]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Ғ', 'Д', 'ЕЁ', 'Ж', 'З', 'ИӢ', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'УӮ', 'Ф', 'Х', 'Ҳ', 'Ч', 'Ҷ', 'Ш', 'Ъ', 'Э', 'Ю', 'Я'], };
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(самти кардиналӣ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(самти кардиналӣ),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} Шм),
						'north' => q({0} Шр),
						'south' => q({0} ҷануб),
						'west' => q({0} ғарб),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} Шм),
						'north' => q({0} Шр),
						'south' => q({0} ҷануб),
						'west' => q({0} ғарб),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} барои {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} барои {1}),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(самт),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(самт),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} Шм),
						'north' => q({0} Шр),
						'south' => q({0}Ҷ),
						'west' => q({0}Ғ),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} Шм),
						'north' => q({0} Шр),
						'south' => q({0}Ҷ),
						'west' => q({0}Ғ),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(самт),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(самт),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} Шм),
						'north' => q({0} Шр),
						'south' => q({0} Ҷ),
						'west' => q({0} Ғ),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} Шм),
						'north' => q({0} Шр),
						'south' => q({0} Ҷ),
						'west' => q({0} Ғ),
					},
				},
			} }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				2 => q({0} ва {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'group' => q( ),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'other' => '0 ҳазор',
				},
				'10000' => {
					'other' => '00 ҳазор',
				},
				'100000' => {
					'other' => '000 ҳазор',
				},
				'1000000' => {
					'other' => '0 миллион',
				},
				'10000000' => {
					'other' => '00 миллион',
				},
				'100000000' => {
					'other' => '000 миллион',
				},
				'1000000000' => {
					'other' => '0 миллиард',
				},
				'10000000000' => {
					'other' => '00 миллиард',
				},
				'100000000000' => {
					'other' => '000 миллиард',
				},
				'1000000000000' => {
					'other' => '0 триллион',
				},
				'10000000000000' => {
					'other' => '00 триллион',
				},
				'100000000000000' => {
					'other' => '000 триллион',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0 ҳзр'.'',
				},
				'10000' => {
					'other' => '00 ҳзр'.'',
				},
				'100000' => {
					'other' => '000 ҳзр'.'',
				},
				'1000000' => {
					'other' => '0 млн'.'',
				},
				'10000000' => {
					'other' => '00 млн'.'',
				},
				'100000000' => {
					'other' => '000 млн'.'',
				},
				'1000000000' => {
					'other' => '0 млрд'.'',
				},
				'10000000000' => {
					'other' => '00 млрд'.'',
				},
				'100000000000' => {
					'other' => '000 млрд'.'',
				},
				'1000000000000' => {
					'other' => '0 трлн'.'',
				},
				'10000000000000' => {
					'other' => '00 трлн'.'',
				},
				'100000000000000' => {
					'other' => '000 трлн'.'',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00)',
						'positive' => '#,##0.00',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(Дирҳами АМА),
				'other' => q(дирҳами АМА),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Афғонии Афғонистон),
				'other' => q(афғонии Афғонистон),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Леки албанӣ),
				'other' => q(леки албанӣ),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Драми Арманистон),
				'other' => q(драми Арманистон),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Гулдени Антилии Нидерланд),
				'other' => q(гулдени Антилии Нидерланд),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Кванзаи Ангола),
				'other' => q(кванзаи Ангола),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Песои Аргентина),
				'other' => q(песои Аргентина),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(Доллари Австралия),
				'other' => q(доллари Австралия),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Флорини Арубан),
				'other' => q(флорини Арубан),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Манати Озарбойҷон),
				'other' => q(манати Озарбойҷон),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(Маркаҳои конвертатсияшавандаи Босния-Герсеговина),
				'other' => q(Маркаҳои конвертатсияшавандаи Босния-Герсеговина),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Доллари Барбад),
				'other' => q(доллари Барбад),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Такаси Бангладеши),
				'other' => q(такаси Бангладеши),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Леви Болгария),
				'other' => q(леви Болгария),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Динори Баҳрайн),
				'other' => q(динори Баҳрайн),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Франки Бурунди),
				'other' => q(франки Бурунди),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Доллари Бермуд),
				'other' => q(доллари Бермуд),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Доллари Бруней),
				'other' => q(доллари Бруней),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Боливянои Боливия),
				'other' => q(боливянои Боливия),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(Реали бразилиягӣ),
				'other' => q(реали бразилиягӣ),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Доллари Багама),
				'other' => q(доллари Багама),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Нгултруми Бутан),
				'other' => q(нгултруми Бутан),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Пулаи Ботсвана),
				'other' => q(пулаи Ботсвана),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(Рубли Беларус),
				'other' => q(рубли Беларус),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Доллари Белиз),
				'other' => q(доллари Белиз),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(Доллари Канада),
				'other' => q(доллари Канада),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Франки Конго),
				'other' => q(франки Конго),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Франки Швейтсария),
				'other' => q(франки Швейтсария),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Песои Чили),
				'other' => q(песои Чили),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(Юани Хитой \(офшорӣ\)),
				'other' => q(юани Хитой \(офшорӣ\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(Иенаи хитоӣ),
				'other' => q(иенаи хитоӣ),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Песои Колумбия),
				'other' => q(песои Колумбия),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Колони Коста-Рика),
				'other' => q(Колони Коста-Рика),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Песои конвертшавандаи Куба),
				'other' => q(песои конвертшавандаи Куба),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Песои Куба),
				'other' => q(песои Куба),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Эскудои Кабо Верде),
				'other' => q(эскудои Кабо Верде),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(Крони Чехия),
				'other' => q(крони Чехия),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Франки Ҷибутӣ),
				'other' => q(франки Ҷибутӣ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Крони Дания),
				'other' => q(крони Дания),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Песои Доминикан),
				'other' => q(песои Доминикан),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Динори Алҷазоир),
				'other' => q(динори Алҷазоир),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Фунти мисрӣ),
				'other' => q(фунти мисрӣ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Накфаи Эритрея),
				'other' => q(накфаи Эритрея),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Бирри Эфиопия),
				'other' => q(бирри Эфиопия),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(Евро),
				'other' => q(евро),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Доллари Фиҷи),
				'other' => q(доллари Фиҷи),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Фунти Ҷазираҳои Фолкленд),
				'other' => q(фунти Ҷазираҳои Фолкленд),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(Фунт стерлинги британӣ),
				'other' => q(фунт стерлинги британӣ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Лариси гурҷӣ),
				'other' => q(лариси гурҷӣ),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Седи Гана),
				'other' => q(седи Гана),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Фунти Гибралтар),
				'other' => q(фунти Гибралтар),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Даласи Гамбия),
				'other' => q(даласи Гамбия),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Франки Гвинея),
				'other' => q(франки Гвинея),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Кветзали Гватемала),
				'other' => q(кветзали Гватемала),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Доллари Гайана),
				'other' => q(доллари Гайана),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(Доллари Гонконг),
				'other' => q(доллари Гонконг),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Лемпираи Гондурас),
				'other' => q(лемпираи Гондурас),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Кунаи Хорватия),
				'other' => q(кунаи Хорватия),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Гурди Ҳаити),
				'other' => q(гурди Ҳаити),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Форинти Венгрия),
				'other' => q(форинти Венгрия),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Рупияи Индонезия),
				'other' => q(рупияи Индонезия),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(Шекелҳои нави Исроил),
				'other' => q(шекелҳои нави Исроил),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(Рупияи ҳиндустонӣ),
				'other' => q(рупияи ҳиндустонӣ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Динори Ироқ),
				'other' => q(динори Ироқ),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Риёли Эрон),
				'other' => q(риёли Эрон),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Кронури Исландия),
				'other' => q(кронури Исландия),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Доллари Ямайка),
				'other' => q(доллари Ямайка),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Динори Иордания),
				'other' => q(динори Иордания),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(Иенаи японӣ),
				'other' => q(иенаи японӣ),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Шиллинги Кения),
				'other' => q(шиллинги Кения),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Соми Қирғизистон),
				'other' => q(соми Қирғизистон),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Риэли Камбоҷа),
				'other' => q(риэли Камбоҷа),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Франки Комория),
				'other' => q(франки Комория),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(Вони Кореяи Шимолӣ),
				'other' => q(вони Кореяи Шимолӣ),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(Вони Кореяи Ҷанубӣ),
				'other' => q(вони Кореяи Ҷанубӣ),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Динори Кувайт),
				'other' => q(динори Кувайт),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Доллари Ҷазираҳои Кайман),
				'other' => q(доллари Ҷазираҳои Кайман),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Тангаи Казокистон),
				'other' => q(тангаи Казокистон),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Кипи Лаосй),
				'other' => q(кипи Лаос),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Фунти Лубнон),
				'other' => q(фунти Лубнон),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Рупи Шри-Ланка),
				'other' => q(рупи Шри-Ланка),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Доллари Либерия),
				'other' => q(доллари Либерия),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лотиси Лесото),
				'other' => q(лотиси Лесото),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Динори Либия),
				'other' => q(динори Либия),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Дирхами Марокаш),
				'other' => q(дирхами Марокаш),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Лейи Молдова),
				'other' => q(лейи Молдова),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Ариарии Малагасий),
				'other' => q(ариарии Малагасий),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(Денори Македония),
				'other' => q(денори Македония),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(киати Мянмар),
				'other' => q(киати Мянмар),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Тугрики Муғулистон),
				'other' => q(тугрики Муғулистон),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Патакаи Макао),
				'other' => q(патакаи Макао),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(Огуияи Мавритания),
				'other' => q(Огуияи Мавритания),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Рупияи Маврикий),
				'other' => q(рупияи Маврикий),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Руфияи Малдив),
				'other' => q(руфияи Малдив),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Квачаи Малавия),
				'other' => q(квачаи Малавия),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(Песои Мексика),
				'other' => q(песои Мексика),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Ринггити Малайзия),
				'other' => q(ринггити Малайзия),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Метикали Мозамбик),
				'other' => q(метикали Мозамбик),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Доллари Намибия),
				'other' => q(доллари Намибия),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Найраи Нигерия),
				'other' => q(Найраи Нигерия),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Кордобаи Никарагуа),
				'other' => q(кордобаи Никарагуа),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Кронаи Норвегия),
				'other' => q(кронаи Норвегия),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Рупияи Непал),
				'other' => q(рупияи Непал),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(Доллари Зеландияи Нав),
				'other' => q(доллари Зеландияи Нав),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Риёли Уммон),
				'other' => q(риёли Уммон),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Балбоаи Панама),
				'other' => q(балбоаи Панама),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Соли Перу),
				'other' => q(соли Перу),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Кинаи Гвинеяи Папуа),
				'other' => q(кинаи Гвинеяи Папуа),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(Песои Филиппин),
				'other' => q(песои Филиппин),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Рупияи Покистон),
				'other' => q(рупияи Покистон),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(Злотии Польша),
				'other' => q(злотии Польша),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Гуарании Парагвай),
				'other' => q(гуарании Парагвай),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Риёли Қатар),
				'other' => q(риёли Қатар),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Лейи Руминия),
				'other' => q(лейи Руминия),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(Динори Сербия),
				'other' => q(динори Сербия),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(Рубли русӣ),
				'other' => q(рубли русӣ),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Франки Руанда),
				'other' => q(франки Руанда),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Риёли Саудӣ),
				'other' => q(риёли Саудӣ),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Доллари Ҷазираҳои Соломон),
				'other' => q(доллари Ҷазираҳои Соломон),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Рупии Сейшел),
				'other' => q(рупии Сейшел),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Фунти Судон),
				'other' => q(фунти Судон),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(Крони шведӣ),
				'other' => q(крони шведӣ),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Доллари Сингапур),
				'other' => q(доллари Сингапур),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Фунти Сент Елена),
				'other' => q(фунти Сент Елена),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(Леони Серра-Леоне),
				'other' => q(леони Серра-Леоне),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(Леони Серра-Леоне \(1964—2022\)),
				'other' => q(леони Серра-Леоне \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Шиллинги Сомали),
				'other' => q(шиллинги Сомали),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Доллари Суринам),
				'other' => q(доллари Суринам),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Фунти Судони Ҷанубӣ),
				'other' => q(фунти Судони Ҷанубӣ),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(Добраи Сан-Томе ва Принсипи),
				'other' => q(добраи Сан-Томе ва Принсипи),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Фунти Сурия),
				'other' => q(фунти Сурия),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Эмалангени Свази),
				'other' => q(эмалангени Свази),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(Бати Таиланд),
				'other' => q(бати Таиланд),
			},
		},
		'TJS' => {
			symbol => 'сом.',
			display_name => {
				'currency' => q(Сомонии Тоҷикистон),
				'other' => q(сомонии Тоҷикистон),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(манати Туркманистон),
				'other' => q(манати Туркманистон),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Динори Тунис),
				'other' => q(динори Тунис),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Паангаи Тонга),
				'other' => q(паангаи Тонга),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(Лираи Туркия),
				'other' => q(лираи Туркия),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Доллари Тринидад ва Тобаго),
				'other' => q(доллари Тринидад ва Тобаго),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(Доллари нави Тайван),
				'other' => q(доллари нави Тайван),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Шиллинги Танзания),
				'other' => q(шиллинги Танзания),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Гривнаи украинӣ),
				'other' => q(гривнаи украинӣ),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Шилинги Уганда),
				'other' => q(шиллинги Уганда),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(Доллари ИМА),
				'other' => q(доллари ИМА),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Песои Уругвай),
				'other' => q(песои Уругвай),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Сўми Ӯзбекистон),
				'other' => q(сўми Ӯзбекистон),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(Боливари Венесуэла),
				'other' => q(боливари Венесуэла),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(Донги Ветнам),
				'other' => q(донги Ветнам),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Ватуи Вануату),
				'other' => q(ватуи Вануату),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Талаи Самоа),
				'other' => q(талаи Самоа),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(Франки CFA Африқои Марказӣ),
				'other' => q(франки CFA Африқои Марказӣ),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(Доллари Кариби Шарқӣ),
				'other' => q(доллари Кариби Шарқӣ),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(Франки Африқои Ғарбӣ),
				'other' => q(франки Африқои Ғарбӣ),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(Франки CFP),
				'other' => q(франки CFP),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Асъори номаълум),
				'other' => q(\(асъори номаълум\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Риали Яман),
				'other' => q(риали Яман),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Рэнди Африқои Ҷанубӣ),
				'other' => q(рэнди Африқои Ҷанубӣ),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Квачаи Замбия),
				'other' => q(квачаи Замбия),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Янв',
							'Фев',
							'Мар',
							'Апр',
							'Май',
							'Июн',
							'Июл',
							'Авг',
							'Сен',
							'Окт',
							'Ноя',
							'Дек'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Январ',
							'Феврал',
							'Март',
							'Апрел',
							'Май',
							'Июн',
							'Июл',
							'Август',
							'Сентябр',
							'Октябр',
							'Ноябр',
							'Декабр'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Муҳ.',
							'Саф.',
							'Раб. I',
							'Раб. II',
							'Ҷум. I',
							'Ҷум. II',
							'Раҷ.',
							'Ша.',
							'Рам.',
							'Шав.',
							'Дхул-Қ.',
							'Дхул-Ҳ.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Муҳаррам',
							'Сафар',
							'Рабеъ I',
							'Рабеъ II',
							'ҷимоди-ул-уло',
							'ҷимоди-ул-сони',
							'раҷаб',
							'Шабан',
							'Рамадан',
							'Шаввал',
							'Дхут-Қидаҳ',
							'Дхут-Ҳиҷҷаҳ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					wide => {
						nonleap => [
							'Муҳаррам',
							'Сафар',
							'Рабеъ I',
							'Рабеъ II',
							'Ҷимоди-ул-уло',
							'Ҷимоди-ул-сони',
							'Раҷаб',
							'Шаъбон',
							'Рамазон',
							'Шаавол',
							'Дхул-Қидаҳ',
							'Дхул-Ҳиҷҷаҳ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'фарвардин',
							'урдибиҳишт',
							'хурдод',
							'тир',
							'мурдод',
							'шаҳривар',
							'меҳр',
							'обон',
							'озар',
							'дей',
							'баҳман',
							'исфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Дшб',
						tue => 'Сшб',
						wed => 'Чшб',
						thu => 'Пшб',
						fri => 'Ҷмъ',
						sat => 'Шнб',
						sun => 'Яшб'
					},
					wide => {
						mon => 'Душанбе',
						tue => 'Сешанбе',
						wed => 'Чоршанбе',
						thu => 'Панҷшанбе',
						fri => 'Ҷумъа',
						sat => 'Шанбе',
						sun => 'Якшанбе'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'Д',
						tue => 'С',
						wed => 'Ч',
						thu => 'П',
						fri => 'Ҷ',
						sat => 'Ш',
						sun => 'Я'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {0 => 'Ч1',
						1 => 'Ч2',
						2 => 'Ч3',
						3 => 'Ч4'
					},
				},
			},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ПеМ',
				'1' => 'ПаМ'
			},
			wide => {
				'0' => 'Пеш аз милод',
				'1' => 'Пас аз милод'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'САНА'
			},
		},
		'persian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, dd MMMM y G},
			'long' => q{dd MMMM y G},
			'medium' => q{dd MMM y G},
			'short' => q{dd/MM/yy GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd MMMM y},
			'long' => q{dd MMMM y},
			'medium' => q{dd MMM y},
			'short' => q{dd/MM/yy},
		},
		'islamic' => {
			'full' => q{EEEE, d MMMM'и' y G},
			'long' => q{d MMMM'и' y G},
			'medium' => q{d MMM y G},
			'short' => q{M/d/y GGGGG},
		},
		'persian' => {
			'full' => q{EEEE, d MMMM'и' y G},
			'long' => q{d MMMM'и' y G},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM y G},
			GyMd => q{M/d/y GGGGG},
			MEd => q{E, dd-MM},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd-MM},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{MM-y GGGGG},
			yyyyMEd => q{E, d-MM-y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{d-MM-y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			MEd => q{E, dd-MM},
			MMMEd => q{E, d MMM},
			MMMMW => q{'ҳафтаи' W, MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd-MM},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			yM => q{MM-y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM, y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d.M.y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{'ҳафтаи' w, Y},
		},
		'islamic' => {
			Ed => q{d E},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{MMM d, y G},
			MEd => q{E, M/d},
			MMMEd => q{E, MMM d},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{M/d},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, M/d/y GGGGG},
			yyyyMMMEd => q{E, MMM d, y G},
			yyyyMMMd => q{MMM d, y G},
			yyyyMd => q{M/d/y GGGGG},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, M/d – E, M/d},
				d => q{E, M/d – E, M/d},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, MMM d – E, MMM d},
				d => q{E, MMM d – E, MMM d},
			},
			MMMd => {
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM'и' y G},
				y => q{MMMM'и' y – MMMM'и' y G},
			},
			yMMMd => {
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			yMd => {
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
		},
		'gregorian' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, M/d – E, M/d},
				d => q{E, M/d – E, M/d},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, MMM d – E, MMM d},
				d => q{E, MMM d – E, MMM d},
			},
			MMMd => {
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h – h a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, M/d/y – E, M/d/y},
				d => q{E, M/d/y – E, M/d/y},
				y => q{E, M/d/y – E, M/d/y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, MMM d – E, MMM d, y},
				d => q{E, MMM d – E, MMM d, y},
				y => q{E, MMM d, y – E, MMM d, y},
			},
			yMMMM => {
				y => q{MMMM'и' y – MMMM'и' y},
			},
			yMMMd => {
				M => q{MMM d – MMM d, y},
				d => q{MMM d – d, y},
				y => q{MMM d, y – MMM d, y},
			},
			yMd => {
				M => q{M/d/y – M/d/y},
				d => q{M/d/y – M/d/y},
				y => q{M/d/y – M/d/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q(Вақти {0}),
		regionFormat => q(Вақти рӯзонаи {0}),
		regionFormat => q(Вақти стандартии {0}),
		'Afghanistan' => {
			long => {
				'standard' => q#Вақти Афғонистон#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абидҷон#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алҷазоир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуи#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банҷул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буҷумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Қоҳира#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Доруссалом#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Ҷибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эл Аиун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Ҷуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревиль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуту#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишо#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровия#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нҷамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Вақти Африқои Марказӣ#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Вақти Африқои Шарқӣ#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Вақти стандартии Африқои Ҷанубӣ#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Вақти тобистонаи Африқои Ғарбӣ#,
				'generic' => q#Вақти Африқои Ғарбӣ#,
				'standard' => q#Вақти стандартии Африқои Ғарбӣ#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Аляска#,
				'generic' => q#Вақти Аляска#,
				'standard' => q#Вақти стандартии Аляска#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Вақти тобистонаи Амазон#,
				'generic' => q#Вақти Амазон#,
				'standard' => q#Вақти стандартии Амазон#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкорич#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангиля#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуайна#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Галлегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуайя#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Бахия#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Бахия де Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Блан-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойз#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриҷ Бэй#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#Сюдад Хуарес#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Атикокан#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмаркшавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Сальвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нелсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глэйс Бэй#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Бэй#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Терк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гайана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Ҳавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Эрмосилло#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Петербург, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вевай, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсенс, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Ҷуҷуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Ҷуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичелло, Кентукки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендйк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла-Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анҷелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Квартали Поёни Принс#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиника#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномин#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтеррей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Ню-Йорк#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норонха#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бейла, Дакотаи Шимолӣ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Сентр, Дакотаи Шимолӣ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Ню Салем, Дакотаи Шимолӣ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Ожинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порти Испания#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту Велхо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта Аренас#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Иттоккортоормиит#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент Бартелеми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент Ҷонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент-Люсия#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт-Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Вақти рӯзонаи марказӣ#,
				'generic' => q#Вақти марказӣ#,
				'standard' => q#Вақти стандартии марказӣ#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Вақти рӯзонаи шарқӣ#,
				'generic' => q#Вақти шарқӣ#,
				'standard' => q#Вақти стандартии шарқӣ#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Вақти рӯзонаи кӯҳӣ#,
				'generic' => q#Вақти кӯҳӣ#,
				'standard' => q#Вақти стандартии кӯҳӣ#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Уқёнуси Ором#,
				'generic' => q#Вақти Уқёнуси Ором#,
				'standard' => q#Вақти стандартии Уқёнуси Ором#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дэвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон д’Урвилл#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуари#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мавсон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмердо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сёва#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Апиа#,
				'generic' => q#Вақти Апиа#,
				'standard' => q#Вақти стандартии Апиа#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Арабистон#,
				'generic' => q#Вақти Арабистон#,
				'standard' => q#Вақти стандартии Арабистон#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгйербён#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Вақти тобистонаи Аргентина#,
				'generic' => q#Вақти Аргентина#,
				'standard' => q#Вақти стандартии Аргентина#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Вақти тобистонаи Аргентинаи Ғарбӣ#,
				'generic' => q#Вақти Аргентинаи Ғарбӣ#,
				'standard' => q#Вақти стандартии Аргентинаи Ғарбӣ#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Арманистон#,
				'generic' => q#Вақти Арманистон#,
				'standard' => q#Вақти стандартии Арманистон#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Адан#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмаато#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аммон#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхобод#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атирау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдод#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Баҳрайн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Боку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Колката#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Димишқ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Ғазза#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Ҳонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Ҷакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Ҷаяпура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Йерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кобул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувайт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Маскат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнетск#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхенян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Қатар#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#Кустанай#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Қизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Янгон#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Риёз#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарқанд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколимск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайбэй#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Тошкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Теҳрон#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимфу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вьентян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Вақти рӯзонаи атлантикӣ#,
				'generic' => q#Вақти атлантикӣ#,
				'standard' => q#Вақти стандартии атлантикӣ#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Ҷазираҳои Азор#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канария#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарер#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Ҷорҷияи Ҷанубӣ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Сент Елена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен-Хилл#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Эукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хоу#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Вақти рӯонаи Австралияи Марказӣ#,
				'generic' => q#Вақти Австралияи Марказӣ#,
				'standard' => q#Вақти стандартии Австралияи Марказӣ#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Ғарбии Австралия Марказӣ#,
				'generic' => q#Вақти Ғарбии Марказии Австралия#,
				'standard' => q#Вақти стандартии Ғарбии Австралия Марказӣ#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Вақти рӯзонаи шарқии Австралия#,
				'generic' => q#Вақти Австралияи Шарқӣ#,
				'standard' => q#Вақти стандартии шарқии Австралия#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Австралияи Ғарбӣ#,
				'generic' => q#Вақти Австралияи Ғарбӣ#,
				'standard' => q#Вақти стандартии Австралияи Ғарбӣ#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Вақти тобистонаи Озарбойҷон#,
				'generic' => q#Вақти Озарбойҷон#,
				'standard' => q#Вақти стандартии Озарбойҷон#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Вақти тобистонаи Азор#,
				'generic' => q#Вақти Азор#,
				'standard' => q#Вақти стандартии Азор#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Вақти тобистонаи Бангладеш#,
				'generic' => q#Вақти Бангладеш#,
				'standard' => q#Вақти стандартии Бангладеш#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Вақти Бутан#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Вақти Боливия#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Вақти тобистонаи Бразилия#,
				'generic' => q#Вақти Бразилия#,
				'standard' => q#Вақти стандартии Бразилия#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Вақти Бруней Доруссалом#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Вақти тобистонаи Кабо-Верде#,
				'generic' => q#Вақти Кабо Верде#,
				'standard' => q#Вақти стандартии Кабо-Верде#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Вақти стандартии Чаморро#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Чатам#,
				'generic' => q#Вақти Чатам#,
				'standard' => q#Вақти стандартии Чатам#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Вақти тобистонаи Чили#,
				'generic' => q#Вақти Чили#,
				'standard' => q#Вақти стандартии Чили#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Чин#,
				'generic' => q#Вақти Чин#,
				'standard' => q#Вақти стандартии Чин#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Вақти ҷазираи Мавлуди Исо#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Вақти Ҷазираҳои Кокос#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Вақти тобистонаи Колумбия#,
				'generic' => q#Вақти Колумбия#,
				'standard' => q#Вақти стандартии Колумбия#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Вақти нимаи тобистонаи Ҷазираҳои Кук#,
				'generic' => q#Вақти ҷазираҳои Кук#,
				'standard' => q#Вақти стандартии Ҷазираҳои Кук#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Куба#,
				'generic' => q#Вақти Куба#,
				'standard' => q#Вақти стандартии Куба#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Вақти Давис#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Вақти Дюмон-д’Урвил#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Вақти Тимори Шарқӣ#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Вақти тобистонаи ҷазираи Пасха#,
				'generic' => q#Вақти ҷазираи Пасха#,
				'standard' => q#Вақти стандартии ҷазираи Пасха#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Вақти Эквадор#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Вақти ҷаҳонии ҳамоҳангсозӣ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Шаҳри номаълум#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахань#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бусинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинёв#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q#Вақти стандартии Ирландия#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Ҷазираи Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Ҷерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Вақти тобистонаи Британия#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марихамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгоритса#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопол#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопйе#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокголм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тиран#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Уляновск#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Сюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Вақти тобистонаи аврупоии марказӣ#,
				'generic' => q#Вақти Аврупоии Марказӣ#,
				'standard' => q#Вақти стандартии аврупоии марказӣ#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Вақти тобистонаи аврупоии шарқӣ#,
				'generic' => q#Вақти аврупоии шарқӣ#,
				'standard' => q#Вақти стандартии аврупоии шарқӣ#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Вақти Аврупои Шарқӣ#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Вақти тобистонаи аврупоии ғарбӣ#,
				'generic' => q#Вақти аврупоии ғарбӣ#,
				'standard' => q#Вақти стандартии аврупоии ғарбӣ#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Вақти тобистонаи Ҷазираҳои Фолкленд#,
				'generic' => q#Вақти Ҷазираҳои Фолкленд#,
				'standard' => q#Вақти стандартии Ҷазираҳои Фолкленд#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Вақти тобистонаи Фиҷи#,
				'generic' => q#Вақти Фиҷи#,
				'standard' => q#Вақти стандартии Фиҷи#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Вақти Гвианаи Фаронса#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Вақти ҷанубӣ ва Антарктидаи Фаронса#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Вақти миёнаи Гринвич#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Вақти Галапагос#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Вақти Гамбир#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Вақти тобистонаи Гурҷистон#,
				'generic' => q#Вақти Гурҷистон#,
				'standard' => q#Вақти стандартии Гурҷистон#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Вақти Ҷазираҳои Гилберт#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Вақти тобистонаи Гренландияи Шарқӣ#,
				'generic' => q#Вақти Гренландияи Шарқӣ#,
				'standard' => q#Вақти стандартии Гренландияи Шарқӣ#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Вақти тобистонаи Гренландияи Ғарбӣ#,
				'generic' => q#Вақти Гренландияи Ғарбӣ#,
				'standard' => q#Вақти стандартии Гренландияи Ғарбӣ#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Вақти стандартии Халиҷи Форс#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Вақти Гайана#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Ҳавайӣ-Алеутӣ#,
				'generic' => q#Вақти Ҳавайӣ-Алеутӣ#,
				'standard' => q#Вақти стандартии Ҳавайӣ-Алеутӣ#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Вақти тобистонаи Ҳонконг#,
				'generic' => q#Вақти Ҳонконг#,
				'standard' => q#Вақти стандартии Ҳонконг#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Вақти тобистонаи Ховд#,
				'generic' => q#Вақти Ховд#,
				'standard' => q#Вақти стандартии Ҳовд#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Вақти стандартии Ҳиндустон#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариву#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Кристмас#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергулен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдив#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикий#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюнион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Вақти уқёнуси Ҳинд#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Вақти Ҳиндучин#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Вақти Индонезияи Марказӣ#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Вақти шарқии Индонезия#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Вақти Индонезияи Ғарбӣ#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Эрон#,
				'generic' => q#Вақти Эрон#,
				'standard' => q#Вақти стандартии Эрон#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Вақти тобистонаи Иркутск#,
				'generic' => q#Вақти Иркутск#,
				'standard' => q#Вақти стандартии Иркутск#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Исроил#,
				'generic' => q#Вақти Исроил#,
				'standard' => q#Вақти стандартии Исроил#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Вақти равшании Ҷопон#,
				'generic' => q#Вақти Ҷопон#,
				'standard' => q#Вақти стандартии Ҷопон#,
			},
		},
		'Kazakhstan' => {
			long => {
				'standard' => q#Вақти Қазоқистон#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Вақти Қазоқистони Шарқӣ#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Вақти Қазоқистони Ғарбӣ#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Корея#,
				'generic' => q#Вақти Корея#,
				'standard' => q#Вақти стандартии Корея#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Вақти Косрае#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Вақти тобистонаи Красноярск#,
				'generic' => q#Вақти Красноярск#,
				'standard' => q#Вақти стандартии Красноярск#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Вақти Қирғизистон#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Вақти Ҷазираҳои Лин#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Лорд Хоу#,
				'generic' => q#Лорд Хоу Time#,
				'standard' => q#Вақти стандартии Лорд Хоу#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Вақти тобистонаи Магадан#,
				'generic' => q#Вақти Магадан#,
				'standard' => q#Вақти стандартии Магадан#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Вақти Малайзия#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Вақти Малдив#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Вақти Маркес#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Вақти Ҷазираҳои Маршалл#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Вақти тобистонаи Маврикий#,
				'generic' => q#Вақти Маврикий#,
				'standard' => q#Вақти стандартии Маврикий#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Вақти Мавсон#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Уқёнуси Ором Мексика#,
				'generic' => q#Вақти Уқёнуси Ором Мексика#,
				'standard' => q#Вақти стандартии Уқёнуси Ором Мексика#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Вақти тобистонаи Улан-Батор#,
				'generic' => q#Вақти Улан-Батор#,
				'standard' => q#Вақти стандартии Улан-Батор#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Вақти тобистонаи Маскав#,
				'generic' => q#Вақти Москва#,
				'standard' => q#Вақти стандартии Маскав#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Вақти Мянма#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Вақти Науру#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Вақти Непал#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Вақти тобистонаи Каледонияи Нав#,
				'generic' => q#Вақти Каледонияи Нав#,
				'standard' => q#Вақти стандартии Каледонияи Нав#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Зеландияи Нав#,
				'generic' => q#Вақти Зеландияи Нав#,
				'standard' => q#Вақти стандартии Зеландияи Нав#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Нюфаундленд#,
				'generic' => q#Вақти Нюфаундленд#,
				'standard' => q#Вақти стандартии Нюфаундленд#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Вақти Ниуэ#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Вақти рӯзонаи ҷазираи Норфолк#,
				'generic' => q#Вақти ҷазираи Норфолк#,
				'standard' => q#Вақти стандартии ҷазираи Норфолк#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Вақти тобистонаи Фернандо де Норонха#,
				'generic' => q#Вақти Фернандо де Норонха#,
				'standard' => q#Вақти стандартии Фернандо де Норонха#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Вақти тобистонаи Новосибирск#,
				'generic' => q#Вақти Новосибирск#,
				'standard' => q#Вақти стандартии Новосибирск#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Вақти тобистонаи Омск#,
				'generic' => q#Вақти Омск#,
				'standard' => q#Омск вақти стандартӣ#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвилл#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Истер#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфате#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиҷи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбир#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#Кантон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кважалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мажуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркес#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвей#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкэрн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпей#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вейк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Вақти тобистонаи Покистон#,
				'generic' => q#Вақти Покистон#,
				'standard' => q#Вақти стандартии Покистон#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Вақти Палау#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Вақти Папуа Гвинеяи Нав#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Вақти тобистонаи Парагвай#,
				'generic' => q#Вақти Парагвай#,
				'standard' => q#Вақти стандартии Парагвай#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Вақти тобистонаи Перу#,
				'generic' => q#Вақти Перу#,
				'standard' => q#Вақти стандартии Перу#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Вақти тобистонаи Филиппин#,
				'generic' => q#Вақти Филиппин#,
				'standard' => q#Вақти стандартии Филиппин#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Вақти Ҷазираҳои Финикс#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Сент-Пиер ва Микелон#,
				'generic' => q#Вақти Сент-Пиер ва Микелон#,
				'standard' => q#Вақти стандартии Сент-Пиер ва Микелон#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Вақти Питкэрн#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Ponape Time#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Вақти Пхенян#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Вақти Реюнион#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Вақти Ротера#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Вақти тобистонаи Сахалин#,
				'generic' => q#Вақти Сахалин#,
				'standard' => q#Вақти стандартии Сахалин#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Самоа#,
				'generic' => q#Вақти Самоа#,
				'standard' => q#Вақти стандартии Самоа#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Вақти Сейшел#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Вақти стандартии Сингапур#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Вақти Ҷазираҳои Соломон#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Вақти Ҷорҷияи Ҷанубӣ#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Вақти Суринам#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Вақти Сёва#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Вақти Таити#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Вақти рӯзонаи Тайбэй#,
				'generic' => q#Вақти Тайбэй#,
				'standard' => q#Вақти стандартии Тайбэй#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Вақти Тоҷикистон#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Вақти Токелау#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Вақти тобистонаи Тонга#,
				'generic' => q#Вақти Тонга#,
				'standard' => q#Вақти стандартии Тонга#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Вақти Чук#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Вақти тобистонаи Туркманистон#,
				'generic' => q#Вақти Туркманистон#,
				'standard' => q#Вақти стандартии Туркманистон#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Вақти Тувалу#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Вақти тобистонаи Уругвай#,
				'generic' => q#Вақти Уругвай#,
				'standard' => q#Вақти стандартии Уругвай#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Вақти тобистонаи Ӯзбекистон#,
				'generic' => q#Вақти Ӯзбекистон#,
				'standard' => q#Вақти стандартии Ӯзбекистон#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вақти тобистонаи Вануату#,
				'generic' => q#Вақти Вануату#,
				'standard' => q#Вақти стандартии Вануату#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Вақти Венесуэла#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Вақти тобистонаи Владивосток#,
				'generic' => q#Вақти Владивосток#,
				'standard' => q#Вақти стандартии Владивосток#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Вақти тобистонаи Волгоград#,
				'generic' => q#Вақти Волгоград#,
				'standard' => q#Вақти стандартии Волгоград#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Вақти Восток#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Вақти бедории ҷазира#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Вақти Уоллис ва Футуна#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якутск вақти тобистона#,
				'generic' => q#Вақти Якутск#,
				'standard' => q#Якутск вақти стандартӣ#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Вақти тобистонаи Екатеринбург#,
				'generic' => q#Вақти Екатеринбург#,
				'standard' => q#Вақти стандартии Екатеринбург#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#Вақти Юкон#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
