#!/usr/bin/perl -w

###############################################################################
#
# A test for Spreadsheet::WriteExcelXML.
#
# Tests hyperlinks.
#
# reverse(''), July 2004, John McNamara, jmcnamara@cpan.org
#


use strict;
use Spreadsheet::WriteExcelXML;
use Test::More tests => 7;



##############################################################################
#
# Create a new Excel XML file with row data set.
#
my $test_file  = "temp_test_file.xml";
my $workbook   = Spreadsheet::WriteExcelXML->new($test_file);
my $worksheet1 = $workbook->add_worksheet();
my $worksheet2 = $workbook->add_worksheet();


# Add the standard url link format.
my $url_format = $workbook->add_format(
                                        color     => 'blue',
                                        underline => 1,
                                      );

# Add a sample format.
my $red_format = $workbook->add_format(
                                        color     => 'red',
                                        bold      => 1,
                                        underline => 1,
                                      );

# Add an alternate description string to the URL.
my $str = 'Perl home.';

# Add a "tool tip" to the URL.
my $tip = 'Get the latest Perl news here.';


# Write some hyperlinks
$worksheet1->write('A1', 'http://www.perl.com/', $url_format                );
$worksheet1->write('A3', 'http://www.perl.com/', $url_format, $str          );
$worksheet1->write('A5', 'http://www.perl.com/', $url_format, $str, $tip    );
$worksheet1->write('A7', 'http://www.perl.com/', $red_format                );
$worksheet1->write('A9', 'mailto:jmcnamara@cpan.org', $url_format, 'Mail me');

# Write a URL that isn't a hyperlink
$worksheet1->write_string('A11', 'http://www.perl.com/');

$workbook->close();


##############################################################################
#
# Re-open and reread the Excel file.
#
open XML, $test_file or die "Couldn't open $test_file: $!\n";
my @swex_data = extract_rows(*XML);
close XML;
unlink $test_file;


##############################################################################
#
# Read the data from the Excel file in the __DATA__ section
#
my @test_data = extract_rows(*DATA);


##############################################################################
#
# Check for the same number of elements.
#

is(@swex_data, @test_data, " \tCheck for data size");


##############################################################################
#
# Test that the SWEX elements and Excel are the same.
#

# Pad the SWEX data if necessary.
push @swex_data, ('') x (@test_data -@swex_data);

for my $i (0 .. @test_data -1) {
    is($swex_data[$i],$test_data[$i], " \tTesting ss:Index attribute");

}



##############################################################################
#
# Extract <Row> elements from a given filehandle.
#
sub extract_rows {

    my $fh     = $_[0];
    my $in_row = 0;
    my $row    = '';
    my @rows;

    while (<$fh>) {
        s/^\s+([<| ])/$1/;
        s/\s+$//;

        $in_row = 1 if m/<Row/;

        $row .= $_ if $in_row;

        if (m[</Row>]) {
            $in_row  = 0;
            push @rows, $row;
            $row     = '';
        }
    }

    return @rows;
}



# The following data was generated by Excel.
# One height attribute removed and S23 changed to S22.
__DATA__
<?xml version="1.0"?>
<?mso-application progid="Excel.Sheet"?>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:o="urn:schemas-microsoft-com:office:office"
 xmlns:x="urn:schemas-microsoft-com:office:excel"
 xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:html="http://www.w3.org/TR/REC-html40">
 <Styles>
  <Style ss:ID="Default" ss:Name="Normal">
   <Alignment ss:Vertical="Bottom"/>
   <Borders/>
   <Font/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Vertical="Bottom"/>
   <Borders/>
   <Font ss:Color="#0000FF" ss:Underline="Single"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s22">
   <Alignment ss:Vertical="Bottom"/>
   <Borders/>
   <Font ss:Size="12" ss:Color="#FF0000" ss:Bold="1" ss:Underline="Single"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
 </Styles>
 <Worksheet ss:Name="Sheet1">
  <Table ss:ExpandedColumnCount="1" ss:ExpandedRowCount="11" x:FullColumns="1"
   x:FullRows="1">
   <Row>
    <Cell ss:StyleID="s21" ss:HRef="http://www.perl.com/"><Data ss:Type="String">http://www.perl.com/</Data></Cell>
   </Row>
   <Row ss:Index="3">
    <Cell ss:StyleID="s21" ss:HRef="http://www.perl.com/"><Data ss:Type="String">Perl home.</Data></Cell>
   </Row>
   <Row ss:Index="5">
    <Cell ss:StyleID="s21" ss:HRef="http://www.perl.com/"
     x:HRefScreenTip="Get the latest Perl news here."><Data ss:Type="String">Perl home.</Data></Cell>
   </Row>
   <Row ss:Index="7">
    <Cell ss:StyleID="s22" ss:HRef="http://www.perl.com/"><Data ss:Type="String">http://www.perl.com/</Data></Cell>
   </Row>
   <Row ss:Index="9">
    <Cell ss:StyleID="s21" ss:HRef="mailto:jmcnamara@cpan.org"><Data
      ss:Type="String">Mail me</Data></Cell>
   </Row>
   <Row ss:Index="11">
    <Cell><Data ss:Type="String">http://www.perl.com/</Data></Cell>
   </Row>
  </Table>
  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">
   <Selected/>
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
 <Worksheet ss:Name="Sheet2">
  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
</Workbook>
