// Generated by CoffeeScript 1.12.8

/*
LemonLDAP::NG WebAuthn verify script
 */

(function() {
  var check, setMsg, webAuthnError;

  setMsg = function(msg, level) {
    $('#msg').attr('trspan', msg);
    $('#msg').html(window.translate(msg));
    $('#color').removeClass('message-positive message-warning message-danger alert-success alert-warning alert-danger');
    $('#color').addClass("message-" + level);
    if (level === 'positive') {
      level = 'success';
    }
    return $('#color').addClass("alert-" + level);
  };

  webAuthnError = function(error) {
    switch (error.name) {
      case 'unsupported':
        return setMsg('webAuthnUnsupported', 'warning');
      default:
        return setMsg('webAuthnBrowserFailed', 'danger');
    }
  };

  check = function() {
    var request;
    setMsg('webAuthnBrowserInProgress', 'warning');
    request = window.datas.request;
    return WebAuthnUI.WebAuthnUI.getCredential(request).then(function(response) {
      $('#credential').val(JSON.stringify(response));
      return $('#verify-form').submit();
    })["catch"](function(error) {
      return webAuthnError(error);
    });
  };

  $(document).ready(function() {
    setTimeout(check, 1000);
    return $('#retrybutton').on('click', check);
  });

}).call(this);
