/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class StaticResourceHandler {
    private static final ImmutableMap<String, MediaType> MIME_TYPES = ImmutableMap.of("css", MediaType.CSS_UTF_8.withoutParameters(), "html", MediaType.HTML_UTF_8.withoutParameters(), "js", MediaType.JAVASCRIPT_UTF_8.withoutParameters());
    private static final String STATIC_RESOURCE_BASE_PATH = "/static/resource/";
    private static final String HUB_HTML_PATH = "/static/resource/hub.html";

    StaticResourceHandler() {
    }

    public boolean isStaticResourceRequest(HttpServletRequest request) {
        return "GET".equalsIgnoreCase(request.getMethod()) && Strings.nullToEmpty(request.getPathInfo()).startsWith(STATIC_RESOURCE_BASE_PATH);
    }

    public void redirectToHub(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(request.getContextPath() + request.getServletPath() + HUB_HTML_PATH);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Preconditions.checkArgument(this.isStaticResourceRequest(request));
        String path = String.format("/%s/%s", StaticResourceHandler.class.getPackage().getName().replace(".", "/"), request.getPathInfo().substring(STATIC_RESOURCE_BASE_PATH.length()));
        URL url = StaticResourceHandler.class.getResource(path);
        if (url == null) {
            response.sendError(404);
            return;
        }
        response.setStatus(200);
        String extension = Files.getFileExtension(path);
        if (MIME_TYPES.containsKey(extension)) {
            response.setContentType(MIME_TYPES.get(extension).toString());
        }
        byte[] data = this.getResourceData(url);
        response.setContentLength(data.length);
        try (ServletOutputStream output = response.getOutputStream();){
            output.write(data);
        }
    }

    private byte[] getResourceData(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            byte[] byArray = ByteStreams.toByteArray(stream);
            return byArray;
        }
    }
}

