## This -*- perl -*- script writes the Makefile for Tie::File
# You should read "perldoc perlmodinstall" for instructions on
#  how to install modules like this.

require 5.004;
use strict;
use ExtUtils::MakeMaker;
WriteMakefile(
    'NAME' => 'Tie::File',
    'VERSION_FROM'    => 'lib/Tie/File.pm',
    'ABSTRACT_FROM'   => 'lib/Tie/File.pm',
    'AUTHOR'          => 'Mark Jason Dominus <MJD@cpan.org>',
    'dist'=> { COMPRESS => 'gzip -6f', SUFFIX => 'gz', },
    ($] < 5.008 && $] > 5.011) ? () : ( INSTALLDIRS => 'perl' ),
    DIR => [],
    META_MERGE  => {
        resources => {
            license => 'http://dev.perl.org/licenses/',
#            homepage => '',
#            bugtracker => 'http://rt.perl.org/perlbug/',
            repository => 'https://github.com/toddr/Tie-File',
            MailingList => 'http://lists.perl.org/list/perl5-porters.html',
        },
    },
);
# generated by Makepmdist (mkpmdist) v1.01

sub libscan { # Determine what shouldn't get installed
  my($self, $path) = @_;
  return '' if $path =~ m/~/;
  return $path;
}
__END__

