#!/usr/bin/perl

package eBay::API::XML::Call::ReviseMyMessages::ReviseMyMessagesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ReviseMyMessagesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::ReviseMyMessages::ReviseMyMessagesRequestType

=head1 DESCRIPTION

Sets the read state for messages and alerts, the flagged state of messages, and moves
alerts and messages into and out of folders.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::ReviseMyMessages::ReviseMyMessagesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::MyMessagesAlertIDArrayType;
use eBay::API::XML::DataType::MyMessagesMessageIDArrayType;


my @gaProperties = ( [ 'AlertIDs', 'ns:MyMessagesAlertIDArrayType', ''
	     ,'eBay::API::XML::DataType::MyMessagesAlertIDArrayType', '1' ]
	, [ 'Flagged', 'xs:boolean', '', '', '' ]
	, [ 'FolderID', 'xs:long', '', '', '' ]
	, [ 'MessageIDs', 'ns:MyMessagesMessageIDArrayType', ''
	     ,'eBay::API::XML::DataType::MyMessagesMessageIDArrayType', '1' ]
	, [ 'Read', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAlertIDs()

Contains a list of up to 10 AlertID values.
<br /><br />
Either AlertIDs, MessageIDs, or both must be included in
the request. Alerts cannot be flagged. Alerts cannot be
moved into a new folder until they have been resolved.
<br /><br />
Resolve alerts by marking Read (if no action is
required), or by using ActionURL (if action is
required).

  RequiredInput: Conditionally
#    Argument: 'ns:MyMessagesAlertIDArrayType'

=cut

sub setAlertIDs {
  my $self = shift;
  $self->{'AlertIDs'} = shift
}

=head2 getAlertIDs()

#    Returns: 'ns:MyMessagesAlertIDArrayType'

=cut

sub getAlertIDs {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AlertIDs'
		,'eBay::API::XML::DataType::MyMessagesAlertIDArrayType');
}


=head2 setFlagged()

Changes the flagged states of all messages specified in
a request by their MessageID values. At least one of
Read, Flagged, or FolderID must be specified in the
request. Messages in the Sent box cannot be moved,
marked as Read, or Flagged. Alerts cannot be flagged.

  RequiredInput: Conditionally
#    Argument: 'xs:boolean'

=cut

sub setFlagged {
  my $self = shift;
  $self->{'Flagged'} = shift
}

=head2 isFlagged()

#    Returns: 'xs:boolean'

=cut

sub isFlagged {
  my $self = shift;
  return $self->{'Flagged'};
}


=head2 setFolderID()

An ID that uniquely identifies the My Messages folder to
move alerts and messages into. At least one of Read,
Flagged, or FolderID must be specified in the request.
<br /><br />
Alerts cannot be moved until they are resolved. Messages
in the Sent box cannot be moved, marked as Read, or
Flagged.

  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut

sub setFolderID {
  my $self = shift;
  $self->{'FolderID'} = shift
}

=head2 getFolderID()

#    Returns: 'xs:long'

=cut

sub getFolderID {
  my $self = shift;
  return $self->{'FolderID'};
}


=head2 setMessageIDs()

Contains a list of up to 10 MessageID values.
<br /><br />
Either AlertIDs, MessageIDs, or both must be included in
the request. Messages in the Sent box cannot be moved,
marked as Read, or Flagged.

  RequiredInput: Conditionally
#    Argument: 'ns:MyMessagesMessageIDArrayType'

=cut

sub setMessageIDs {
  my $self = shift;
  $self->{'MessageIDs'} = shift
}

=head2 getMessageIDs()

#    Returns: 'ns:MyMessagesMessageIDArrayType'

=cut

sub getMessageIDs {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MessageIDs'
		,'eBay::API::XML::DataType::MyMessagesMessageIDArrayType');
}


=head2 setRead()

Changes the read states of all alerts and
messages specified in a request by their AlertID
or MessageID values. At least one of Read,
Flagged, or FolderID must be specified in the
request. Messages in the Sent box cannot be moved,
marked as Read, or Flagged.
<br /><br />
Note that alerts and messages retrieved
with the API are not automatically marked Read,
and must be marked Read with this call.

  RequiredInput: Conditionally
#    Argument: 'xs:boolean'

=cut

sub setRead {
  my $self = shift;
  $self->{'Read'} = shift
}

=head2 isRead()

#    Returns: 'xs:boolean'

=cut

sub isRead {
  my $self = shift;
  return $self->{'Read'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
