/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;

public class Netcdf2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    private NetcdfDataset ds;
    private boolean isVolume;
    private double latv;
    private double lonv;
    private double elev;

    @Override
    public boolean isMine(NetcdfDataset ds) {
        String format = ds.findAttValueIgnoreCase(null, "format", null);
        if (format != null && format.startsWith("nssl/netcdf")) {
            return true;
        }
        Dimension az = ds.findDimension("Azimuth");
        Dimension gt = ds.findDimension("Gate");
        return null != az && null != gt;
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new Netcdf2Dataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public Netcdf2Dataset() {
    }

    public Netcdf2Dataset(NetcdfDataset ds) {
        super(ds);
        this.ds = ds;
        this.desc = "Netcdf/NCML 2 radar dataset";
        this.setEarthLocation();
        try {
            this.setTimeUnits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
        try {
            this.addCoordSystem(ds);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addCoordSystem(NetcdfDataset ds) throws IOException {
        Variable sp;
        double ele = 0.0;
        Attribute attr = ds.findGlobalAttributeIgnoreCase("Elevation");
        if (attr != null) {
            ele = attr.getNumericValue().doubleValue();
        }
        if ((sp = ds.findVariable("sweep")) == null) {
            ds.addDimension(null, new Dimension("Elevation", 1, true));
            String lName = "elevation angle in degres: 0 = parallel to pedestal base, 90 = perpendicular";
            CoordinateAxis1D v = new CoordinateAxis1D(ds, null, "Elevation", DataType.DOUBLE, "Elevation", "degrees", lName);
            ds.setValues(v, 1, ele, 0.0);
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString()));
            ds.addVariable(null, v);
        } else {
            Array spdata = sp.read();
            float[] spd = (float[])spdata.get1DJavaArray(Float.TYPE);
            int spsize = spd.length;
            ds.addDimension(null, new Dimension("Elevation", spsize, true));
            String lName = "elevation angle in degres: 0 = parallel to pedestal base, 90 = perpendicular";
            CoordinateAxis1D v = new CoordinateAxis1D(ds, null, "Elevation", DataType.DOUBLE, "Elevation", "degrees", lName);
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString()));
            ds.addVariable(null, v);
        }
        ds.addAttribute(null, new Attribute("IsRadial", new Integer(1)));
        attr = ds.findGlobalAttributeIgnoreCase("vcp-value");
        String vcp = attr == null ? "11" : attr.getStringValue();
        ds.addAttribute(null, new Attribute("VolumeCoveragePatternName", vcp));
        ds.finish();
    }

    @Override
    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    @Override
    public String getRadarID() {
        Attribute ga = this.ds.findGlobalAttribute("radarName-value");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "XXXX";
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    public String getRadarName() {
        return this.ds.findGlobalAttribute("ProductStationName").getStringValue();
    }

    @Override
    public String getDataFormat() {
        return "NetCDF Level II";
    }

    public void setIsVolume(NetcdfDataset nds) {
        String format = nds.findAttValueIgnoreCase(null, "volume", null);
        if (format == null) {
            this.isVolume = false;
            return;
        }
        this.isVolume = format.equals("true");
    }

    @Override
    public boolean isVolume() {
        return this.isVolume;
    }

    @Override
    protected void setEarthLocation() {
        Attribute ga = this.ds.findGlobalAttribute("Latitude");
        this.latv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("Longitude");
        this.lonv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("Height");
        this.elev = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        this.origin = new EarthLocationImpl(this.latv, this.lonv, this.elev);
    }

    @Override
    protected void setTimeUnits() throws Exception {
        List<CoordinateAxis> axes = this.ds.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = axes.get(i);
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = new DateUnit(units);
            this.calDateUnits = CalendarDateUnit.of(null, units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    @Override
    protected void setStartDate() {
        String start_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_start", null);
        if (start_datetime != null) {
            this.startDate = DateUnit.getStandardOrISO(start_datetime);
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    @Override
    protected void setEndDate() {
        String end_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_end", null);
        if (end_datetime != null) {
            this.endDate = DateUnit.getStandardOrISO(end_datetime);
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    @Override
    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        RadialDatasetSweep.RadialVariable rsvar = null;
        String vName = var.getShortName();
        int rnk = var.getRank();
        this.setIsVolume(nds);
        if (this.isVolume && rnk == 3) {
            RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(this, vName, var.getAttributes());
            rsvar = this.makeRadialVariable(nds, v, var);
        } else if (!this.isVolume && rnk == 2) {
            RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(this, vName, var.getAttributes());
            rsvar = this.makeRadialVariable(nds, v, var);
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    @Override
    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
        return new Netcdf2Variable(nds, v, v0);
    }

    @Override
    public void clearDatasetMemory() {
        List<VariableSimpleIF> rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radialVariable : rvars) {
            radialVariable.clearVariableMemory();
        }
    }

    public String getInfo() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Netcdfs2Dataset\n");
        sbuff.append(super.getDetailInfo());
        sbuff.append("\n\n");
        sbuff.append(this.parseInfo.toString());
        return sbuff.toString();
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        float[] az;
        RadialDatasetSweep.Sweep sw;
        int nsweep = rv.getNumSweeps();
        for (int i = 0; i < nsweep; ++i) {
            sw = rv.getSweep(i);
            sw.getMeanElevation();
            float me = sw.getMeanElevation();
            System.out.println("*** radar Sweep mean elevation of sweep " + i + " is: " + me);
            int nrays = sw.getRadialNumber();
            az = new float[nrays];
            for (int j = 0; j < nrays; ++j) {
                float azi;
                az[j] = azi = sw.getAzimuth(j);
            }
        }
        sw = rv.getSweep(0);
        float[] ddd = sw.readData();
        sw.getAzimuth();
        sw.getElevation();
        assert (null != ddd);
        int nrays = sw.getRadialNumber();
        az = new float[nrays];
        for (int i = 0; i < nrays; ++i) {
            int ngates = sw.getGateNumber();
            assert (ngates > 0);
            float[] d = sw.readData(i);
            assert (null != d);
            float azi = sw.getAzimuth(i);
            assert (azi > 0.0f);
            az[i] = azi;
            float ele = sw.getElevation(i);
            assert (ele > 0.0f);
            float la = (float)sw.getOrigin(i).getLatitude();
            assert (la > 0.0f);
            float lo = (float)sw.getOrigin(i).getLongitude();
            assert (lo > 0.0f);
            float al = (float)sw.getOrigin(i).getAltitude();
            assert (al > 0.0f);
        }
        assert (0 != nrays);
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/nssl/netcdf.ncml";
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(FeatureType.RADIAL, fileIn, null, new StringBuilder());
        rds.getRadarID();
        rds.getDataVariables();
        RadialDatasetSweep.RadialVariable rf = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("Reflectivity");
        rf.getSweep(0);
        Netcdf2Dataset.testRadialVariable(rf);
    }

    private class Netcdf2Variable
    extends RadialDatasetSweepAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        ArrayList sweeps;
        int nsweeps;
        String name;

        private Netcdf2Variable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
            super(Netcdf2Dataset.this, v.getShortName(), v0.getAttributes());
            this.sweeps = new ArrayList();
            this.nsweeps = 0;
            this.name = v.getShortName();
            int[] shape = v0.getShape();
            int count = v0.getRank() - 1;
            int ngates = shape[count];
            int nrays = shape[--count];
            this.nsweeps = shape.length == 3 ? shape[--count] : 1;
            for (int i = 0; i < this.nsweeps; ++i) {
                this.sweeps.add(new Netcdf2Sweep(v0, i, nrays, ngates));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public float[] readAllData() throws IOException {
            Array allData;
            RadialDatasetSweep.Sweep spn = (RadialDatasetSweep.Sweep)this.sweeps.get(0);
            Variable v = spn.getsweepVar();
            try {
                allData = v.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        @Override
        public int getNumSweeps() {
            return this.nsweeps;
        }

        @Override
        public RadialDatasetSweep.Sweep getSweep(int sweepNo) {
            return (RadialDatasetSweep.Sweep)this.sweeps.get(sweepNo);
        }

        @Override
        public void clearVariableMemory() {
        }

        private class Netcdf2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;
            int sweepno;
            int nrays;
            int ngates;
            Variable sweepVar;

            Netcdf2Sweep(Variable v, int sweepno, int rays, int gates) {
                this.sweepno = sweepno;
                this.nrays = rays;
                this.ngates = gates;
                this.sweepVar = v;
            }

            @Override
            public Variable getsweepVar() {
                return this.sweepVar;
            }

            @Override
            public float[] readData() throws IOException {
                Array allData;
                int[] shape = this.sweepVar.getShape();
                int[] origind = new int[this.sweepVar.getRank()];
                if (Netcdf2Dataset.this.isVolume) {
                    origind[0] = this.sweepno;
                    origind[1] = 0;
                    shape[0] = 1;
                }
                try {
                    allData = this.sweepVar.read(origind, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                int nradials = shape[0];
                int ngates = shape[1];
                IndexIterator dataIter = allData.getIndexIterator();
                for (int j = 0; j < nradials; ++j) {
                    for (int i = 0; i < ngates; ++i) {
                        float tp = dataIter.getFloatNext();
                        if (tp != -32768.0f && tp != -99900.0f) continue;
                        dataIter.setFloatCurrent(Float.NaN);
                    }
                }
                return (float[])allData.get1DJavaArray(Float.TYPE);
            }

            @Override
            public float[] readData(int ray) throws IOException {
                Array rayData;
                int[] shape = this.sweepVar.getShape();
                int[] origind = new int[this.sweepVar.getRank()];
                if (Netcdf2Dataset.this.isVolume) {
                    origind[0] = this.sweepno;
                    origind[1] = ray;
                    shape[0] = 1;
                    shape[1] = 1;
                } else {
                    shape[0] = 1;
                    origind[0] = ray;
                }
                try {
                    rayData = this.sweepVar.read(origind, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                int ngates = shape[1];
                IndexIterator dataIter = rayData.getIndexIterator();
                for (int i = 0; i < ngates; ++i) {
                    float tp = dataIter.getFloatNext();
                    if (tp != -32768.0f && tp != -99900.0f) continue;
                    dataIter.setFloatCurrent(Float.NaN);
                }
                return (float[])rayData.get1DJavaArray(Float.TYPE);
            }

            private void setMeanElevation() {
                if (Netcdf2Dataset.this.isVolume) {
                    try {
                        Variable sp = Netcdf2Dataset.this.ds.findVariable("sweep");
                        Array spData = sp.read();
                        float[] spArray = (float[])spData.get1DJavaArray(Float.TYPE);
                        this.meanElevation = spArray[this.sweepno];
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanElevation = 0.0;
                    }
                } else {
                    Attribute data = Netcdf2Dataset.this.ds.findGlobalAttribute("Elevation");
                    this.meanElevation = data.getNumericValue().doubleValue();
                }
            }

            @Override
            public float getMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    this.setMeanElevation();
                }
                return (float)this.meanElevation;
            }

            public double meanDouble(Array a) {
                double sum = 0.0;
                int size = 0;
                IndexIterator iterA = a.getIndexIterator();
                while (iterA.hasNext()) {
                    double s = iterA.getDoubleNext();
                    if (Double.isNaN(s)) continue;
                    sum += s;
                    ++size;
                }
                if (size > 0) {
                    return sum / (double)size;
                }
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public int getGateNumber() {
                return this.ngates;
            }

            @Override
            public int getRadialNumber() {
                return this.nrays;
            }

            @Override
            public RadialDatasetSweep.Type getType() {
                return null;
            }

            @Override
            public EarthLocation getOrigin(int ray) {
                return Netcdf2Dataset.this.origin;
            }

            @Override
            public Date getStartingTime() {
                return Netcdf2Dataset.this.startDate;
            }

            @Override
            public Date getEndingTime() {
                return Netcdf2Dataset.this.endDate;
            }

            @Override
            public int getSweepIndex() {
                return this.sweepno;
            }

            private void setMeanAzimuth() {
                this.meanAzimuth = 0.0;
            }

            @Override
            public float getMeanAzimuth() {
                if (Double.isNaN(this.meanAzimuth)) {
                    this.setMeanAzimuth();
                }
                return (float)this.meanAzimuth;
            }

            public boolean isConic() {
                return true;
            }

            @Override
            public float getElevation(int ray) throws IOException {
                return (float)this.meanElevation;
            }

            @Override
            public float[] getElevation() throws IOException {
                float[] dataValue = new float[this.nrays];
                for (int i = 0; i < this.nrays; ++i) {
                    dataValue[i] = (float)this.meanElevation;
                }
                return dataValue;
            }

            @Override
            public float[] getAzimuth() throws IOException {
                Array aziData = Netcdf2Dataset.this.ds.findVariable("Azimuth").read();
                return (float[])aziData.get1DJavaArray(Float.TYPE);
            }

            @Override
            public float getAzimuth(int ray) throws IOException {
                String aziName = "Azimuth";
                try {
                    Array aziData = Netcdf2Dataset.this.ds.findVariable(aziName).read();
                    if (Netcdf2Dataset.this.isVolume) {
                        int[] aziOrigin = new int[]{this.sweepno, 0};
                        int[] aziShape = new int[]{1, this.getRadialNumber()};
                        aziData = aziData.section(aziOrigin, aziShape);
                    }
                    Index index = aziData.getIndex();
                    return aziData.getFloat(index.set(ray));
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            public float getRadialDistance(int gate) throws IOException {
                float gateStart = this.getRangeToFirstGate();
                Variable gateSize = Netcdf2Dataset.this.ds.findVariable("GateWidth");
                float[] data = (float[])gateSize.read().get1DJavaArray(Float.TYPE);
                float dist = gateStart + (float)gate * data[0];
                return dist;
            }

            @Override
            public float getTime(int ray) throws IOException {
                return Netcdf2Dataset.this.startDate.getTime();
            }

            @Override
            public float getBeamWidth() {
                return 0.95f;
            }

            @Override
            public float getNyquistFrequency() {
                return 0.0f;
            }

            @Override
            public float getRangeToFirstGate() {
                Attribute firstGate = Netcdf2Dataset.this.ds.findGlobalAttributeIgnoreCase("RangeToFirstGate");
                double gateStart = firstGate.getNumericValue().doubleValue();
                return (float)gateStart;
            }

            @Override
            public float getGateSize() {
                try {
                    return this.getRadialDistance(1) - this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            @Override
            public void clearSweepMemory() {
            }
        }
    }
}

