/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.flow.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.CapabilityLanguageFlow;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.Language;
import org.apache.uima.flow.CasFlowController_ImplBase;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.flow.impl.AnalysisSequenceCapabilityNode;
import org.apache.uima.flow.impl.CapabilityLanguageFlowObject;
import org.apache.uima.flow.impl.FixedFlowController;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class CapabilityLanguageFlowController
extends CasFlowController_ImplBase {
    private List<AnalysisSequenceCapabilityNode> mStaticSequence;
    private Map<String, AnalysisEngineMetaData> mComponentMetaDataMap;
    private Map<String, List<AnalysisSequenceCapabilityNode>> mFlowTable;
    private final Map<String, ResultSpecification> lastResultSpecForComponent = new HashMap<String, ResultSpecification>();
    private static final char LANGUAGE_SEPARATOR = '-';

    @Override
    public void initialize(FlowControllerContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mComponentMetaDataMap = aContext.getAnalysisEngineMetaDataMap();
        this.mStaticSequence = new ArrayList<AnalysisSequenceCapabilityNode>();
        CapabilityLanguageFlow flowConstraints = (CapabilityLanguageFlow)aContext.getAggregateMetadata().getFlowConstraints();
        for (String aeKey : flowConstraints.getCapabilityLanguageFlow()) {
            this.mStaticSequence.add(new AnalysisSequenceCapabilityNode(aeKey, this.mComponentMetaDataMap.get(aeKey).getCapabilities(), null));
        }
        this.mFlowTable = this.computeFlowTable(aContext.getAggregateMetadata().getCapabilities());
    }

    @Override
    public Flow computeFlow(CAS aCAS) throws AnalysisEngineProcessException {
        CapabilityLanguageFlowObject flow = new CapabilityLanguageFlowObject(this.mFlowTable, this);
        flow.setCas(aCAS);
        return flow;
    }

    protected Map<String, List<AnalysisSequenceCapabilityNode>> computeFlowTable(Capability[] aCapabilities) {
        HashMap<String, List<AnalysisSequenceCapabilityNode>> flowTable = new HashMap<String, List<AnalysisSequenceCapabilityNode>>();
        HashSet<String> languages = new HashSet<String>();
        for (Capability capability : aCapabilities) {
            for (String capabilityLanguage : capability.getLanguagesSupported()) {
                languages.add(capabilityLanguage);
            }
        }
        for (String capabilityLanguage : languages) {
            flowTable.put(capabilityLanguage, this.computeSequence(capabilityLanguage, aCapabilities));
        }
        return flowTable;
    }

    protected List<AnalysisSequenceCapabilityNode> computeSequence(String language, Capability[] aCapabilities) {
        language = Language.normalize(language);
        ResultSpecification aggrResultsToProduce = UIMAFramework.getResourceSpecifierFactory().createResultSpecification();
        if (aCapabilities == null) {
            return null;
        }
        aggrResultsToProduce.addCapabilities(aCapabilities);
        ArrayList<AnalysisSequenceCapabilityNode> newSequence = new ArrayList<AnalysisSequenceCapabilityNode>();
        for (int sequenceIndex = 0; sequenceIndex < this.mStaticSequence.size(); ++sequenceIndex) {
            TypeOrFeature[] tofsNeeded = aggrResultsToProduce.getResultTypesAndFeatures(language);
            int index = language.indexOf(45);
            if (index >= 0) {
                HashSet<TypeOrFeature> outputSpec = new HashSet<TypeOrFeature>();
                if (tofsNeeded.length > 0) {
                    for (TypeOrFeature outputCapability : tofsNeeded) {
                        outputSpec.add(outputCapability);
                    }
                    for (TypeOrFeature outputCapability : tofsNeeded = aggrResultsToProduce.getResultTypesAndFeatures(language.substring(0, index))) {
                        outputSpec.add(outputCapability);
                    }
                    tofsNeeded = new TypeOrFeature[outputSpec.size()];
                    outputSpec.toArray(tofsNeeded);
                } else {
                    tofsNeeded = aggrResultsToProduce.getResultTypesAndFeatures(language.substring(0, index));
                }
            }
            ResultSpecification currentAnalysisResultSpec = null;
            boolean shouldEngineBeCalled = false;
            AnalysisSequenceCapabilityNode node = this.mStaticSequence.get(sequenceIndex);
            ResultSpecification delegateProduces = node.getCapabilityContainer();
            currentAnalysisResultSpec = UIMAFramework.getResourceSpecifierFactory().createResultSpecification();
            for (TypeOrFeature tof : tofsNeeded) {
                if ((!tof.isType() || !delegateProduces.containsType(tof.getName(), language)) && (tof.isType() || !delegateProduces.containsFeature(tof.getName(), language))) continue;
                currentAnalysisResultSpec.addResultTypeOrFeature(tof);
                shouldEngineBeCalled = true;
                aggrResultsToProduce.removeTypeOrFeature(tof);
            }
            if (shouldEngineBeCalled) {
                node.setResultSpec(currentAnalysisResultSpec);
                newSequence.add((AnalysisSequenceCapabilityNode)node.clone());
                continue;
            }
            newSequence.add(null);
        }
        return newSequence;
    }

    public static FlowControllerDescription getDescription() {
        FlowControllerDescription desc;
        URL descUrl = FixedFlowController.class.getResource("/org/apache/uima/flow/CapabilityLanguageFlowController.xml");
        try {
            desc = (FlowControllerDescription)UIMAFramework.getXMLParser().parse(new XMLInputSource(descUrl));
        }
        catch (InvalidXMLException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IOException e) {
            throw new UIMARuntimeException(e);
        }
        return desc;
    }

    public Map<String, ResultSpecification> getLastResultSpecForComponent() {
        return this.lastResultSpecForComponent;
    }
}

