/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

abstract class CommonAuxHeap {
    private static final boolean debugLogShrink = false;
    protected static final int DEFAULT_HEAP_BASE_SIZE = 16;
    protected static final int DEFAULT_HEAP_MULT_LIMIT = 0x1000000;
    protected static final int MIN_HEAP_BASE_SIZE = 16;
    protected static final int GROWTH_FACTOR = 2;
    protected static final int NULL = 0;
    protected static final int FIRST_CELL_REF = 1;
    protected final int heapBaseSize;
    protected final int heapMultLimit;
    protected int heapPos = 1;
    private final int[] shrinkableCount = new int[1];

    CommonAuxHeap() {
        this(16, 0x1000000);
    }

    CommonAuxHeap(int heapBaseSize, int heapMultLimit) {
        this.heapBaseSize = Math.max(heapBaseSize, 16);
        this.heapMultLimit = Math.max(heapMultLimit, 0x1000000);
        this.initMemory();
    }

    abstract void initMemory();

    abstract void initMemory(int var1);

    abstract void resetToZeros();

    abstract void growHeapIfNeeded();

    void reset() {
        this.reset(false);
    }

    void reset(boolean doFullReset) {
        if (doFullReset) {
            this.initMemory();
        } else {
            int curSize;
            int curCapacity = this.getCapacity();
            int newSize = CommonAuxHeap.computeShrunkArraySize(curCapacity, curSize = this.getSize(), 2, this.heapMultLimit, this.heapBaseSize, this.shrinkableCount);
            if (newSize == this.getCapacity()) {
                this.resetToZeros();
            } else {
                this.initMemory(newSize);
            }
        }
        this.heapPos = 1;
    }

    int reserve(int numCells) {
        int cellRef = this.heapPos;
        this.heapPos += numCells;
        this.growHeapIfNeeded();
        return cellRef;
    }

    int computeNewArraySize(int size, int needed_size, int growth_factor, int multiplication_limit) {
        do {
            if (size < multiplication_limit) {
                size *= growth_factor;
                continue;
            }
            size += multiplication_limit;
        } while (size < needed_size);
        return size;
    }

    static int computeShrunkArraySize(int capacity, int size_used, int growth_factor, int multiplication_limit, int min_size, int[] shrinkableCount) {
        boolean isShrink;
        int oneSizeLowerCapacity;
        if (capacity < size_used) {
            throw new IllegalArgumentException("The Capacity " + capacity + " must be >= sized_used " + size_used);
        }
        int n = oneSizeLowerCapacity = capacity - multiplication_limit < multiplication_limit ? capacity / growth_factor : capacity - multiplication_limit;
        if (oneSizeLowerCapacity < min_size) {
            return capacity;
        }
        boolean bl = isShrink = size_used < oneSizeLowerCapacity;
        if (isShrink) {
            shrinkableCount[0] = shrinkableCount[0] + 1;
            if (shrinkableCount[0] > 20) {
                shrinkableCount[0] = 16;
                return oneSizeLowerCapacity;
            }
            return capacity;
        }
        shrinkableCount[0] = 0;
        return capacity;
    }

    int getSize() {
        return this.heapPos;
    }

    abstract int getCapacity();
}

